/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import javax.swing.AbstractButton;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.tool.IconDrawer;
import org.scijava.tool.IconService;
import org.scijava.tool.Tool;
import org.scijava.util.ColorRGB;

@Plugin(type=Service.class)
public class SwingIconService
extends AbstractService
implements IconService {
    private final HashMap<Tool, AbstractButton> buttonMap = new HashMap();

    @Override
    public IconDrawer acquireDrawer(Tool tool) {
        if (!this.buttonMap.containsKey(tool)) {
            return null;
        }
        return new SwingIconDrawer(tool);
    }

    public void registerButton(Tool tool, AbstractButton button) {
        this.buttonMap.put(tool, button);
    }

    private class SwingIconDrawer
    implements IconDrawer {
        private final AbstractButton button;
        private final Graphics graphics;

        public SwingIconDrawer(Tool tool) {
            this.button = (AbstractButton)SwingIconService.this.buttonMap.get(tool);
            this.graphics = this.button.getGraphics();
        }

        @Override
        public int getIconRectangleWidth() {
            return this.button.getWidth();
        }

        @Override
        public int getIconRectangleHeight() {
            return this.button.getHeight();
        }

        @Override
        public void setIconPixel(int x, int y, ColorRGB color) {
            Color awtColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
            this.graphics.setColor(awtColor);
            this.graphics.drawLine(x, y, x, y);
        }
    }
}

