/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.scijava.app.AppService;
import org.scijava.display.Display;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.menu.MenuService;
import org.scijava.menu.ShadowMenu;
import org.scijava.platform.event.AppMenusCreatedEvent;
import org.scijava.plugin.Parameter;
import org.scijava.thread.ThreadService;
import org.scijava.ui.AbstractUserInterface;
import org.scijava.ui.SystemClipboard;
import org.scijava.ui.UIService;
import org.scijava.ui.awt.AWTClipboard;
import org.scijava.ui.awt.AWTDropTargetEventDispatcher;
import org.scijava.ui.awt.AWTInputEventDispatcher;
import org.scijava.ui.awt.AWTWindowEventDispatcher;
import org.scijava.ui.swing.SwingApplicationFrame;
import org.scijava.ui.swing.SwingStatusBar;
import org.scijava.ui.swing.SwingToolBar;
import org.scijava.ui.swing.SwingUI;
import org.scijava.ui.swing.console.SwingConsolePane;
import org.scijava.ui.swing.laf.SwingLookAndFeelService;
import org.scijava.ui.swing.menu.SwingJMenuBarCreator;
import org.scijava.ui.swing.menu.SwingJPopupMenuCreator;
import org.scijava.ui.viewer.DisplayViewer;

public abstract class AbstractSwingUI
extends AbstractUserInterface
implements SwingUI {
    @Parameter
    private AppService appService;
    @Parameter
    private EventService eventService;
    @Parameter
    private MenuService menuService;
    @Parameter
    private UIService uiService;
    @Parameter(required=false)
    private SwingLookAndFeelService lafService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private LogService log;
    private SwingApplicationFrame appFrame;
    private SwingToolBar toolBar;
    private SwingStatusBar statusBar;
    private SwingConsolePane consolePane;
    private AWTClipboard systemClipboard;

    @Override
    public SwingApplicationFrame getApplicationFrame() {
        return this.appFrame;
    }

    @Override
    public SwingToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public SwingStatusBar getStatusBar() {
        return this.statusBar;
    }

    public SwingConsolePane getConsolePane() {
        return this.consolePane;
    }

    @Override
    public SystemClipboard getSystemClipboard() {
        return this.systemClipboard;
    }

    @Override
    public File chooseFile(File file, String style) {
        File[] result = new File[1];
        try {
            this.threadService.invoke(() -> {
                int rval;
                JFileChooser chooser = new JFileChooser(file);
                if ("directory".equals(style)) {
                    chooser.setFileSelectionMode(1);
                }
                if ((rval = "save".equals(style) ? chooser.showSaveDialog(this.appFrame) : chooser.showOpenDialog(this.appFrame)) == 0) {
                    result[0] = chooser.getSelectedFile();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exc) {
            this.log.error(exc);
        }
        return result[0];
    }

    @Override
    public File[] chooseFiles(File parent, File[] files, final FileFilter filter, String style) {
        File[][] result = new File[1][];
        try {
            this.threadService.invoke(() -> {
                int rval;
                JFileChooser chooser = new JFileChooser(parent);
                chooser.setMultiSelectionEnabled(true);
                if (style.equals("both")) {
                    chooser.setFileSelectionMode(2);
                } else if (style.equals("directories")) {
                    chooser.setFileSelectionMode(1);
                } else {
                    chooser.setFileSelectionMode(0);
                }
                chooser.setSelectedFiles(files);
                if (filter != null) {
                    javax.swing.filechooser.FileFilter fileFilter = new javax.swing.filechooser.FileFilter(){

                        @Override
                        public String getDescription() {
                            return filter.toString();
                        }

                        @Override
                        public boolean accept(File f) {
                            if (filter.accept(f)) {
                                return true;
                            }
                            return f.isDirectory();
                        }
                    };
                    chooser.setFileFilter(fileFilter);
                }
                if ((rval = chooser.showOpenDialog(this.appFrame)) == 0) {
                    result[0] = chooser.getSelectedFiles();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exc) {
            this.log.error(exc);
        }
        return result[0];
    }

    @Override
    public void showContextMenu(String menuRoot, Display<?> display, int x, int y) {
        ShadowMenu shadowMenu = this.menuService.getMenu(menuRoot);
        JPopupMenu popupMenu = new JPopupMenu();
        new SwingJPopupMenuCreator().createMenus(shadowMenu, popupMenu);
        DisplayViewer<?> displayViewer = this.uiService.getDisplayViewer(display);
        if (displayViewer != null) {
            Component invoker = (Component)((Object)displayViewer.getPanel());
            popupMenu.show(invoker, x, y);
        }
    }

    @Override
    public boolean requiresEDT() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.appFrame != null) {
            this.appFrame.dispose();
        }
    }

    @Override
    protected void createUI() {
        if (this.lafService != null) {
            this.lafService.initLookAndFeel();
        }
        if (!Boolean.getBoolean("scijava.noConsole")) {
            this.consolePane = new SwingConsolePane(this.getContext());
        }
        JMenuBar menuBar = this.createMenus();
        this.appFrame = new SwingApplicationFrame(this.appService.getApp().getTitle());
        if (menuBar != null) {
            this.appFrame.setJMenuBar(menuBar);
        }
        this.toolBar = new SwingToolBar(this.getContext());
        this.statusBar = new SwingStatusBar(this.getContext());
        this.systemClipboard = new AWTClipboard();
        this.setupAppFrame();
        super.createUI();
        this.appFrame.setDefaultCloseOperation(0);
        this.appFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AbstractSwingUI.this.appService.getApp().quit();
            }
        });
        this.appFrame.getContentPane().add((Component)this.toolBar, "North");
        this.appFrame.getContentPane().add((Component)this.statusBar, "South");
        AWTInputEventDispatcher inputDispatcher = new AWTInputEventDispatcher(null, this.eventService);
        this.appFrame.addEventDispatcher(inputDispatcher);
        this.statusBar.addEventDispatcher(inputDispatcher);
        AWTWindowEventDispatcher windowDispatcher = new AWTWindowEventDispatcher(this.eventService);
        windowDispatcher.register((Window)this.appFrame);
        AWTDropTargetEventDispatcher dropTargetDispatcher = new AWTDropTargetEventDispatcher(null, this.eventService);
        dropTargetDispatcher.register((Component)this.toolBar);
        dropTargetDispatcher.register((Component)this.statusBar);
        dropTargetDispatcher.register((Component)this.appFrame);
        this.setupConsole();
        this.appFrame.pack();
        this.appFrame.setVisible(true);
    }

    protected JMenuBar createMenus() {
        JMenuBar menuBar = this.menuService.createMenus(new SwingJMenuBarCreator(), new JMenuBar());
        AppMenusCreatedEvent appMenusCreatedEvent = new AppMenusCreatedEvent(menuBar);
        this.eventService.publish(appMenusCreatedEvent);
        if (appMenusCreatedEvent.isConsumed()) {
            return null;
        }
        appMenusCreatedEvent.consume();
        return menuBar;
    }

    protected JMenuBar createConsoleMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu edit = new JMenu("Edit");
        menuBar.add(edit);
        JMenuItem editClear = new JMenuItem("Clear");
        editClear.addActionListener(e -> this.getConsolePane().clear());
        edit.add(editClear);
        return menuBar;
    }

    protected abstract void setupAppFrame();

    protected abstract void setupConsole();
}

