/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.text.TextWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.imagearchive.lsm.reader.info.ImageDirectory;
import org.imagearchive.lsm.reader.info.LSMFileInfo;
import org.imagearchive.lsm.toolbox.MasterModel;
import org.imagearchive.lsm.toolbox.Reader;
import org.imagearchive.lsm.toolbox.ServiceMediator;
import org.imagearchive.lsm.toolbox.gui.DetailsFrame;
import org.imagearchive.lsm.toolbox.gui.NotesDialog;
import org.imagearchive.lsm.toolbox.info.CZLSMInfoExtended;
import org.imagearchive.lsm.toolbox.info.EventList;
import org.imagearchive.lsm.toolbox.info.scaninfo.Recording;

public class InfoFrame
extends JFrame {
    private final MasterModel masterModel = MasterModel.getMasterModel();
    private final DetailsFrame detailsFrame;
    private final NotesDialog notesDialog;
    private final int infoFrameXsize = 300;
    private final int infoFrameYsize = 400;
    private final JLabel[] infolab = new JLabel[22];
    private final JTextArea[] area = new JTextArea[22];

    public InfoFrame() throws HeadlessException {
        this.detailsFrame = new DetailsFrame();
        this.notesDialog = new NotesDialog(this, true);
        this.initializeGUI();
        ServiceMediator.registerInfoFrame(this);
    }

    public void initializeGUI() {
        this.setTitle("General file information");
        this.setSize(300, 400);
        this.getContentPane().setLayout(new BorderLayout());
        String[] infolabels = new String[]{"File Name", "User", "Image Width", "Image Height", "Number of channels", "Z Stack size", "Time Stack size", "Scan Type", "Voxel X size", "Voxel Y size", "Voxel Z size", "Objective", "X zoom factor", "Y zoom factor", "Z zoom factor", "Plane width", "Plane height", "Volume depth", "Plane spacing"};
        JPanel infopanel = new JPanel(new GridLayout(19, 2, 3, 3));
        Font dafont = new Font(null);
        float fontsize = 11.0f;
        dafont = dafont.deriveFont(11.0f);
        Font dafontbold = dafont.deriveFont(1);
        for (int i = 0; i < 19; ++i) {
            this.infolab[i] = new JLabel("  " + infolabels[i]);
            this.infolab[i].setFont(dafontbold);
            infopanel.add(this.infolab[i]);
            this.area[i] = new JTextArea("");
            this.area[i].setEditable(false);
            this.area[i].setFont(dafont);
            infopanel.add(this.area[i]);
        }
        JButton details_button = new JButton(new ImageIcon(this.getClass().getResource("images/plus.png")));
        details_button.setToolTipText("More details...");
        this.addDetailsListener(details_button, this);
        JButton notes_button = new JButton(new ImageIcon(this.getClass().getResource("images/info.png")));
        notes_button.setToolTipText("Notes");
        this.addNotesButtonListener(notes_button, this);
        JButton dumpinfos_button = new JButton(new ImageIcon(this.getClass().getResource("images/dump.png")));
        dumpinfos_button.setToolTipText("Dump to text file");
        this.addDumpInfosListener(dumpinfos_button, this);
        JButton events_button = new JButton(new ImageIcon(this.getClass().getResource("images/events.png")));
        details_button.setToolTipText("Events...");
        this.addEventsListener(events_button, this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(events_button);
        buttonPanel.add(notes_button);
        buttonPanel.add(dumpinfos_button);
        buttonPanel.add(details_button);
        this.getContentPane().add((Component)buttonPanel, "North");
        this.getContentPane().add((Component)infopanel, "Center");
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                InfoFrame.this.updateInfoFrame();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                if (InfoFrame.this.detailsFrame != null) {
                    InfoFrame.this.detailsFrame.dispose();
                }
            }
        });
        this.updateInfoFrame();
        this.pack();
        this.centerWindow();
    }

    public void updateInfoFrame() {
        String[] str = this.getInfo();
        if (str == null) {
            return;
        }
        for (int i = 0; i < 19; ++i) {
            if (str[i] == null) continue;
            this.area[i].setText(str[i]);
        }
    }

    private void addDumpInfosListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoFrame.this.dumpInfo();
            }
        });
    }

    private void addEventsListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp == null) {
                    IJ.error((String)"No open images.");
                    return;
                }
                Reader reader = ServiceMediator.getReader();
                reader.updateMetadata(imp);
                LSMFileInfo openLSM = (LSMFileInfo)imp.getOriginalFileInfo();
                CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)openLSM.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
                EventList events = cz.eventList;
                if (events != null) {
                    String header = new String("Time (sec) \tEvent Type \tEvent Description");
                    TextWindow tw = new TextWindow("Time Events for " + imp.getTitle(), header, (String)null, 400, 200);
                    tw.append(events.Description);
                } else {
                    IJ.error((String)"No events defined in the LSM file.");
                }
            }
        });
    }

    private void addDetailsListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!InfoFrame.this.detailsFrame.isShowing()) {
                    InfoFrame.this.detailsFrame.setVisible(true);
                } else {
                    InfoFrame.this.detailsFrame.setVisible(false);
                }
            }
        });
    }

    private void addNotesButtonListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!InfoFrame.this.notesDialog.isShowing()) {
                    InfoFrame.this.notesDialog.setNotes();
                    InfoFrame.this.notesDialog.setVisible(true);
                } else {
                    InfoFrame.this.notesDialog.setVisible(false);
                }
            }
        });
    }

    public String[] getInfo() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return null;
        }
        Reader reader = ServiceMediator.getReader();
        reader.updateMetadata(imp);
        if (imp.getOriginalFileInfo() instanceof LSMFileInfo) {
            LSMFileInfo lsm = (LSMFileInfo)imp.getOriginalFileInfo();
            ArrayList imageDirectories = lsm.imageDirectories;
            ImageDirectory imDir = (ImageDirectory)imageDirectories.get(0);
            if (imDir == null) {
                return null;
            }
            CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)imDir.TIF_CZ_LSMINFO);
            String[] infos = new String[19];
            String stacksize = IJ.d2s((double)cz.DimensionZ, (int)0);
            String width = IJ.d2s((double)lsm.width, (int)0);
            String height = IJ.d2s((double)lsm.height, (int)0);
            String channels = IJ.d2s((double)cz.DimensionChannels, (int)0);
            String scantype = "";
            switch (cz.ScanType) {
                case 0: {
                    scantype = "Normal X-Y-Z scan";
                    break;
                }
                case 1: {
                    scantype = "Z scan";
                    break;
                }
                case 2: {
                    scantype = "Line scan";
                    break;
                }
                case 3: {
                    scantype = "Time series X-Y";
                    break;
                }
                case 4: {
                    scantype = "Time series X-Z";
                    break;
                }
                case 5: {
                    scantype = "Time series - Means of ROIs";
                    break;
                }
                case 6: {
                    scantype = "Time series X-Y-Z";
                    break;
                }
                case 10: {
                    scantype = "Point mode";
                    break;
                }
                default: {
                    scantype = "UNKNOWN !";
                }
            }
            Recording r = cz.scanInfo.recordings.get(0);
            String objective = (String)r.records.get("ENTRY_OBJECTIVE");
            String user = (String)r.records.get("USER");
            double zoomx = (Double)r.records.get("ZOOM_X");
            double zoomy = (Double)r.records.get("ZOOM_Y");
            double zoomz = (Double)r.records.get("ZOOM_Z");
            double planeSpacing = (Double)r.records.get("PLANE_SPACING");
            String voxelsize_x = IJ.d2s((double)(cz.VoxelSizeX * 1000000.0), (int)2) + " " + MasterModel.micrometer;
            String voxelsize_y = IJ.d2s((double)(cz.VoxelSizeY * 1000000.0), (int)2) + " " + MasterModel.micrometer;
            String voxelsize_z = IJ.d2s((double)(cz.VoxelSizeZ * 1000000.0), (int)2) + " " + MasterModel.micrometer;
            String timestacksize = IJ.d2s((double)cz.DimensionTime, (int)0);
            String plane_spacing = IJ.d2s((double)(planeSpacing * 1000000.0), (int)2) + " " + MasterModel.micrometer;
            String plane_width = IJ.d2s((double)((double)cz.DimensionX * cz.VoxelSizeX), (int)2) + " " + MasterModel.micrometer;
            String plane_height = IJ.d2s((double)((double)cz.DimensionY * cz.VoxelSizeY), (int)2) + " " + MasterModel.micrometer;
            String volume_depth = IJ.d2s((double)((double)cz.DimensionZ * cz.VoxelSizeZ), (int)2) + " " + MasterModel.micrometer;
            infos[0] = lsm.fileName;
            infos[1] = user;
            infos[2] = width;
            infos[3] = height;
            infos[4] = channels;
            infos[5] = stacksize;
            infos[6] = timestacksize;
            infos[7] = scantype;
            infos[8] = voxelsize_x;
            infos[9] = voxelsize_y;
            infos[10] = voxelsize_z;
            infos[11] = objective;
            infos[12] = IJ.d2s((double)zoomx, (int)2);
            infos[13] = IJ.d2s((double)zoomy, (int)2);
            infos[14] = IJ.d2s((double)zoomz, (int)2);
            infos[15] = plane_width;
            infos[16] = plane_height;
            infos[17] = volume_depth;
            infos[18] = plane_spacing;
            return infos;
        }
        return null;
    }

    private void dumpInfo() {
        String header = new String("Parameter\tValue");
        TextWindow tw = new TextWindow("LSM Infos DUMP", header, (String)null, 280, 450);
        String[] Parameters = new String[26];
        Parameters[0] = "File Name";
        Parameters[1] = "User";
        Parameters[2] = "Image Width";
        Parameters[3] = "Image Height";
        Parameters[4] = "Number of channels";
        Parameters[5] = "Z Stack size";
        Parameters[6] = "Time Stack size";
        Parameters[7] = "Scan Type";
        Parameters[8] = "Voxel X size";
        Parameters[9] = "Voxel Y size";
        Parameters[10] = "Voxel Z size";
        Parameters[11] = "Objective";
        Parameters[12] = "X Zoom factor";
        Parameters[13] = "Y Zoom factor";
        Parameters[14] = "Z Zoom factor";
        Parameters[15] = "Plane width";
        Parameters[16] = "Plane height";
        Parameters[17] = "Volume depth";
        Parameters[18] = "Plane spacing";
        String[] infos = this.getInfo();
        if (infos != null) {
            for (int i = 0; i < 19; ++i) {
                tw.append(Parameters[i] + "\t" + infos[i]);
            }
        }
    }

    public DetailsFrame getDetailsFrame() {
        return this.detailsFrame;
    }

    public void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }
}

