/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import edu.emory.mathcs.backport.java.util.concurrent.DelayQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Delayed;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.Label;
import net.sf.retrotranslator.runtime.asm.MethodAdapter;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.transformer.ClassReplacement;
import net.sf.retrotranslator.transformer.ClassVersion;
import net.sf.retrotranslator.transformer.MemberKey;
import net.sf.retrotranslator.transformer.MemberReplacement;
import net.sf.retrotranslator.transformer.NameTranslator;
import net.sf.retrotranslator.transformer.OperationMode;
import net.sf.retrotranslator.transformer.ReplacementLocator;
import net.sf.retrotranslator.transformer.TransformerTools;

class SpecificReplacementVisitor
extends ClassAdapter {
    private static final String THREAD_NAME;
    private static final String DELAY_QUEUE_NAME;
    private static final String SOFT_REFERENCE_NAME;
    private static final String WEAK_REFERENCE_NAME;
    private static final String COLLECTIONS_NAME;
    private static final String REENTRANT_READ_WRITE_LOCK_NAME;
    private static final MemberKey UNCAUGHT_EXCEPTION_HANDLER_KEY;
    private final ClassVersion target;
    private final ReplacementLocator locator;
    private final OperationMode mode;
    private MemberReplacement uncaughtExceptionHandler;
    static /* synthetic */ Class class$java$lang$ref$WeakReference;
    static /* synthetic */ Class class$java$util$Collections;
    static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$concurrent$DelayQueue;
    static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$concurrent$locks$ReentrantReadWriteLock;
    static /* synthetic */ Class class$java$lang$ref$SoftReference;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Thread;

    public SpecificReplacementVisitor(ClassVisitor visitor, ClassVersion target, ReplacementLocator locator, OperationMode mode) {
        super(visitor);
        this.target = target;
        this.locator = locator;
        this.mode = mode;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.uncaughtExceptionHandler = this.getUncaughtExceptionHandler(superName);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (visitor == null) {
            return null;
        }
        visitor = new SpecificReplacementMethodVisitor(visitor);
        if (this.uncaughtExceptionHandler != null && name.equals("run") && desc.equals(TransformerTools.descriptor(Void.TYPE, new Class[0]))) {
            visitor = new RunMethodVisitor(visitor);
        }
        return visitor;
    }

    private String getReplacementField(String methodName) {
        if (!this.target.isBefore(ClassVersion.VERSION_15)) {
            return null;
        }
        if (this.target.isBefore(ClassVersion.VERSION_12)) {
            return null;
        }
        if (methodName.equals("emptyList")) {
            return "EMPTY_LIST";
        }
        if (methodName.equals("emptySet")) {
            return "EMPTY_SET";
        }
        if (this.target.isBefore(ClassVersion.VERSION_13)) {
            return null;
        }
        if (methodName.equals("emptyMap")) {
            return "EMPTY_MAP";
        }
        return null;
    }

    private MemberReplacement getUncaughtExceptionHandler(String superName) {
        if (!THREAD_NAME.equals(superName)) {
            return null;
        }
        if (!this.mode.isSupportedFeature("Thread.setDefaultUncaughtExceptionHandler") && !this.mode.isSupportedFeature("Thread.setUncaughtExceptionHandler")) {
            return null;
        }
        ClassReplacement threadReplacement = this.locator.getReplacement(THREAD_NAME);
        if (threadReplacement == null) {
            return null;
        }
        return threadReplacement.getMethodReplacements().get(UNCAUGHT_EXCEPTION_HANDLER_KEY);
    }

    static {
        Class<?> clazz = class$java$lang$Thread;
        if (clazz == null) {
            clazz = class$java$lang$Thread = new Thread[0].getClass().getComponentType();
        }
        THREAD_NAME = Type.getInternalName(clazz);
        Class<?> clazz2 = class$edu$emory$mathcs$backport$java$util$concurrent$DelayQueue;
        if (clazz2 == null) {
            clazz2 = class$edu$emory$mathcs$backport$java$util$concurrent$DelayQueue = new DelayQueue[0].getClass().getComponentType();
        }
        DELAY_QUEUE_NAME = Type.getInternalName(clazz2);
        Class<?> clazz3 = class$java$lang$ref$SoftReference;
        if (clazz3 == null) {
            clazz3 = class$java$lang$ref$SoftReference = new SoftReference[0].getClass().getComponentType();
        }
        SOFT_REFERENCE_NAME = Type.getInternalName(clazz3);
        Class<?> clazz4 = class$java$lang$ref$WeakReference;
        if (clazz4 == null) {
            clazz4 = class$java$lang$ref$WeakReference = new WeakReference[0].getClass().getComponentType();
        }
        WEAK_REFERENCE_NAME = Type.getInternalName(clazz4);
        Class<?> clazz5 = class$java$util$Collections;
        if (clazz5 == null) {
            clazz5 = class$java$util$Collections = new Collections[0].getClass().getComponentType();
        }
        COLLECTIONS_NAME = Type.getInternalName(clazz5);
        Class<?> clazz6 = class$edu$emory$mathcs$backport$java$util$concurrent$locks$ReentrantReadWriteLock;
        if (clazz6 == null) {
            clazz6 = class$edu$emory$mathcs$backport$java$util$concurrent$locks$ReentrantReadWriteLock = new ReentrantReadWriteLock[0].getClass().getComponentType();
        }
        REENTRANT_READ_WRITE_LOCK_NAME = Type.getInternalName(clazz6);
        Class[] classArray = new Class[1];
        Class<?> clazz7 = class$java$lang$Throwable;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Throwable = new Throwable[0].getClass().getComponentType();
        }
        classArray[0] = clazz7;
        UNCAUGHT_EXCEPTION_HANDLER_KEY = new MemberKey(true, "handleUncaughtException", TransformerTools.descriptor(Void.TYPE, classArray));
    }

    private class SpecificReplacementMethodVisitor
    extends MethodAdapter {
        static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$concurrent$locks$ReentrantReadWriteLock$ReadLock;
        static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$concurrent$Delayed;
        static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$concurrent$locks$Lock;
        static /* synthetic */ Class class$java$lang$ref$ReferenceQueue;
        static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$concurrent$locks$ReentrantReadWriteLock$WriteLock;
        static /* synthetic */ Class class$java$lang$Object;

        public SpecificReplacementMethodVisitor(MethodVisitor visitor) {
            super(visitor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (this.fixReference(opcode, owner, name, desc)) {
                return;
            }
            if (this.fixDelayQueue(opcode, owner, name, desc)) {
                return;
            }
            if (this.fixLock(opcode, owner, name, desc)) {
                return;
            }
            if (this.fixCollections(opcode, owner, name, desc)) {
                return;
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        private boolean fixReference(int opcode, String owner, String name, String desc) {
            Class clazz;
            if (opcode != 183 || !name.equals("<init>")) {
                return false;
            }
            if (owner.equals(SOFT_REFERENCE_NAME)) {
                if (!SpecificReplacementVisitor.this.mode.isSupportedFeature("SoftReference.NullReferenceQueue")) {
                    return false;
                }
            } else if (owner.equals(WEAK_REFERENCE_NAME)) {
                if (!SpecificReplacementVisitor.this.mode.isSupportedFeature("WeakReference.NullReferenceQueue")) {
                    return false;
                }
            } else {
                return false;
            }
            if (!SpecificReplacementVisitor.this.target.isBefore(ClassVersion.VERSION_15)) {
                return false;
            }
            Class[] classArray = new Class[2];
            Class clazz2 = class$java$lang$Object;
            if (clazz2 == null) {
                clazz2 = classArray[0] = (class$java$lang$Object = new Object[0].getClass().getComponentType());
            }
            if ((clazz = class$java$lang$ref$ReferenceQueue) == null) {
                clazz = classArray[1] = (class$java$lang$ref$ReferenceQueue = new ReferenceQueue[0].getClass().getComponentType());
            }
            if (!desc.equals(TransformerTools.descriptor(Void.TYPE, classArray))) {
                return false;
            }
            Label notNullLabel = new Label();
            Label continueLabel = new Label();
            this.mv.visitInsn(89);
            this.mv.visitJumpInsn(199, notNullLabel);
            this.mv.visitInsn(87);
            Class[] classArray2 = new Class[1];
            Class<?> clazz3 = class$java$lang$Object;
            if (clazz3 == null) {
                clazz3 = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            classArray2[0] = clazz3;
            this.mv.visitMethodInsn(183, owner, "<init>", TransformerTools.descriptor(Void.TYPE, classArray2));
            this.mv.visitJumpInsn(167, continueLabel);
            this.mv.visitLabel(notNullLabel);
            this.mv.visitMethodInsn(183, owner, "<init>", desc);
            this.mv.visitLabel(continueLabel);
            return true;
        }

        private boolean fixDelayQueue(int opcode, String owner, String name, String desc) {
            if (!owner.equals(DELAY_QUEUE_NAME)) {
                return false;
            }
            String fixedDesc = new NameTranslator(){
                static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$concurrent$Delayed;
                static /* synthetic */ Class class$java$lang$Object;

                protected String typeName(String s) {
                    String string;
                    Class<?> clazz = class$edu$emory$mathcs$backport$java$util$concurrent$Delayed;
                    if (clazz == null) {
                        clazz = class$edu$emory$mathcs$backport$java$util$concurrent$Delayed = new Delayed[0].getClass().getComponentType();
                    }
                    if (Type.getInternalName(clazz).equals(s)) {
                        Class<?> clazz2 = class$java$lang$Object;
                        if (clazz2 == null) {
                            clazz2 = class$java$lang$Object = new Object[0].getClass().getComponentType();
                        }
                        string = Type.getInternalName(clazz2);
                    } else {
                        string = s;
                    }
                    return string;
                }
            }.methodDescriptor(desc);
            this.mv.visitMethodInsn(opcode, owner, name, fixedDesc);
            Type returnType = Type.getReturnType(desc);
            Class<?> clazz = class$edu$emory$mathcs$backport$java$util$concurrent$Delayed;
            if (clazz == null) {
                clazz = class$edu$emory$mathcs$backport$java$util$concurrent$Delayed = new Delayed[0].getClass().getComponentType();
            }
            if (returnType.equals(Type.getType(clazz))) {
                this.mv.visitTypeInsn(192, returnType.getInternalName());
            }
            return true;
        }

        private boolean fixLock(int opcode, String owner, String name, String desc) {
            block8: {
                Class<?> clazz;
                Type returnType;
                block7: {
                    if (!owner.equals(REENTRANT_READ_WRITE_LOCK_NAME)) {
                        return false;
                    }
                    returnType = Type.getReturnType(desc);
                    Class<?> clazz2 = class$edu$emory$mathcs$backport$java$util$concurrent$locks$ReentrantReadWriteLock$ReadLock;
                    if (clazz2 == null) {
                        clazz2 = class$edu$emory$mathcs$backport$java$util$concurrent$locks$ReentrantReadWriteLock$ReadLock = new ReentrantReadWriteLock.ReadLock[0].getClass().getComponentType();
                    }
                    if (returnType.equals(Type.getType(clazz2))) break block7;
                    Class<?> clazz3 = class$edu$emory$mathcs$backport$java$util$concurrent$locks$ReentrantReadWriteLock$WriteLock;
                    if (clazz3 == null) {
                        clazz3 = class$edu$emory$mathcs$backport$java$util$concurrent$locks$ReentrantReadWriteLock$WriteLock = new ReentrantReadWriteLock.WriteLock[0].getClass().getComponentType();
                    }
                    if (!returnType.equals(Type.getType(clazz3))) break block8;
                }
                if ((clazz = class$edu$emory$mathcs$backport$java$util$concurrent$locks$Lock) == null) {
                    clazz = class$edu$emory$mathcs$backport$java$util$concurrent$locks$Lock = new Lock[0].getClass().getComponentType();
                }
                desc = Type.getMethodDescriptor(Type.getType(clazz), Type.getArgumentTypes(desc));
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                this.mv.visitTypeInsn(192, returnType.getInternalName());
                return true;
            }
            return false;
        }

        private boolean fixCollections(int opcode, String owner, String name, String desc) {
            if (opcode != 184 || !owner.equals(COLLECTIONS_NAME)) {
                return false;
            }
            String field = SpecificReplacementVisitor.this.getReplacementField(name);
            if (field == null) {
                return false;
            }
            this.mv.visitFieldInsn(178, COLLECTIONS_NAME, field, Type.getReturnType(desc).toString());
            return true;
        }
    }

    private class RunMethodVisitor
    extends MethodAdapter {
        private final Label start;
        static /* synthetic */ Class class$java$lang$Throwable;

        public RunMethodVisitor(MethodVisitor visitor) {
            super(visitor);
            this.start = new Label();
        }

        public void visitCode() {
            this.mv.visitLabel(this.start);
            super.visitCode();
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            Label end = new Label();
            this.mv.visitLabel(end);
            this.mv.visitMethodInsn(184, SpecificReplacementVisitor.this.uncaughtExceptionHandler.getOwner(), SpecificReplacementVisitor.this.uncaughtExceptionHandler.getName(), SpecificReplacementVisitor.this.uncaughtExceptionHandler.getDesc());
            this.mv.visitInsn(177);
            Class<?> clazz = class$java$lang$Throwable;
            if (clazz == null) {
                clazz = class$java$lang$Throwable = new Throwable[0].getClass().getComponentType();
            }
            this.mv.visitTryCatchBlock(this.start, end, end, Type.getInternalName(clazz));
            super.visitMaxs(maxStack, maxLocals);
        }
    }
}

