/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import net.sf.retrotranslator.transformer.Backport;
import net.sf.retrotranslator.transformer.ClassVersion;
import net.sf.retrotranslator.transformer.OperationMode;
import net.sf.retrotranslator.transformer.ReplacementLocator;
import net.sf.retrotranslator.transformer.TargetEnvironment;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplacementLocatorFactory {
    private final OperationMode mode;
    private final boolean retainapi;
    private final List<Backport> backports;
    private final TargetEnvironment environment;
    private SoftReference<ReplacementLocator> softReference = new SoftReference<Object>(null);

    public ReplacementLocatorFactory(OperationMode mode, boolean retainapi, String backport, TargetEnvironment environment) {
        this.mode = mode;
        this.retainapi = retainapi;
        this.environment = environment;
        this.backports = new Vector<Backport>();
        for (String s : this.getBackportNames(backport)) {
            this.backports.addAll(Backport.getBackports(s));
        }
    }

    private Collection<String> getBackportNames(String backport) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (backport != null) {
            result.addAll(Arrays.asList(backport.split(";")));
        }
        if (!this.retainapi) {
            ClassVersion target = this.mode.getTarget();
            result.addAll(this.environment.readRegistry("backport", target));
            if (target.isBefore(ClassVersion.VERSION_15)) {
                result.add("java.lang.StringBuilder:java.lang.StringBuffer");
            }
        }
        return result;
    }

    public OperationMode getMode() {
        return this.mode;
    }

    public boolean isRetainapi() {
        return this.retainapi;
    }

    public synchronized ReplacementLocator getLocator() {
        ReplacementLocator locator = this.softReference.get();
        if (locator == null) {
            locator = new ReplacementLocator(this.mode, this.backports, this.environment);
            this.softReference = new SoftReference<ReplacementLocator>(locator);
        }
        return locator;
    }
}

