/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.List;
import java.util.Map;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.MethodAdapter;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.transformer.InstantiationPoint;
import net.sf.retrotranslator.transformer.MemberReplacement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstantiationReplacementVisitor
extends ClassAdapter {
    private final Map<String, List<InstantiationPoint>> pointListMap;

    public InstantiationReplacementVisitor(ClassVisitor visitor, Map<String, List<InstantiationPoint>> pointListMap) {
        super(visitor);
        this.pointListMap = pointListMap;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        List<InstantiationPoint> points = this.pointListMap.get(new StringBuffer().append(name).append(desc).toString());
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        return visitor == null || points == null ? visitor : new InstantiationReplacementMethodVisitor(visitor, points);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstantiationReplacementMethodVisitor
    extends MethodAdapter {
        private final List<InstantiationPoint> points;
        private int allocationIndex;
        private int duplicationIndex;
        private int initializationIndex;

        public InstantiationReplacementMethodVisitor(MethodVisitor mv, List<InstantiationPoint> points) {
            super(mv);
            this.points = points;
        }

        @Override
        public void visitTypeInsn(int opcode, String desc) {
            if (opcode == 187) {
                int index = ++this.allocationIndex;
                for (InstantiationPoint point : this.points) {
                    if (point.getAllocationIndex() != index) continue;
                    return;
                }
            }
            super.visitTypeInsn(opcode, desc);
        }

        @Override
        public void visitInsn(int opcode) {
            if (opcode == 89) {
                int index = ++this.duplicationIndex;
                for (InstantiationPoint point : this.points) {
                    if (point.getDuplicationIndex() != index) continue;
                    return;
                }
            }
            super.visitInsn(opcode);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 183 && name.equals("<init>")) {
                int index = ++this.initializationIndex;
                for (InstantiationPoint point : this.points) {
                    if (point.getInitializationIndex() != index) continue;
                    if (!owner.equals(point.getInternalName())) {
                        throw new IllegalStateException();
                    }
                    MemberReplacement replacement = point.getReplacement();
                    this.mv.visitMethodInsn(184, replacement.getOwner(), replacement.getName(), replacement.getDesc());
                    return;
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }
}

