/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.LinkedList;
import net.sf.retrotranslator.transformer.InstantiationPoint;

class InstantiationFrame {
    private boolean initialized;
    private LinkedList<InstantiationPoint> stack;

    public InstantiationFrame(boolean initialized) {
        this.initialized = initialized;
    }

    public InstantiationFrame(InstantiationFrame frame) {
        this.initialized = frame.initialized;
        if (frame.stack != null && !frame.stack.isEmpty()) {
            this.stack = new LinkedList<InstantiationPoint>(frame.stack);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void addLast(InstantiationPoint point) {
        if (this.stack == null) {
            this.stack = new LinkedList();
        }
        this.stack.addLast(point);
    }

    public InstantiationPoint pollLast() {
        return this.stack == null || this.stack.isEmpty() ? null : this.stack.removeLast();
    }
}

