/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.retrotranslator.transformer.FileContainer;
import net.sf.retrotranslator.transformer.FileEntry;
import net.sf.retrotranslator.transformer.SystemLogger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FolderFileContainer
extends FileContainer {
    private Map<String, FolderFileEntry> entries;

    public FolderFileContainer(File location) {
        super(location);
    }

    public FolderFileContainer(File location, List<String> fileNames) {
        super(location);
        this.initEntries();
        for (String fileName : fileNames) {
            String name = fileName.replace(File.separatorChar, '/');
            this.entries.put(name, new FolderFileEntry(name, new File(location, name), false));
        }
    }

    @Override
    public Collection<? extends FileEntry> getEntries() {
        if (this.entries == null) {
            this.initEntries();
            this.scanFolder(this.location, this.location.getPath().length() + 1);
        }
        return new ArrayList<FolderFileEntry>(this.entries.values());
    }

    @Override
    public void removeEntry(String name) {
        if (this.entries != null) {
            FolderFileEntry entry = this.entries.remove(name);
            if (entry != null) {
                entry.file.delete();
            }
        } else {
            new File(this.location, name).delete();
        }
    }

    private void scanFolder(File folder, int prefixLength) {
        for (File file : folder.listFiles()) {
            String name = file.getPath().substring(prefixLength).replace(File.separatorChar, '/');
            if (file.isDirectory()) {
                this.scanFolder(file, prefixLength);
                continue;
            }
            this.entries.put(name, new FolderFileEntry(name, file, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEntry(String name, byte[] contents, boolean modified) {
        this.initEntries();
        File file = new File(this.location, name);
        this.entries.put(name, new FolderFileEntry(name, file, modified));
        file.getParentFile().mkdirs();
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                stream.write(contents);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void initEntries() {
        if (this.entries == null) {
            this.entries = new LinkedHashMap<String, FolderFileEntry>();
        }
    }

    @Override
    public void flush(SystemLogger logger) {
        this.initEntries();
    }

    @Override
    public boolean containsUpToDate(String name, long sourceTime) {
        if (sourceTime == 0L) {
            return false;
        }
        long targetTime = new File(this.location, name).lastModified();
        return targetTime != 0L && targetTime > sourceTime;
    }

    @Override
    public long lastModified() {
        long result = 0L;
        for (FileEntry fileEntry : this.getEntries()) {
            result = Math.max(result, fileEntry.lastModified());
        }
        return result;
    }

    private static class FolderFileEntry
    extends FileEntry {
        private File file;

        public FolderFileEntry(String name, File file, boolean modified) {
            super(name, modified);
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getContent() {
            byte[] byArray;
            FileInputStream stream = new FileInputStream(this.file);
            try {
                byArray = FileContainer.readFully(stream, (int)this.file.length());
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
            return byArray;
        }

        public long lastModified() {
            return this.file.lastModified();
        }
    }
}

