/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import net.sf.retrotranslator.transformer.FileEntry;
import net.sf.retrotranslator.transformer.SystemLogger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FileContainer {
    protected File location;

    protected FileContainer(File location) {
        this.location = location;
    }

    public File getLocation() {
        return this.location;
    }

    public abstract Collection<? extends FileEntry> getEntries();

    public abstract void removeEntry(String var1);

    public abstract void putEntry(String var1, byte[] var2, boolean var3);

    public abstract void flush(SystemLogger var1);

    public abstract boolean containsUpToDate(String var1, long var2);

    public abstract long lastModified();

    protected static byte[] readFully(InputStream stream, int length) throws IOException {
        int count;
        if (length <= 0) {
            length = 32768;
        }
        byte[] buffer = new byte[length];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(length);
        while ((count = stream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
        }
        return outputStream.toByteArray();
    }

    public String toString() {
        return this.location.toString();
    }

    public int getFileCount() {
        return this.getEntries().size();
    }
}

