/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.HashMap;
import java.util.List;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.ClassWriter;
import net.sf.retrotranslator.runtime.impl.BytecodeTransformer;
import net.sf.retrotranslator.transformer.AnnotationStrippingVisitor;
import net.sf.retrotranslator.transformer.ClassLiteralVisitor;
import net.sf.retrotranslator.transformer.ClassVersion;
import net.sf.retrotranslator.transformer.DuplicateInterfacesVisitor;
import net.sf.retrotranslator.transformer.DuplicateMethodsVisitor;
import net.sf.retrotranslator.transformer.EmbeddingConverter;
import net.sf.retrotranslator.transformer.GeneralReplacementVisitor;
import net.sf.retrotranslator.transformer.InheritedConstantVisitor;
import net.sf.retrotranslator.transformer.InnerClassVisitor;
import net.sf.retrotranslator.transformer.InstantiationAnalysisVisitor;
import net.sf.retrotranslator.transformer.InstantiationPoint;
import net.sf.retrotranslator.transformer.InstantiationReplacementVisitor;
import net.sf.retrotranslator.transformer.MemberReplacement;
import net.sf.retrotranslator.transformer.MemoryModelVisitor;
import net.sf.retrotranslator.transformer.MethodCounter;
import net.sf.retrotranslator.transformer.MirandaMethodsVisitor;
import net.sf.retrotranslator.transformer.ObjectMethodsVisitor;
import net.sf.retrotranslator.transformer.PrefixingVisitor;
import net.sf.retrotranslator.transformer.ReflectionDataVisitor;
import net.sf.retrotranslator.transformer.ReflectionInitVisitor;
import net.sf.retrotranslator.transformer.ReflectionMode;
import net.sf.retrotranslator.transformer.ReplacementLocator;
import net.sf.retrotranslator.transformer.ReplacementLocatorFactory;
import net.sf.retrotranslator.transformer.SignatureStrippingVisitor;
import net.sf.retrotranslator.transformer.SpecificReplacementVisitor;
import net.sf.retrotranslator.transformer.SynchronizedBlockVisitor;
import net.sf.retrotranslator.transformer.SystemLogger;
import net.sf.retrotranslator.transformer.TransformerTools;
import net.sf.retrotranslator.transformer.VersionVisitor;

class ClassTransformer
implements BytecodeTransformer {
    private final boolean lazy;
    private final boolean stripsign;
    private final boolean stripannot;
    private final boolean retainflags;
    private final boolean syncvolatile;
    private final boolean syncfinal;
    private final boolean keepclasslit;
    private final ReflectionMode reflectionMode;
    private final EmbeddingConverter converter;
    private final SystemLogger logger;
    private final ReplacementLocatorFactory factory;

    public ClassTransformer(boolean lazy, boolean stripsign, boolean stripannot, boolean retainflags, boolean syncvolatile, boolean syncfinal, boolean keepclasslit, ReflectionMode reflectionMode, SystemLogger logger, EmbeddingConverter converter, ReplacementLocatorFactory factory) {
        this.lazy = lazy;
        this.stripsign = stripsign;
        this.stripannot = stripannot;
        this.retainflags = retainflags;
        this.syncvolatile = syncvolatile;
        this.syncfinal = syncfinal;
        this.keepclasslit = keepclasslit;
        this.reflectionMode = reflectionMode;
        this.converter = converter;
        this.logger = logger;
        this.factory = factory;
    }

    public byte[] transform(byte[] bytes, int offset, int length) {
        MemberReplacement replacement;
        byte[] bytecode;
        ClassVersion target = this.factory.getMode().getTarget();
        if (this.lazy && !target.isBefore(TransformerTools.getClassVersion(bytes, offset))) {
            if (offset == 0 && length == bytes.length) {
                return bytes;
            }
            byte[] result = new byte[length];
            System.arraycopy(bytes, offset, result, 0, length);
            return result;
        }
        ReplacementLocator locator = this.factory.getLocator();
        MethodCounter counter = new MethodCounter();
        HashMap<String, List<InstantiationPoint>> pointListMap = new HashMap<String, List<InstantiationPoint>>();
        ClassWriter classWriter = new ClassWriter(true);
        ClassVisitor visitor = new InstantiationAnalysisVisitor(classWriter, locator, pointListMap, this.logger);
        visitor = new DuplicateInterfacesVisitor(new VersionVisitor(visitor, target), this.logger, counter);
        if (target.isBefore(ClassVersion.VERSION_12)) {
            visitor = new MirandaMethodsVisitor(visitor, locator);
        }
        if (target.isBefore(ClassVersion.VERSION_13)) {
            visitor = new InheritedConstantVisitor(new SynchronizedBlockVisitor(visitor), locator);
        }
        if (target.isBefore(ClassVersion.VERSION_15) && (this.syncvolatile || this.syncfinal)) {
            visitor = new MemoryModelVisitor(visitor, locator.getEnvironment(), this.syncvolatile, this.syncfinal);
        }
        if (target.isBefore(ClassVersion.VERSION_14)) {
            visitor = new InnerClassVisitor(visitor);
        }
        if (target.isBefore(ClassVersion.VERSION_15)) {
            visitor = new ObjectMethodsVisitor(new ClassLiteralVisitor(visitor), locator);
        }
        if (!this.factory.isRetainapi()) {
            visitor = new SpecificReplacementVisitor(visitor, target, locator, this.factory.getMode());
        }
        visitor = new GeneralReplacementVisitor(visitor, locator, this.keepclasslit);
        new ClassReader(bytes, offset, length).accept(visitor, false);
        if (counter.containsDuplicates()) {
            bytecode = classWriter.toByteArray();
            classWriter = new ClassWriter(true);
            pointListMap.clear();
            visitor = new InstantiationAnalysisVisitor(classWriter, locator, pointListMap, this.logger);
            new ClassReader(bytecode).accept(new DuplicateMethodsVisitor(visitor, this.logger, counter), false);
        }
        if (!pointListMap.isEmpty()) {
            bytecode = classWriter.toByteArray();
            classWriter = new ClassWriter(true);
            new ClassReader(bytecode).accept(new InstantiationReplacementVisitor(classWriter, pointListMap), false);
        }
        if (this.converter != null) {
            bytecode = classWriter.toByteArray();
            classWriter = new ClassWriter(true);
            new ClassReader(bytecode).accept(new PrefixingVisitor(classWriter, this.converter), false);
        }
        if (this.reflectionMode == ReflectionMode.SAFE && (replacement = ReflectionInitVisitor.getMethodReplacement(locator)) != null) {
            byte[] bytecode2 = classWriter.toByteArray();
            ReflectionDataVisitor dataVisitor = new ReflectionDataVisitor();
            new ClassReader(bytecode2).accept(dataVisitor, true);
            classWriter = new ClassWriter(true);
            visitor = new ReflectionInitVisitor(classWriter, replacement, this.converter, dataVisitor.toByteArray());
            new ClassReader(bytecode2).accept(visitor, false);
        }
        if (this.stripsign || this.stripannot) {
            bytecode = classWriter.toByteArray();
            ClassVisitor stripVisitor = classWriter = new ClassWriter(true);
            if (this.stripsign) {
                stripVisitor = new SignatureStrippingVisitor(stripVisitor);
            }
            if (this.stripannot) {
                stripVisitor = new AnnotationStrippingVisitor(stripVisitor);
            }
            new ClassReader(bytecode).accept(stripVisitor, false);
        }
        return classWriter.toByteArray(target.isBefore(ClassVersion.VERSION_15) && !this.retainflags);
    }
}

