/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import net.sf.retrotranslator.runtime.asm.Attribute;
import net.sf.retrotranslator.runtime.asm.Label;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;

abstract class AbstractMethodVisitor
implements MethodVisitor {
    protected final MethodVisitor mv;

    protected AbstractMethodVisitor(MethodVisitor mv) {
        this.mv = mv;
    }

    protected abstract void flush();

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.flush();
        return this.mv.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.flush();
        return this.mv.visitAnnotationDefault();
    }

    public void visitAttribute(Attribute attr) {
        this.flush();
        this.mv.visitAttribute(attr);
    }

    public void visitCode() {
        this.flush();
        this.mv.visitCode();
    }

    public void visitEnd() {
        this.flush();
        this.mv.visitEnd();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.flush();
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitIincInsn(int var, int increment) {
        this.flush();
        this.mv.visitIincInsn(var, increment);
    }

    public void visitInsn(int opcode) {
        this.flush();
        this.mv.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.flush();
        this.mv.visitIntInsn(opcode, operand);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.flush();
        this.mv.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.flush();
        this.mv.visitLabel(label);
    }

    public void visitLdcInsn(Object cst) {
        this.flush();
        this.mv.visitLdcInsn(cst);
    }

    public void visitLineNumber(int line, Label start) {
        this.flush();
        this.mv.visitLineNumber(line, start);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.flush();
        this.mv.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.flush();
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.flush();
        this.mv.visitMaxs(maxStack, maxLocals);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.flush();
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.flush();
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.flush();
        return this.mv.visitParameterAnnotation(parameter, desc, visible);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.flush();
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.flush();
        this.mv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.flush();
        this.mv.visitTypeInsn(opcode, desc);
    }

    public void visitVarInsn(int opcode, int var) {
        this.flush();
        this.mv.visitVarInsn(opcode, var);
    }
}

