/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.stats;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;

public class Normalize {
    public static <T extends NumericType<T> & Comparable<T>> void normalize(IterableInterval<T> iterable, T min, T max) {
        Cursor cursor = iterable.cursor();
        NumericType currentMax = (NumericType)((NumericType)cursor.next()).copy();
        NumericType currentMin = (NumericType)currentMax.copy();
        for (NumericType t : iterable) {
            if (((Comparable)t).compareTo(currentMax) > 0) {
                currentMax.set((Type)t);
                continue;
            }
            if (((Comparable)t).compareTo(currentMin) >= 0) continue;
            currentMin.set((Type)t);
        }
        NumericType scale = (NumericType)max.copy();
        scale.sub(min);
        NumericType currentScale = currentMax;
        currentScale.sub((Object)currentMin);
        for (NumericType t : iterable) {
            t.sub((Object)currentMin);
            t.mul((Object)scale);
            t.div((Object)currentScale);
            t.add(min);
        }
    }
}

