/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodLocalizableSampler;

public final class RectangleNeighborhoodRandomAccess<T>
extends RectangleNeighborhoodLocalizableSampler<T>
implements RandomAccess<Neighborhood<T>> {
    public RectangleNeighborhoodRandomAccess(RandomAccessible<T> source, Interval span, RectangleNeighborhoodFactory<T> factory) {
        super(source, span, factory, null);
    }

    public RectangleNeighborhoodRandomAccess(RandomAccessible<T> source, Interval span, RectangleNeighborhoodFactory<T> factory, Interval interval) {
        super(source, span, factory, interval);
    }

    private RectangleNeighborhoodRandomAccess(RectangleNeighborhoodRandomAccess<T> c) {
        super(c);
    }

    public void fwd(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + 1L;
        int n2 = d;
        this.currentMin[n2] = this.currentMin[n2] + 1L;
        int n3 = d;
        this.currentMax[n3] = this.currentMax[n3] + 1L;
    }

    public void bck(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] - 1L;
        int n2 = d;
        this.currentMin[n2] = this.currentMin[n2] - 1L;
        int n3 = d;
        this.currentMax[n3] = this.currentMax[n3] - 1L;
    }

    public void move(int distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + (long)distance;
        int n2 = d;
        this.currentMin[n2] = this.currentMin[n2] + (long)distance;
        int n3 = d;
        this.currentMax[n3] = this.currentMax[n3] + (long)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + distance;
        int n2 = d;
        this.currentMin[n2] = this.currentMin[n2] + distance;
        int n3 = d;
        this.currentMax[n3] = this.currentMax[n3] + distance;
    }

    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            long distance = localizable.getLongPosition(d);
            int n = d;
            this.currentPos[n] = this.currentPos[n] + distance;
            int n2 = d;
            this.currentMin[n2] = this.currentMin[n2] + distance;
            int n3 = d++;
            this.currentMax[n3] = this.currentMax[n3] + distance;
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + (long)distance[d];
            int n2 = d;
            this.currentMin[n2] = this.currentMin[n2] + (long)distance[d];
            int n3 = d;
            this.currentMax[n3] = this.currentMax[n3] + (long)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + distance[d];
            int n2 = d;
            this.currentMin[n2] = this.currentMin[n2] + distance[d];
            int n3 = d;
            this.currentMax[n3] = this.currentMax[n3] + distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            long position;
            this.currentPos[d] = position = localizable.getLongPosition(d);
            this.currentMin[d] = position + this.span.min(d);
            this.currentMax[d] = position + this.span.max(d);
        }
    }

    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
            this.currentMin[d] = (long)position[d] + this.span.min(d);
            this.currentMax[d] = (long)position[d] + this.span.max(d);
        }
    }

    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
            this.currentMin[d] = position[d] + this.span.min(d);
            this.currentMax[d] = position[d] + this.span.max(d);
        }
    }

    public void setPosition(int position, int d) {
        this.currentPos[d] = position;
        this.currentMin[d] = (long)position + this.span.min(d);
        this.currentMax[d] = (long)position + this.span.max(d);
    }

    public void setPosition(long position, int d) {
        this.currentPos[d] = position;
        this.currentMin[d] = position + this.span.min(d);
        this.currentMax[d] = position + this.span.max(d);
    }

    public RectangleNeighborhoodRandomAccess<T> copy() {
        return new RectangleNeighborhoodRandomAccess<T>(this);
    }
}

