/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.PeriodicLineNeighborhoodFactory;
import net.imglib2.util.Intervals;

public class PeriodicLineNeighborhood<T>
extends AbstractLocalizable
implements Neighborhood<T> {
    private final long span;
    private final int[] increments;
    private final RandomAccess<T> sourceRandomAccess;
    private final Interval structuringElementBoundingBox;
    private final long maxIndex;

    public static <T> PeriodicLineNeighborhoodFactory<T> factory() {
        return new PeriodicLineNeighborhoodFactory<T>(){

            @Override
            public Neighborhood<T> create(long[] position, long span, int[] increments, RandomAccess<T> sourceRandomAccess) {
                return new PeriodicLineNeighborhood(position, span, increments, sourceRandomAccess);
            }
        };
    }

    PeriodicLineNeighborhood(long[] position, long span, int[] increments, RandomAccess<T> sourceRandomAccess) {
        super(position);
        this.increments = increments;
        this.span = span;
        this.maxIndex = 2L * span + 1L;
        this.sourceRandomAccess = sourceRandomAccess;
        this.structuringElementBoundingBox = this.createInterval();
    }

    @Override
    public Interval getStructuringElementBoundingBox() {
        return this.structuringElementBoundingBox;
    }

    public long size() {
        return this.maxIndex;
    }

    public T firstElement() {
        return this.cursor().next();
    }

    public Object iterationOrder() {
        return this;
    }

    public double realMin(int d) {
        return this.structuringElementBoundingBox.realMin(d);
    }

    public void realMin(double[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.structuringElementBoundingBox.realMin(d);
        }
    }

    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.structuringElementBoundingBox.realMin(d), d);
        }
    }

    public double realMax(int d) {
        return this.structuringElementBoundingBox.realMax(d);
    }

    public void realMax(double[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.structuringElementBoundingBox.realMax(d);
        }
    }

    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.structuringElementBoundingBox.realMax(d), d);
        }
    }

    public Iterator<T> iterator() {
        return this.cursor();
    }

    public long min(int d) {
        return this.structuringElementBoundingBox.min(d);
    }

    public void min(long[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.structuringElementBoundingBox.min(d);
        }
    }

    public void min(Positionable min) {
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.structuringElementBoundingBox.min(d), d);
        }
    }

    public long max(int d) {
        return this.structuringElementBoundingBox.max(d);
    }

    public void max(long[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.structuringElementBoundingBox.max(d);
        }
    }

    public void max(Positionable max) {
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.structuringElementBoundingBox.max(d), d);
        }
    }

    public void dimensions(long[] dimensions) {
        for (int d = 0; d < this.n; ++d) {
            dimensions[d] = this.dimension(d);
        }
    }

    public long dimension(int d) {
        return 1L + 2L * this.span * (long)Math.abs(this.increments[d]);
    }

    public LocalCursor cursor() {
        return new LocalCursor(this.sourceRandomAccess.copy());
    }

    public LocalCursor localizingCursor() {
        return this.cursor();
    }

    private Interval createInterval() {
        int i;
        long[] minmax = new long[2 * this.position.length];
        for (i = 0; i < this.position.length; ++i) {
            minmax[i] = this.position[i] - this.span * (long)Math.abs(this.increments[i]);
        }
        for (i = this.position.length; i < minmax.length; ++i) {
            minmax[i] = this.position[i - this.position.length] + this.span * (long)Math.abs(this.increments[i - this.position.length]);
        }
        return Intervals.createMinMax((long[])minmax);
    }

    public final class LocalCursor
    extends AbstractEuclideanSpace
    implements Cursor<T> {
        private final RandomAccess<T> source;
        private long index;

        private LocalCursor(RandomAccess<T> source) {
            super(source.numDimensions());
            this.source = source;
            this.reset();
        }

        private LocalCursor(LocalCursor c) {
            super(c.numDimensions());
            this.source = c.source.copy();
            this.index = c.index;
        }

        public T get() {
            return this.source.get();
        }

        public void fwd() {
            this.source.move(PeriodicLineNeighborhood.this.increments);
            ++this.index;
        }

        public void jumpFwd(long steps) {
            int i = 0;
            while ((long)i < steps) {
                this.fwd();
                ++i;
            }
        }

        public T next() {
            this.fwd();
            return this.get();
        }

        public void remove() {
        }

        public void reset() {
            int i;
            this.source.setPosition(PeriodicLineNeighborhood.this.position);
            int[] minusIncrements = new int[PeriodicLineNeighborhood.this.increments.length];
            for (i = 0; i < minusIncrements.length; ++i) {
                minusIncrements[i] = -PeriodicLineNeighborhood.this.increments[i];
            }
            i = 0;
            while ((long)i <= PeriodicLineNeighborhood.this.span) {
                this.source.move(minusIncrements);
                ++i;
            }
            this.index = 0L;
        }

        public boolean hasNext() {
            return this.index < PeriodicLineNeighborhood.this.maxIndex;
        }

        public float getFloatPosition(int d) {
            return this.source.getFloatPosition(d);
        }

        public double getDoublePosition(int d) {
            return this.source.getDoublePosition(d);
        }

        public int getIntPosition(int d) {
            return this.source.getIntPosition(d);
        }

        public long getLongPosition(int d) {
            return this.source.getLongPosition(d);
        }

        public void localize(long[] position) {
            this.source.localize(position);
        }

        public void localize(float[] position) {
            this.source.localize(position);
        }

        public void localize(double[] position) {
            this.source.localize(position);
        }

        public void localize(int[] position) {
            this.source.localize(position);
        }

        public LocalCursor copy() {
            return new LocalCursor(this);
        }
    }
}

