/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.neighborhood.HyperSphereNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.Neighborhood;

public class HyperSphereNeighborhood<T>
extends AbstractLocalizable
implements Neighborhood<T> {
    private final RandomAccess<T> sourceRandomAccess;
    private final long radius;
    private final int maxDim;
    private final long size;
    private final Interval structuringElementBoundingBox;

    public static <T> HyperSphereNeighborhoodFactory<T> factory() {
        return new HyperSphereNeighborhoodFactory<T>(){

            @Override
            public Neighborhood<T> create(long[] position, long radius, RandomAccess<T> sourceRandomAccess) {
                return new HyperSphereNeighborhood(position, radius, sourceRandomAccess);
            }
        };
    }

    HyperSphereNeighborhood(long[] position, long radius, RandomAccess<T> sourceRandomAccess) {
        super(position);
        this.sourceRandomAccess = sourceRandomAccess;
        this.radius = radius;
        this.maxDim = this.n - 1;
        this.size = this.computeSize();
        long[] min = new long[this.n];
        long[] max = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            min[d] = -radius;
            max[d] = radius;
        }
        this.structuringElementBoundingBox = new FinalInterval(min, max);
    }

    protected long computeSize() {
        LocalCursor cursor = new LocalCursor(this.sourceRandomAccess);
        long size = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            ++size;
        }
        return size;
    }

    @Override
    public Interval getStructuringElementBoundingBox() {
        return this.structuringElementBoundingBox;
    }

    public long size() {
        return this.size;
    }

    public T firstElement() {
        return this.cursor().next();
    }

    public Object iterationOrder() {
        return this;
    }

    public double realMin(int d) {
        return this.position[d] - this.radius;
    }

    public void realMin(double[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = this.position[d] - this.radius;
        }
    }

    public void realMin(RealPositionable min) {
        for (int d = 0; d < min.numDimensions(); ++d) {
            min.setPosition(this.position[d] - this.radius, d);
        }
    }

    public double realMax(int d) {
        return this.position[d] + this.radius;
    }

    public void realMax(double[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = this.position[d] + this.radius;
        }
    }

    public void realMax(RealPositionable max) {
        for (int d = 0; d < max.numDimensions(); ++d) {
            max.setPosition(this.position[d] + this.radius, d);
        }
    }

    public Iterator<T> iterator() {
        return this.cursor();
    }

    public long min(int d) {
        return this.position[d] - this.radius;
    }

    public void min(long[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = this.position[d] - this.radius;
        }
    }

    public void min(Positionable min) {
        for (int d = 0; d < min.numDimensions(); ++d) {
            min.setPosition(this.position[d] - this.radius, d);
        }
    }

    public long max(int d) {
        return this.position[d] + this.radius;
    }

    public void max(long[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = this.position[d] + this.radius;
        }
    }

    public void max(Positionable max) {
        for (int d = 0; d < max.numDimensions(); ++d) {
            max.setPosition(this.position[d] + this.radius, d);
        }
    }

    public void dimensions(long[] dimensions) {
        for (int d = 0; d < dimensions.length; ++d) {
            dimensions[d] = 2L * this.radius + 1L;
        }
    }

    public long dimension(int d) {
        return 2L * this.radius + 1L;
    }

    public LocalCursor cursor() {
        return new LocalCursor(this.sourceRandomAccess.copy());
    }

    public LocalCursor localizingCursor() {
        return this.cursor();
    }

    public final class LocalCursor
    extends AbstractEuclideanSpace
    implements Cursor<T> {
        private final RandomAccess<T> source;
        private final double[] r;
        private final long[] ri;
        private final long[] s;

        public LocalCursor(RandomAccess<T> source) {
            super(source.numDimensions());
            this.source = source;
            this.r = new double[this.n];
            this.ri = new long[this.n];
            this.s = new long[this.n];
            this.reset();
        }

        protected LocalCursor(LocalCursor c) {
            super(c.numDimensions());
            this.source = c.source.copy();
            this.r = (double[])c.r.clone();
            this.ri = (long[])c.ri.clone();
            this.s = (long[])c.s.clone();
        }

        public T get() {
            return this.source.get();
        }

        public void fwd() {
            this.s[0] = this.s[0] - 1L;
            if (this.s[0] >= 0L) {
                this.source.fwd(0);
            } else {
                int d = 1;
                while (d < this.n) {
                    int n = d++;
                    this.s[n] = this.s[n] - 1L;
                    if (this.s[n] < 0L) continue;
                    this.source.fwd(d);
                    break;
                }
                while (d > 0) {
                    int e = d - 1;
                    double rd = this.r[d];
                    long pd = this.s[d] - this.ri[d];
                    double rad = Math.sqrt(rd * rd - (double)(pd * pd));
                    long radi = (long)rad;
                    this.r[e] = rad;
                    this.ri[e] = radi;
                    this.s[e] = 2L * radi;
                    this.source.setPosition(HyperSphereNeighborhood.this.position[e] - radi, e);
                    --d;
                }
            }
        }

        public void jumpFwd(long steps) {
            for (long i = 0L; i < steps; ++i) {
                this.fwd();
            }
        }

        public T next() {
            this.fwd();
            return this.get();
        }

        public void remove() {
        }

        public void reset() {
            for (int d = 0; d < HyperSphereNeighborhood.this.maxDim; ++d) {
                this.s[d] = 0L;
                this.ri[d] = 0L;
                this.r[d] = 0L;
                this.source.setPosition(HyperSphereNeighborhood.this.position[d], d);
            }
            this.source.setPosition(HyperSphereNeighborhood.this.position[HyperSphereNeighborhood.this.maxDim] - HyperSphereNeighborhood.this.radius - 1L, HyperSphereNeighborhood.this.maxDim);
            this.r[((HyperSphereNeighborhood)HyperSphereNeighborhood.this).maxDim] = HyperSphereNeighborhood.this.radius;
            this.ri[((HyperSphereNeighborhood)HyperSphereNeighborhood.this).maxDim] = HyperSphereNeighborhood.this.radius;
            this.s[((HyperSphereNeighborhood)HyperSphereNeighborhood.this).maxDim] = 1L + 2L * HyperSphereNeighborhood.this.radius;
        }

        public boolean hasNext() {
            return this.s[HyperSphereNeighborhood.this.maxDim] > 0L;
        }

        public float getFloatPosition(int d) {
            return this.source.getFloatPosition(d);
        }

        public double getDoublePosition(int d) {
            return this.source.getDoublePosition(d);
        }

        public int getIntPosition(int d) {
            return this.source.getIntPosition(d);
        }

        public long getLongPosition(int d) {
            return this.source.getLongPosition(d);
        }

        public void localize(long[] position) {
            this.source.localize(position);
        }

        public void localize(float[] position) {
            this.source.localize(position);
        }

        public void localize(double[] position) {
            this.source.localize(position);
        }

        public void localize(int[] position) {
            this.source.localize(position);
        }

        public LocalCursor copy() {
            return new LocalCursor(this);
        }
    }
}

