/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.HorizontalLineNeighborhood;
import net.imglib2.algorithm.neighborhood.HorizontalLineNeighborhoodCursor;
import net.imglib2.algorithm.neighborhood.HorizontalLineNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.HorizontalLineNeighborhoodRandomAccess;
import net.imglib2.algorithm.neighborhood.HorizontalLineNeighborhoodUnsafe;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.util.Intervals;

public class HorizontalLineShape
implements Shape {
    private final long span;
    private final boolean skipCenter;
    private final int dim;

    public HorizontalLineShape(long span, int dim, boolean skipCenter) {
        this.span = span;
        this.dim = dim;
        this.skipCenter = skipCenter;
    }

    public <T> NeighborhoodsIterableInterval<T> neighborhoods(RandomAccessibleInterval<T> source) {
        return new NeighborhoodsIterableInterval<T>(source, this.span, this.dim, this.skipCenter, HorizontalLineNeighborhoodUnsafe.factory());
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessible<T> source) {
        HorizontalLineNeighborhoodFactory f = HorizontalLineNeighborhoodUnsafe.factory();
        return new NeighborhoodsAccessible<T>(source, this.span, this.dim, this.skipCenter, f);
    }

    @Override
    public <T> IterableInterval<Neighborhood<T>> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        return new NeighborhoodsIterableInterval<T>(source, this.span, this.dim, this.skipCenter, HorizontalLineNeighborhood.factory());
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> source) {
        HorizontalLineNeighborhoodFactory f = HorizontalLineNeighborhood.factory();
        return new NeighborhoodsAccessible<T>(source, this.span, this.dim, this.skipCenter, f);
    }

    public boolean isSkippingCenter() {
        return this.skipCenter;
    }

    public long getSpan() {
        return this.span;
    }

    public int getLineDimension() {
        return this.dim;
    }

    public String toString() {
        return "HorizontalLineShape, span = " + this.span + " in dim " + this.dim + ", skipCenter = " + this.skipCenter;
    }

    @Override
    public Interval getStructuringElementBoundingBox(int numDimensions) {
        long[] a = new long[numDimensions];
        long[] b = new long[numDimensions];
        a[this.dim] = -this.span;
        b[this.dim] = this.span;
        return Intervals.union((Interval)new FinalInterval(a, a), (Interval)new FinalInterval(b, b));
    }

    public static final class NeighborhoodsAccessible<T>
    extends AbstractEuclideanSpace
    implements RandomAccessible<Neighborhood<T>> {
        final RandomAccessible<T> source;
        final HorizontalLineNeighborhoodFactory<T> factory;
        private final long span;
        private final int dim;
        private final boolean skipCenter;

        public NeighborhoodsAccessible(RandomAccessible<T> source, long span, int dim, boolean skipCenter, HorizontalLineNeighborhoodFactory<T> factory) {
            super(source.numDimensions());
            this.source = source;
            this.span = span;
            this.dim = dim;
            this.skipCenter = skipCenter;
            this.factory = factory;
        }

        public RandomAccess<Neighborhood<T>> randomAccess() {
            return new HorizontalLineNeighborhoodRandomAccess<T>(this.source, this.span, this.dim, this.skipCenter, this.factory);
        }

        public RandomAccess<Neighborhood<T>> randomAccess(Interval interval) {
            return this.randomAccess();
        }

        public int numDimensions() {
            return this.source.numDimensions();
        }
    }

    public static final class NeighborhoodsIterableInterval<T>
    extends AbstractInterval
    implements IterableInterval<Neighborhood<T>> {
        final RandomAccessibleInterval<T> source;
        final long span;
        final HorizontalLineNeighborhoodFactory<T> factory;
        final long size;
        final int dim;
        final boolean skipCenter;

        public NeighborhoodsIterableInterval(RandomAccessibleInterval<T> source, long span, int dim, boolean skipCenter, HorizontalLineNeighborhoodFactory<T> factory) {
            super(source);
            this.source = source;
            this.span = span;
            this.dim = dim;
            this.skipCenter = skipCenter;
            this.factory = factory;
            long s = source.dimension(0);
            for (int d = 1; d < this.n; ++d) {
                s *= source.dimension(d);
            }
            this.size = s;
        }

        public Cursor<Neighborhood<T>> cursor() {
            return new HorizontalLineNeighborhoodCursor<T>(this.source, this.span, this.dim, this.skipCenter, this.factory);
        }

        public long size() {
            return this.size;
        }

        public Neighborhood<T> firstElement() {
            return (Neighborhood)this.cursor().next();
        }

        public Object iterationOrder() {
            return new FlatIterationOrder((Interval)this);
        }

        public Iterator<Neighborhood<T>> iterator() {
            return this.cursor();
        }

        public Cursor<Neighborhood<T>> localizingCursor() {
            return this.cursor();
        }
    }
}

