/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Arrays;
import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.DiamondNeighborhood;
import net.imglib2.algorithm.neighborhood.DiamondNeighborhoodCursor;
import net.imglib2.algorithm.neighborhood.DiamondNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.DiamondNeighborhoodRandomAccess;
import net.imglib2.algorithm.neighborhood.DiamondNeighborhoodUnsafe;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;

public class DiamondShape
implements Shape {
    private final long radius;

    public DiamondShape(long radius) {
        this.radius = radius;
    }

    @Override
    public <T> IterableInterval<Neighborhood<T>> neighborhoods(RandomAccessibleInterval<T> source) {
        return new NeighborhoodsIterableInterval<T>(source, this.radius, DiamondNeighborhoodUnsafe.factory());
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessible<T> source) {
        DiamondNeighborhoodFactory f = DiamondNeighborhoodUnsafe.factory();
        return new NeighborhoodsAccessible<T>(source, this.radius, f);
    }

    public <T> NeighborhoodsIterableInterval<T> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        return new NeighborhoodsIterableInterval<T>(source, this.radius, DiamondNeighborhood.factory());
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> source) {
        return new NeighborhoodsAccessible<T>(source, this.radius, DiamondNeighborhood.factory());
    }

    public long getRadius() {
        return this.radius;
    }

    public String toString() {
        return "DiamondShape, radius = " + this.radius;
    }

    @Override
    public Interval getStructuringElementBoundingBox(int numDimensions) {
        long[] min = new long[numDimensions];
        Arrays.fill(min, -this.getRadius());
        long[] max = new long[numDimensions];
        Arrays.fill(max, this.getRadius());
        return new FinalInterval(min, max);
    }

    public static final class NeighborhoodsAccessible<T>
    extends AbstractEuclideanSpace
    implements RandomAccessible<Neighborhood<T>> {
        final RandomAccessible<T> source;
        final DiamondNeighborhoodFactory<T> factory;
        private final long radius;

        public NeighborhoodsAccessible(RandomAccessible<T> source, long radius, DiamondNeighborhoodFactory<T> factory) {
            super(source.numDimensions());
            this.source = source;
            this.radius = radius;
            this.factory = factory;
        }

        public RandomAccess<Neighborhood<T>> randomAccess() {
            return new DiamondNeighborhoodRandomAccess<T>(this.source, this.radius, this.factory);
        }

        public RandomAccess<Neighborhood<T>> randomAccess(Interval interval) {
            return this.randomAccess();
        }

        public int numDimensions() {
            return this.source.numDimensions();
        }
    }

    public static final class NeighborhoodsIterableInterval<T>
    extends AbstractInterval
    implements IterableInterval<Neighborhood<T>> {
        final RandomAccessibleInterval<T> source;
        final DiamondNeighborhoodFactory<T> factory;
        final long size;
        private final long radius;

        public NeighborhoodsIterableInterval(RandomAccessibleInterval<T> source, long radius, DiamondNeighborhoodFactory<T> factory) {
            super(source);
            this.source = source;
            this.radius = radius;
            this.factory = factory;
            long s = source.dimension(0);
            for (int d = 1; d < this.n; ++d) {
                s *= source.dimension(d);
            }
            this.size = s;
        }

        public Cursor<Neighborhood<T>> cursor() {
            return new DiamondNeighborhoodCursor<T>(this.source, this.radius, this.factory);
        }

        public long size() {
            return this.size;
        }

        public Neighborhood<T> firstElement() {
            return (Neighborhood)this.cursor().next();
        }

        public Object iterationOrder() {
            return new FlatIterationOrder((Interval)this);
        }

        public Cursor<Neighborhood<T>> localizingCursor() {
            return this.cursor();
        }

        public Iterator<Neighborhood<T>> iterator() {
            return this.cursor();
        }
    }
}

