/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology;

import java.util.List;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.morphology.MorphologyUtils;
import net.imglib2.algorithm.morphology.Opening;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class TopHat {
    public static <T extends RealType<T>> Img<T> topHat(Img<T> source, List<? extends Shape> strels, int numThreads) {
        if (strels.isEmpty()) {
            return source;
        }
        Img<T> opened = Opening.open(source, strels, numThreads);
        MorphologyUtils.subABA(opened, source, numThreads);
        return opened;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> topHat(Img<T> source, List<? extends Shape> strels, T minVal, T maxVal, int numThreads) {
        Img<T> opened = Opening.open(source, strels, minVal, maxVal, numThreads);
        MorphologyUtils.subABA(opened, source, numThreads);
        return opened;
    }

    public static <T extends RealType<T>> Img<T> topHat(Img<T> source, Shape strel, int numThreads) {
        Img<T> opened = Opening.open(source, strel, numThreads);
        MorphologyUtils.subABA(opened, source, numThreads);
        return opened;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> topHat(Img<T> source, Shape strel, T minVal, T maxVal, int numThreads) {
        Img<T> opened = Opening.open(source, strel, minVal, maxVal, numThreads);
        MorphologyUtils.subABA(opened, source, numThreads);
        return opened;
    }

    public static <T extends RealType<T>> void topHat(RandomAccessible<T> source, IterableInterval<T> target, List<? extends Shape> strels, int numThreads) {
        Opening.open(source, target, strels, numThreads);
        MorphologyUtils.subBAB(source, target, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void topHat(RandomAccessible<T> source, IterableInterval<T> target, List<? extends Shape> strels, T minVal, T maxVal, int numThreads) {
        Opening.open(source, target, strels, minVal, maxVal, numThreads);
        MorphologyUtils.subBAB(source, target, numThreads);
    }

    public static <T extends RealType<T>> void topHat(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, int numThreads) {
        Opening.open(source, target, strel, numThreads);
        MorphologyUtils.subBAB(source, target, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void topHat(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, T minVal, T maxVal, int numThreads) {
        Opening.open(source, target, strel, minVal, maxVal, numThreads);
        MorphologyUtils.subBAB(source, target, numThreads);
    }

    public static <T extends RealType<T>> void topHatInPlace(RandomAccessible<T> source, Interval interval, List<? extends Shape> strels, int numThreads) {
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, interval);
        ImgFactory factory = Util.getSuitableImgFactory((Dimensions)interval, (Object)minVal);
        Img img = factory.create((Dimensions)interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Opening.open(source, translated, strels, numThreads);
        MorphologyUtils.subABA2(translated, source, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void topHatInPlace(RandomAccessible<T> source, Interval interval, List<? extends Shape> strels, T minVal, T maxVal, int numThreads) {
        ImgFactory factory = Util.getSuitableImgFactory((Dimensions)interval, minVal);
        Img img = factory.create((Dimensions)interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Opening.open(source, translated, strels, minVal, maxVal, numThreads);
        MorphologyUtils.subABA2(translated, source, numThreads);
    }

    public static <T extends RealType<T>> void topHatInPlace(RandomAccessible<T> source, Interval interval, Shape strel, int numThreads) {
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, interval);
        ImgFactory factory = Util.getSuitableImgFactory((Dimensions)interval, (Object)minVal);
        Img img = factory.create((Dimensions)interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Opening.open(source, translated, strel, numThreads);
        MorphologyUtils.subABA2(translated, source, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void topHatInPlace(RandomAccessible<T> source, Interval interval, Shape strel, T minVal, T maxVal, int numThreads) {
        ImgFactory factory = Util.getSuitableImgFactory((Dimensions)interval, minVal);
        Img img = factory.create((Dimensions)interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Opening.open(source, translated, strel, minVal, maxVal, numThreads);
        MorphologyUtils.subABA2(translated, source, numThreads);
    }

    private TopHat() {
    }
}

