/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology;

import java.util.List;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.morphology.Dilation;
import net.imglib2.algorithm.morphology.Erosion;
import net.imglib2.algorithm.morphology.MorphologyUtils;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class Opening {
    public static final <T extends RealType<T>> Img<T> open(Img<T> source, List<? extends Shape> strels, int numThreads) {
        Img<T> eroded = Erosion.erode(source, strels, numThreads);
        Img<T> dilated = Dilation.dilate(eroded, strels, numThreads);
        return dilated;
    }

    public static final <T extends Type<T> & Comparable<T>> Img<T> open(Img<T> source, List<? extends Shape> strels, T minVal, T maxVal, int numThreads) {
        Img<T> eroded = Erosion.erode(source, strels, maxVal, numThreads);
        Img<T> dilated = Dilation.dilate(eroded, strels, minVal, numThreads);
        return dilated;
    }

    public static final <T extends RealType<T>> Img<T> open(Img<T> source, Shape strel, int numThreads) {
        Img<T> eroded = Erosion.erode(source, strel, numThreads);
        Img<T> dilated = Dilation.dilate(eroded, strel, numThreads);
        return dilated;
    }

    public static final <T extends Type<T> & Comparable<T>> Img<T> open(Img<T> source, Shape strel, T minVal, T maxVal, int numThreads) {
        Img<T> eroded = Erosion.erode(source, strel, maxVal, numThreads);
        Img<T> dilated = Dilation.dilate(eroded, strel, minVal, numThreads);
        return dilated;
    }

    public static <T extends RealType<T>> void open(RandomAccessible<T> source, IterableInterval<T> target, List<? extends Shape> strels, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, target);
        maxVal.setReal(maxVal.getMaxValue());
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, target);
        minVal.setReal(minVal.getMinValue());
        Opening.open(source, target, strels, minVal, maxVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void open(RandomAccessible<T> source, IterableInterval<T> target, List<? extends Shape> strels, T minVal, T maxVal, int numThreads) {
        ImgFactory factory = Util.getSuitableImgFactory(target, maxVal);
        Img img = factory.create(target);
        long[] min = new long[target.numDimensions()];
        target.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Erosion.erode(source, translated, strels, maxVal, numThreads);
        ExtendedRandomAccessibleInterval extended = Views.extendValue((RandomAccessibleInterval)translated, minVal);
        Dilation.dilate(extended, target, strels, minVal, numThreads);
    }

    public static <T extends RealType<T>> void open(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, target);
        maxVal.setReal(maxVal.getMaxValue());
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, target);
        minVal.setReal(minVal.getMinValue());
        Opening.open(source, target, strel, minVal, maxVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void open(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, T minVal, T maxVal, int numThreads) {
        ImgFactory factory = Util.getSuitableImgFactory(target, maxVal);
        Img img = factory.create(target);
        long[] min = new long[target.numDimensions()];
        target.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Erosion.erode(source, translated, strel, maxVal, numThreads);
        ExtendedRandomAccessibleInterval extended = Views.extendValue((RandomAccessibleInterval)translated, minVal);
        Dilation.dilate(extended, target, strel, minVal, numThreads);
    }

    public static <T extends RealType<T>> void openInPlace(RandomAccessibleInterval<T> source, Interval interval, List<? extends Shape> strels, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, interval);
        maxVal.setReal(maxVal.getMaxValue());
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, interval);
        minVal.setReal(minVal.getMinValue());
        Opening.openInPlace(source, interval, strels, minVal, maxVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void openInPlace(RandomAccessibleInterval<T> source, Interval interval, List<? extends Shape> strels, T minVal, T maxVal, int numThreads) {
        for (Shape shape : strels) {
            Opening.openInPlace(source, interval, shape, minVal, maxVal, numThreads);
        }
    }

    public static <T extends RealType<T>> void openInPlace(RandomAccessibleInterval<T> source, Interval interval, Shape strel, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, interval);
        maxVal.setReal(maxVal.getMaxValue());
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, interval);
        minVal.setReal(minVal.getMinValue());
        Opening.openInPlace(source, interval, strel, minVal, maxVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void openInPlace(RandomAccessibleInterval<T> source, Interval interval, Shape strel, T minVal, T maxVal, int numThreads) {
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, maxVal);
        ImgFactory factory = Util.getSuitableImgFactory((Dimensions)interval, maxVal);
        Img img = factory.create((Dimensions)interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Opening.open(extended, translated, strel, minVal, maxVal, numThreads);
        MorphologyUtils.copy(translated, extended, numThreads);
    }

    private Opening() {
    }
}

