/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology;

import java.util.List;
import java.util.Vector;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.morphology.MorphologyUtils;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class Dilation {
    public static <T extends RealType<T>> Img<T> dilate(Img<T> source, List<? extends Shape> strels, int numThreads) {
        Img<T> target = source;
        for (Shape shape : strels) {
            target = Dilation.dilateFull(target, shape, numThreads);
        }
        return MorphologyUtils.copyCropped(target, source, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> dilate(Img<T> source, List<? extends Shape> strels, T minVal, int numThreads) {
        Img<T> target = source;
        for (Shape shape : strels) {
            target = Dilation.dilateFull(target, shape, minVal, numThreads);
        }
        return MorphologyUtils.copyCropped(target, source, numThreads);
    }

    public static <T extends RealType<T>> Img<T> dilate(Img<T> source, Shape strel, int numThreads) {
        Img target = source.factory().create(source);
        RealType minVal = (RealType)((RealType)source.firstElement()).createVariable();
        minVal.setReal(minVal.getMinValue());
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, (Type)minVal);
        Dilation.dilate(extended, target, strel, numThreads);
        return target;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> dilate(Img<T> source, Shape strel, T minVal, int numThreads) {
        Img target = source.factory().create(source);
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, minVal);
        Dilation.dilate(extended, target, strel, minVal, numThreads);
        return target;
    }

    public static <T extends RealType<T>> void dilate(RandomAccessible<T> source, IterableInterval<T> target, List<? extends Shape> strels, int numThreads) {
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, target);
        minVal.setReal(minVal.getMinValue());
        Dilation.dilate(source, target, strels, minVal, numThreads);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Type<T> & Comparable<T>> void dilate(RandomAccessible<T> source, IterableInterval<T> target, List<? extends Shape> strels, T minVal, int numThreads) {
        void var8_11;
        if (strels.isEmpty()) {
            return;
        }
        if (strels.size() == 1) {
            Dilation.dilate(source, target, strels.get(0), minVal, numThreads);
            return;
        }
        long[] targetDims = new long[target.numDimensions()];
        long[] translation = new long[target.numDimensions()];
        for (int d = 0; d < targetDims.length; ++d) {
            targetDims[d] = target.dimension(d);
            translation[d] = target.min(d);
        }
        for (Shape shape : strels) {
            Neighborhood<BitType> nh = MorphologyUtils.getNeighborhood(shape, target);
            for (int d = 0; d < translation.length; ++d) {
                int n = d;
                translation[n] = translation[n] - nh.dimension(d) / 2L;
                int n2 = d;
                targetDims[n2] = targetDims[n2] + (nh.dimension(d) - 1L);
            }
        }
        ImgFactory factory = Util.getSuitableImgFactory((Dimensions)new FinalDimensions(targetDims), minVal);
        Img img = factory.create(targetDims);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])translation);
        Dilation.dilate(source, translated, strels.get(0), minVal, numThreads);
        for (int i = 1; i < strels.size(); ++i) {
            Img<T> img2 = Dilation.dilate(var8_11, strels.get(i), minVal, numThreads);
        }
        long[] offset = new long[target.numDimensions()];
        for (int d = 0; d < offset.length; ++d) {
            offset[d] = target.min(d) - (var8_11.dimension(d) - target.dimension(d)) / 2L;
        }
        MorphologyUtils.copy2(Views.translate((RandomAccessibleInterval)var8_11, (long[])offset), target, numThreads);
    }

    public static <T extends RealType<T>> void dilate(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, int numThreads) {
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, target);
        minVal.setReal(minVal.getMinValue());
        Dilation.dilate(source, target, strel, minVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void dilate(RandomAccessible<T> source, final IterableInterval<T> target, Shape strel, T minVal, int numThreads) {
        numThreads = Math.max(1, numThreads);
        final RandomAccessible<Neighborhood<T>> accessible = strel.neighborhoodsRandomAccessible(source);
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(target.size(), numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        T tmp = minVal;
        if (tmp instanceof BitType) {
            for (int i = 0; i < threads.length; ++i) {
                final Chunk chunk = chunks.get(i);
                threads[i] = new Thread("Morphology dilate thread " + i){

                    @Override
                    public void run() {
                        Cursor tmp2;
                        RandomAccess randomAccess = accessible.randomAccess((Interval)target);
                        Cursor cursorDilated = tmp2 = target.cursor();
                        cursorDilated.jumpFwd(chunk.getStartPosition());
                        block0: for (long steps = 0L; steps < chunk.getLoopSize(); ++steps) {
                            Cursor tmp3;
                            cursorDilated.fwd();
                            randomAccess.setPosition((Localizable)cursorDilated);
                            Neighborhood neighborhood = (Neighborhood)randomAccess.get();
                            Cursor nc = tmp3 = neighborhood.cursor();
                            while (nc.hasNext()) {
                                nc.fwd();
                                BitType val = (BitType)nc.get();
                                if (!val.get()) continue;
                                ((BitType)cursorDilated.get()).set(true);
                                continue block0;
                            }
                        }
                    }
                };
            }
        } else {
            for (int i = 0; i < threads.length; ++i) {
                Chunk chunk = chunks.get(i);
                threads[i] = new Thread("Morphology dilate thread " + i, (RandomAccessible)accessible, (IterableInterval)target, chunk, (RandomAccessible)source, (Type)minVal){
                    final /* synthetic */ RandomAccessible val$accessible;
                    final /* synthetic */ IterableInterval val$target;
                    final /* synthetic */ Chunk val$chunk;
                    final /* synthetic */ RandomAccessible val$source;
                    final /* synthetic */ Type val$minVal;
                    {
                        this.val$accessible = randomAccessible;
                        this.val$target = iterableInterval;
                        this.val$chunk = chunk;
                        this.val$source = randomAccessible2;
                        this.val$minVal = type;
                        super(x0);
                    }

                    @Override
                    public void run() {
                        RandomAccess randomAccess = this.val$accessible.randomAccess((Interval)this.val$target);
                        Cursor cursorDilated = this.val$target.cursor();
                        cursorDilated.jumpFwd(this.val$chunk.getStartPosition());
                        Object max = MorphologyUtils.createVariable(this.val$source, (Interval)this.val$target);
                        for (long steps = 0L; steps < this.val$chunk.getLoopSize(); ++steps) {
                            cursorDilated.fwd();
                            randomAccess.setPosition((Localizable)cursorDilated);
                            Neighborhood neighborhood = (Neighborhood)randomAccess.get();
                            Cursor nc = neighborhood.cursor();
                            max.set(this.val$minVal);
                            while (nc.hasNext()) {
                                nc.fwd();
                                Type val = (Type)nc.get();
                                if (((Comparable)val).compareTo(max) <= 0) continue;
                                max.set(val);
                            }
                            ((Type)cursorDilated.get()).set(max);
                        }
                    }
                };
            }
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    public static <T extends RealType<T>> Img<T> dilateFull(Img<T> source, List<? extends Shape> strels, int numThreads) {
        Img<T> target = source;
        for (Shape shape : strels) {
            target = Dilation.dilateFull(target, shape, numThreads);
        }
        return target;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> dilateFull(Img<T> source, List<? extends Shape> strels, T minVal, int numThreads) {
        Img<T> target = source;
        for (Shape shape : strels) {
            target = Dilation.dilateFull(target, shape, minVal, numThreads);
        }
        return target;
    }

    public static <T extends RealType<T>> Img<T> dilateFull(Img<T> source, Shape strel, int numThreads) {
        long[][] dimensionsAndOffset = MorphologyUtils.computeTargetImageDimensionsAndOffset(source, strel);
        long[] targetDims = dimensionsAndOffset[0];
        long[] offset = dimensionsAndOffset[1];
        Img target = source.factory().create(targetDims);
        IntervalView offsetTarget = Views.offset((RandomAccessibleInterval)target, (long[])offset);
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, source);
        minVal.setReal(minVal.getMinValue());
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, (Type)minVal);
        Dilation.dilate(extended, offsetTarget, strel, numThreads);
        return target;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> dilateFull(Img<T> source, Shape strel, T minVal, int numThreads) {
        long[][] dimensionsAndOffset = MorphologyUtils.computeTargetImageDimensionsAndOffset(source, strel);
        long[] targetDims = dimensionsAndOffset[0];
        long[] offset = dimensionsAndOffset[1];
        Img target = source.factory().create(targetDims);
        IntervalView offsetTarget = Views.offset((RandomAccessibleInterval)target, (long[])offset);
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, minVal);
        Dilation.dilate(extended, offsetTarget, strel, minVal, numThreads);
        return target;
    }

    public static <T extends RealType<T>> void dilateInPlace(RandomAccessibleInterval<T> source, Interval interval, List<? extends Shape> strels, int numThreads) {
        for (Shape shape : strels) {
            Dilation.dilateInPlace(source, interval, shape, numThreads);
        }
    }

    public static <T extends Type<T> & Comparable<T>> void dilateInPlace(RandomAccessibleInterval<T> source, Interval interval, List<? extends Shape> strels, T minVal, int numThreads) {
        for (Shape shape : strels) {
            Dilation.dilateInPlace(source, interval, shape, minVal, numThreads);
        }
    }

    public static <T extends RealType<T>> void dilateInPlace(RandomAccessibleInterval<T> source, Interval interval, Shape strel, int numThreads) {
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, interval);
        minVal.setReal(minVal.getMinValue());
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, (Type)minVal);
        ImgFactory factory = Util.getSuitableImgFactory((Dimensions)interval, (Object)minVal);
        Img img = factory.create((Dimensions)interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Dilation.dilate(extended, translated, strel, numThreads);
        MorphologyUtils.copy(translated, extended, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void dilateInPlace(RandomAccessibleInterval<T> source, Interval interval, Shape strel, T minVal, int numThreads) {
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, minVal);
        ImgFactory factory = Util.getSuitableImgFactory((Dimensions)interval, minVal);
        Img img = factory.create((Dimensions)interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Dilation.dilate(extended, translated, strel, minVal, numThreads);
        MorphologyUtils.copy(translated, extended, numThreads);
    }

    private Dilation() {
    }
}

