/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.metrics.imagequality;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class MSE {
    public static <T extends RealType<T>> double computeMetrics(RandomAccessibleInterval<T> reference, RandomAccessibleInterval<T> processed) {
        if (!Intervals.equalDimensions(reference, processed)) {
            throw new IllegalArgumentException("Image dimensions must match.");
        }
        long nPixels = Intervals.numElements(reference);
        double mse = 0.0;
        Cursor cu = Views.iterable(reference).localizingCursor();
        RandomAccess ra = processed.randomAccess();
        while (cu.hasNext()) {
            double dRef = ((RealType)cu.next()).getRealDouble();
            ra.setPosition((Localizable)cu);
            double dProc = ((RealType)ra.get()).getRealDouble();
            mse += (dRef - dProc) * (dRef - dProc);
        }
        return nPixels > 0L ? mse / (double)nPixels : Double.NaN;
    }
}

