/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.HashMap;
import net.imglib2.AbstractCursor;
import net.imglib2.Cursor;
import net.imglib2.Sampler;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.abstractions.Util;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;

public class FunctionCursor<C extends RealType<C>, O extends RealType<O>>
extends AbstractCursor<O> {
    protected final IFunction operation;
    protected final Converter<RealType<?>, C> inConverter;
    protected final Converter<C, O> outConverter;
    protected OFunction<C> f;
    protected C scrapC;
    protected O scrapO;
    protected Cursor<?> cursor;
    protected final Sampler<O> sampler;

    public FunctionCursor(IFunction operation, Converter<RealType<?>, C> inConverter, C computeType, O outputType, Converter<C, O> outConverter) {
        super(Util.findFirstInterval(operation).numDimensions());
        this.operation = operation;
        Object object = this.inConverter = inConverter == null ? Util.genericRealTypeConverter() : inConverter;
        if (computeType.getClass() == outputType.getClass()) {
            this.sampler = new FunctionSamplerDirect();
            this.outConverter = null;
        } else {
            this.outConverter = null == outConverter ? (computeType instanceof IntegerType && outputType instanceof IntegerType ? Util.genericIntegerTypeConverter() : Util.genericRealTypeConverter()) : outConverter;
            this.sampler = new FunctionSamplerConverter();
        }
        this.scrapC = (RealType)computeType.createVariable();
        this.scrapO = (RealType)outputType.createVariable();
        this.reset();
    }

    public final O get() {
        return (O)((RealType)this.sampler.get());
    }

    public void fwd() {
        this.scrapC = this.f.eval();
    }

    public final boolean hasNext() {
        return this.cursor.hasNext();
    }

    public void reset() {
        this.f = this.operation.reInit((RealType)this.scrapC.createVariable(), new HashMap(), this.inConverter, null);
        this.cursor = Util.findFirstIterableImgSource(this.f).getCursor();
    }

    public long getLongPosition(int d) {
        return this.cursor.getLongPosition(d);
    }

    public void localize(long[] position) {
        this.cursor.localize(position);
    }

    public AbstractCursor<O> copy() {
        return new FunctionCursor<C, O>(this.operation, this.inConverter, this.scrapC, this.scrapO, this.outConverter);
    }

    private final class FunctionSamplerDirect
    implements Sampler<C> {
        private FunctionSamplerDirect() {
        }

        public final C get() {
            return FunctionCursor.this.scrapC;
        }

        public final Sampler<C> copy() {
            return null;
        }
    }

    private final class FunctionSamplerConverter
    implements Sampler<O> {
        private FunctionSamplerConverter() {
        }

        public final O get() {
            FunctionCursor.this.outConverter.convert(FunctionCursor.this.scrapC, FunctionCursor.this.scrapO);
            return FunctionCursor.this.scrapO;
        }

        public final Sampler<O> copy() {
            return null;
        }
    }
}

