/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.math.ImgSource;
import net.imglib2.algorithm.math.Let;
import net.imglib2.algorithm.math.Var;
import net.imglib2.algorithm.math.abstractions.IBinaryFunction;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.ITrinaryFunction;
import net.imglib2.algorithm.math.abstractions.IUnaryFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.abstractions.RandomAccessOnly;
import net.imglib2.algorithm.math.abstractions.Util;
import net.imglib2.algorithm.math.execution.FunctionCursor;
import net.imglib2.algorithm.math.execution.FunctionCursorDouble;
import net.imglib2.algorithm.math.execution.FunctionCursorDoubleIncompatibleOrder;
import net.imglib2.algorithm.math.execution.FunctionCursorIncompatibleOrder;
import net.imglib2.algorithm.math.execution.FunctionRandomAccess;
import net.imglib2.algorithm.math.execution.FunctionRandomAccessDouble;
import net.imglib2.converter.Converter;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class Compute {
    private final IFunction operation;
    private final Parameters params;

    public Compute(IFunction operation) {
        this.operation = operation;
        this.params = Compute.validate(this.operation);
    }

    public <O extends RealType<O> & NativeType<O>> ArrayImg<O, ?> intoArrayImg() {
        RandomAccessibleInterval<?> rai = Util.findImg(this.operation).iterator().next();
        ArrayImg target = new ArrayImgFactory((NativeType)((RealType)rai.randomAccess().get()).createVariable()).create(rai);
        this.params.compatible_iteration_order = Util.compatibleIterationOrder(Arrays.asList(rai, target));
        this.into((RandomAccessibleInterval<O>)target);
        return target;
    }

    public <O extends RealType<O> & NativeType<O>, C extends RealType<C> & NativeType<C>> ArrayImg<O, ?> intoArrayImg(C computeType, O outputType) {
        Interval interval;
        Set<RandomAccessibleInterval<?>> imgs = Util.findImg(this.operation);
        ArrayList ls = new ArrayList();
        if (imgs.isEmpty()) {
            interval = Util.findFirstInterval(this.operation);
            this.params.compatible_iteration_order = true;
        } else {
            interval = (Interval)imgs.iterator().next();
            ls.addAll(imgs);
        }
        ArrayImg target = new ArrayImgFactory((NativeType<O>)outputType).create((Dimensions)interval);
        ls.add((RandomAccessibleInterval<?>)target);
        this.params.compatible_iteration_order = Util.compatibleIterationOrder(ls);
        this.into((RandomAccessibleInterval<O>)target, (Converter<RealType<?>, C>)null, computeType, (Converter<C, O>)null);
        return target;
    }

    public <O extends RealType<O> & NativeType<O>, C extends RealType<C>> ArrayImg<O, ?> intoArrayImg(O outputType) {
        return this.intoArrayImg((C)((RealType)outputType.createVariable()), outputType);
    }

    public <O extends RealType<O> & NativeType<O>> RandomAccessibleInterval<O> intoImg() {
        return this.intoImg((RealType)((RealType)Util.findImg(this.operation).iterator().next().randomAccess().get()).createVariable());
    }

    public <O extends RealType<O> & NativeType<O>> RandomAccessibleInterval<O> intoImg(O outputType) {
        return this.intoImg((C)((RealType)outputType.createVariable()), outputType);
    }

    public <O extends RealType<O> & NativeType<O>, C extends RealType<C>> RandomAccessibleInterval<O> intoImg(C computeType, O outputType) {
        for (RandomAccessibleInterval<?> rai : Util.findImg(this.operation)) {
            if (!(rai instanceof Img)) continue;
            Img target = ((Img)rai).factory().imgFactory(outputType).create(rai);
            return this.into((RandomAccessibleInterval<O>)target, null, computeType, null);
        }
        return this.intoArrayImg();
    }

    public <O extends RealType<O>> RandomAccessibleInterval<O> into(RandomAccessibleInterval<O> target) {
        return this.into(target, null, (RealType)((RealType)target.randomAccess().get()).createVariable(), null);
    }

    public <O extends RealType<O>> RandomAccessibleInterval<O> into(RandomAccessibleInterval<O> target, Converter<RealType<?>, O> inConverter) {
        return this.into(target, inConverter, (RealType)((RealType)target.randomAccess().get()).createVariable(), null);
    }

    public <O extends RealType<O>, C extends RealType<C>> RandomAccessibleInterval<O> into(RandomAccessibleInterval<O> target, C computingType) {
        return this.into(target, null, computingType, null);
    }

    public <O extends RealType<O>, C extends RealType<C>> RandomAccessibleInterval<O> into(RandomAccessibleInterval<O> target, Converter<RealType<?>, C> inConverter, C computingType, Converter<C, O> outConverter) {
        return this.into(target, inConverter, computingType, outConverter, false);
    }

    public <O extends RealType<O>, C extends RealType<C>> RandomAccessibleInterval<O> into(RandomAccessibleInterval<O> target, Converter<RealType<?>, C> inConverter, C computingType, Converter<C, O> outConverter, boolean printHierarchy) {
        boolean are_same_type;
        if (null == inConverter) {
            inConverter = Util.genericRealTypeConverter();
        }
        RealType outputType = (RealType)((RealType)target.randomAccess().get()).createVariable();
        boolean bl = are_same_type = computingType.getClass() == outputType.getClass();
        if (null == outConverter && !are_same_type) {
            outConverter = computingType instanceof IntegerType && outputType instanceof IntegerType ? Util.genericIntegerTypeConverter() : Util.genericRealTypeConverter();
        }
        OFunction<C> f = this.operation.reInit(computingType, new HashMap(), inConverter, null);
        if (printHierarchy) {
            System.out.println(Util.hierarchy(f));
        }
        if (are_same_type) {
            RandomAccessibleInterval<O> targetC = target;
            if (this.params.compatible_iteration_order && !this.params.must_run_as_RandomAccess) {
                for (RealType output : Views.iterable(targetC)) {
                    output.set(f.eval());
                }
            } else {
                Cursor cursor = Views.iterable(targetC).cursor();
                while (cursor.hasNext()) {
                    cursor.fwd();
                    ((RealType)cursor.get()).set(f.eval((Localizable)cursor));
                }
            }
        } else if (this.params.compatible_iteration_order && !this.params.must_run_as_RandomAccess) {
            for (RealType output : Views.iterable(target)) {
                outConverter.convert(f.eval(), (Object)output);
            }
        } else {
            Cursor cursor = Views.iterable(target).cursor();
            while (cursor.hasNext()) {
                cursor.fwd();
                outConverter.convert(f.eval((Localizable)cursor), cursor.get());
            }
        }
        return target;
    }

    public <O extends RealType<O>, C extends RealType<C>> RandomAccessibleInterval<O> view(final Interval interval, final Converter<RealType<?>, C> inConverter, final C computingType, final O outputType, final Converter<C, O> outConverter) {
        return Views.interval((RandomAccessible)new RandomAccessible<O>(){

            public int numDimensions() {
                return interval.numDimensions();
            }

            public RandomAccess<O> randomAccess() {
                return Compute.this.randomAccess(inConverter, computingType, outputType, outConverter);
            }

            public RandomAccess<O> randomAccess(Interval interval2) {
                return this.randomAccess();
            }
        }, (Interval)interval);
    }

    public <O extends RealType<O>, C extends RealType<C>> RandomAccessibleInterval<O> view(C computingType, O outputType) {
        return this.view(Util.findFirstInterval(this.operation), null, computingType, outputType, null);
    }

    public <O extends RealType<O>> RandomAccessibleInterval<O> view(O outputType) {
        return this.view((RealType)outputType.createVariable(), outputType);
    }

    public <O extends RealType<O>> RandomAccessibleInterval<O> view() {
        RealType outputType = (RealType)((RealType)Util.findFirstImg(this.operation).randomAccess().get()).createVariable();
        return this.view((RealType)outputType.createVariable(), outputType);
    }

    public <O extends RealType<O>> RandomAccessibleInterval<O> view(Interval interval) {
        RealType outputType = (RealType)((RealType)Util.findFirstImg(this.operation).randomAccess().get()).createVariable();
        return this.view(interval, null, (RealType)outputType.createVariable(), outputType, null);
    }

    public <O extends RealType<O>> RandomAccessibleInterval<O> view(Interval interval, O outputType) {
        return this.view(interval, null, (RealType)outputType.createVariable(), outputType, null);
    }

    public <O extends RealType<O> & NativeType<O>> RandomAccessibleInterval<O> parallelIntoArrayImg() {
        RandomAccessibleInterval<?> first = Util.findImg(this.operation).iterator().next();
        RealType outputType = (RealType)((RealType)first.randomAccess().get()).createVariable();
        ArrayImg target = new ArrayImgFactory((NativeType)outputType).create(first);
        return this.parallelInto(null, (RealType)((RealType)outputType.createVariable()), (O)outputType, null, (RandomAccessibleInterval<O>)target);
    }

    public <O extends RealType<O> & NativeType<O>> RandomAccessibleInterval<O> parallelIntoArrayImg(O outputType) {
        return this.parallelIntoArrayImg((Converter<RealType<?>, C>)null, (C)((RealType)outputType.createVariable()), outputType, (Converter<C, O>)null);
    }

    public <O extends RealType<O> & NativeType<O>, C extends RealType<C>> RandomAccessibleInterval<O> parallelIntoArrayImg(C computeType, O outputType) {
        return this.parallelIntoArrayImg((Converter<RealType<?>, C>)null, computeType, outputType, (Converter<C, O>)null);
    }

    public <O extends RealType<O> & NativeType<O>, C extends RealType<C>> RandomAccessibleInterval<O> parallelIntoArrayImg(Converter<RealType<?>, C> inConverter, C computeType, O outputType, Converter<C, O> outConverter) {
        ArrayImg target = new ArrayImgFactory((NativeType<O>)outputType).create((Dimensions)Util.findImg(this.operation).iterator().next());
        return this.parallelInto(inConverter, computeType, outputType, outConverter, (RandomAccessibleInterval<O>)target);
    }

    public <O extends RealType<O>> RandomAccessibleInterval<O> parallelInto(RandomAccessibleInterval<O> target) {
        RealType type = (RealType)net.imglib2.util.Util.getTypeFromInterval(target);
        return this.parallelInto(null, (RealType)type.createVariable(), type, null, target);
    }

    public <O extends RealType<O>, C extends RealType<C>> RandomAccessibleInterval<O> parallelInto(Converter<RealType<?>, C> inConverter, C computeType, O outputType, Converter<C, O> outConverter, RandomAccessibleInterval<O> target) {
        RandomAccessibleInterval<O> source = this.view(Util.findFirstInterval(this.operation), inConverter, computeType, outputType, outConverter);
        LoopBuilder.setImages(source, target).forEachPixel(Type::set);
        return target;
    }

    public static Parameters validate(IFunction f) {
        Object var;
        Parameters p = new Parameters();
        LinkedList<IFunction> ops = new LinkedList<IFunction>();
        ops.add(f);
        HashMap<IFunction, IFunction> cp = new HashMap<IFunction, IFunction>();
        cp.put(f, null);
        LinkedList images = new LinkedList();
        ArrayList<Object> vars = new ArrayList<Object>();
        HashSet<Let> lets = new HashSet<Let>();
        while (!ops.isEmpty()) {
            IFunction op = (IFunction)ops.removeFirst();
            if (op instanceof ImgSource) {
                images.addFirst(((ImgSource)op).getRandomAccessibleInterval());
                continue;
            }
            if (op instanceof IUnaryFunction) {
                IFunction first = ((IUnaryFunction)op).getFirst();
                ops.addFirst(first);
                cp.put(first, op);
                if (!(op instanceof IBinaryFunction)) continue;
                IFunction second = ((IBinaryFunction)op).getSecond();
                ops.add(1, second);
                cp.put(second, op);
                if (op instanceof Let) {
                    lets.add((Let)op);
                }
                if (!(op instanceof ITrinaryFunction)) continue;
                IFunction third = ((ITrinaryFunction)op).getThird();
                ops.add(2, third);
                cp.put(third, op);
                continue;
            }
            if (op instanceof Var) {
                var = (Var)op;
                vars.add(var);
                continue;
            }
            if (!(op instanceof RandomAccessOnly) || p.must_run_as_RandomAccess) continue;
            p.must_run_as_RandomAccess = ((RandomAccessOnly)((Object)op)).isRandomAccessOnly();
        }
        HashSet<Let> used = new HashSet<Let>();
        var = vars.iterator();
        block1: while (var.hasNext()) {
            Var var2;
            IFunction parent = var2 = (Var)var.next();
            while (null != (parent = (IFunction)cp.get(parent))) {
                Let let;
                if (!(parent instanceof Let) || (let = (Let)parent).getVarName() != var2.getName()) continue;
                used.add(let);
                continue block1;
            }
            throw new RuntimeException("The Var(\"" + var2.getName() + "\") does not read from any upstream Let. ");
        }
        if (lets.size() != used.size()) {
            lets.removeAll(used);
            String msg = "The Let-declared variable" + (1 == lets.size() ? "" : "s");
            for (Let let : lets) {
                msg = msg + " \"" + let.getVarName() + "\"";
            }
            msg = msg + " " + (1 == lets.size() ? "is" : "are") + " not used by any downstream Var.";
            throw new RuntimeException(msg);
        }
        p.images = images;
        p.compatible_iteration_order = Util.compatibleIterationOrder(images);
        return p;
    }

    public <C extends RealType<C>, O extends RealType<O>> RandomAccess<O> randomAccess(Converter<RealType<?>, C> inConverter, C computeType, O outputType, Converter<C, O> outConverter) {
        return new FunctionRandomAccess<C, O>(this.operation, inConverter, computeType, outputType, outConverter);
    }

    public <C extends RealType<C>, O extends RealType<O>> RandomAccess<O> randomAccess(C computeType, O outputType, Converter<C, O> outConverter) {
        return this.randomAccess(null, computeType, outputType, outConverter);
    }

    public <O extends RealType<O>> RandomAccess<O> randomAccess(O outputType) {
        return this.randomAccess((RealType)outputType.createVariable(), outputType, null);
    }

    public <O extends RealType<O>> RandomAccess<O> randomAccess() {
        RandomAccessibleInterval<?> img = Util.findFirstImg(this.operation);
        RealType outputType = (RealType)((RealType)img.randomAccess().get()).createVariable();
        return this.randomAccess((RealType)outputType.createVariable(), outputType, null);
    }

    public <C extends RealType<C>, O extends RealType<O>> Cursor<O> cursor(Converter<RealType<?>, C> inConverter, C computeType, O outputType, Converter<C, O> outConverter) {
        if (this.params.compatible_iteration_order) {
            return new FunctionCursor<C, O>(this.operation, inConverter, computeType, outputType, outConverter);
        }
        return new FunctionCursorIncompatibleOrder<C, O>(this.operation, inConverter, computeType, outputType, outConverter);
    }

    public <C extends RealType<C>, O extends RealType<O>> Cursor<O> cursor(C computeType, O outputType) {
        return this.cursor(null, computeType, outputType, null);
    }

    public <O extends RealType<O>> Cursor<O> cursor(O outputType) {
        return this.cursor(null, (RealType)outputType.createVariable(), outputType, null);
    }

    public <O extends RealType<O>> Cursor<O> cursor() {
        RandomAccessibleInterval<?> img = Util.findFirstImg(this.operation);
        return this.cursor((RealType)((RealType)img.randomAccess().get()).createVariable());
    }

    public <O extends RealType<O>> RandomAccess<O> randomAccessDouble(O outputType, Converter<RealType<?>, O> converter) {
        return new FunctionRandomAccessDouble<O>(this.operation, outputType, converter);
    }

    public <O extends RealType<O>> RandomAccess<O> randomAccessDouble(O outputType) {
        return new FunctionRandomAccessDouble<O>(this.operation, outputType, Util.genericRealTypeConverter());
    }

    public <O extends RealType<O>> RandomAccess<O> randomAccessDouble() {
        RandomAccessibleInterval<?> img = Util.findFirstImg(this.operation);
        RealType outputType = (RealType)((RealType)img.randomAccess().get()).createVariable();
        return new FunctionRandomAccessDouble<RealType>(this.operation, outputType, Util.genericRealTypeConverter());
    }

    public <O extends RealType<O>> Cursor<O> cursorDouble(O outputType, Converter<RealType<?>, O> converter) {
        if (this.params.compatible_iteration_order && !this.params.must_run_as_RandomAccess) {
            return new FunctionCursorDouble<O>(this.operation, outputType, converter);
        }
        return new FunctionCursorDoubleIncompatibleOrder<O>(this.operation, outputType, converter);
    }

    public <O extends RealType<O>> Cursor<O> cursorDouble(O outputType) {
        return this.cursorDouble(outputType, Util.genericRealTypeConverter());
    }

    public <O extends RealType<O>> Cursor<O> cursorDouble() {
        RandomAccessibleInterval<?> img = Util.findFirstImg(this.operation);
        return this.cursorDouble((RealType)((RealType)img.randomAccess().get()).createVariable());
    }

    public static class Parameters {
        public boolean compatible_iteration_order;
        public List<RandomAccessibleInterval<?>> images;
        public boolean must_run_as_RandomAccess = false;
    }
}

