/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.localextrema;

import Jama.LUDecomposition;
import Jama.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.localextrema.RefinedPeak;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;

public class SubpixelLocalization<P extends Localizable, T extends RealType<T>> {
    protected int maxNumMoves = 4;
    protected boolean allowMaximaTolerance = false;
    protected boolean canMoveOutside = false;
    protected float maximaTolerance = 0.01f;
    protected boolean[] allowedToMoveInDim;
    protected boolean returnInvalidPeaks = false;
    protected int numThreads;

    public SubpixelLocalization(int numDimensions) {
        this.allowedToMoveInDim = new boolean[numDimensions];
        Arrays.fill(this.allowedToMoveInDim, true);
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setAllowMaximaTolerance(boolean allowMaximaTolerance) {
        this.allowMaximaTolerance = allowMaximaTolerance;
    }

    public void setCanMoveOutside(boolean canMoveOutside) {
        this.canMoveOutside = canMoveOutside;
    }

    public void setMaximaTolerance(float maximaTolerance) {
        this.maximaTolerance = maximaTolerance;
    }

    public void setMaxNumMoves(int maxNumMoves) {
        this.maxNumMoves = maxNumMoves;
    }

    public void setAllowedToMoveInDim(boolean[] allowedToMoveInDim) {
        this.allowedToMoveInDim = (boolean[])allowedToMoveInDim.clone();
    }

    public void setReturnInvalidPeaks(boolean returnInvalidPeaks) {
        this.returnInvalidPeaks = returnInvalidPeaks;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public boolean getAllowMaximaTolerance() {
        return this.allowMaximaTolerance;
    }

    public boolean getCanMoveOutside() {
        return this.canMoveOutside;
    }

    public float getMaximaTolerance() {
        return this.maximaTolerance;
    }

    public int getMaxNumMoves() {
        return this.maxNumMoves;
    }

    public boolean[] getAllowedToMoveInDim() {
        return (boolean[])this.allowedToMoveInDim.clone();
    }

    public boolean getReturnInvalidPeaks() {
        return this.returnInvalidPeaks;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public ArrayList<RefinedPeak<P>> process(List<P> peaks, RandomAccessible<T> img, Interval validInterval) {
        return SubpixelLocalization.refinePeaks(peaks, img, validInterval, this.returnInvalidPeaks, this.maxNumMoves, this.allowMaximaTolerance, this.maximaTolerance, this.allowedToMoveInDim, this.numThreads);
    }

    public static <T extends RealType<T>, P extends Localizable> ArrayList<RefinedPeak<P>> refinePeaks(List<P> peaks, RandomAccessible<T> img, Interval validInterval, boolean returnInvalidPeaks, int maxNumMoves, boolean allowMaximaTolerance, float maximaTolerance, boolean[] allowedToMoveInDim, int numThreads) {
        int numPeaks = peaks.size();
        int numTasks = numThreads <= 1 ? 1 : Math.min(numPeaks, numThreads * 20);
        ExecutorService ex = Executors.newFixedThreadPool(numThreads);
        ArrayList<RefinedPeak<P>> allRefinedPeaks = SubpixelLocalization.refinePeaks(peaks, img, validInterval, returnInvalidPeaks, maxNumMoves, allowMaximaTolerance, maximaTolerance, allowedToMoveInDim, numTasks, ex);
        ex.shutdown();
        return allRefinedPeaks;
    }

    public static <T extends RealType<T>, P extends Localizable> ArrayList<RefinedPeak<P>> refinePeaks(List<P> peaks, RandomAccessible<T> img, Interval validInterval, boolean returnInvalidPeaks, int maxNumMoves, boolean allowMaximaTolerance, float maximaTolerance, boolean[] allowedToMoveInDim, int numTasks, ExecutorService ex) {
        int numPeaks = peaks.size();
        ArrayList<RefinedPeak<P>> allRefinedPeaks = new ArrayList<RefinedPeak<P>>(numPeaks);
        if (numPeaks == 0) {
            return allRefinedPeaks;
        }
        int taskSize = numPeaks / numTasks;
        ArrayList<Callable<ArrayList>> tasks = new ArrayList<Callable<ArrayList>>(taskSize);
        for (int taskNum = 0; taskNum < numTasks; ++taskNum) {
            int fromIndex = taskNum * taskSize;
            int toIndex = taskNum == numTasks - 1 ? numPeaks : fromIndex + taskSize;
            tasks.add(() -> SubpixelLocalization.refinePeaks(peaks.subList(fromIndex, toIndex), img, validInterval, returnInvalidPeaks, maxNumMoves, allowMaximaTolerance, maximaTolerance, allowedToMoveInDim));
        }
        try {
            List futures = ex.invokeAll(tasks);
            for (Future future : futures) {
                allRefinedPeaks.addAll((Collection)future.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        return allRefinedPeaks;
    }

    public static <T extends RealType<T>, P extends Localizable> ArrayList<RefinedPeak<P>> refinePeaks(List<P> peaks, RandomAccessible<T> img, Interval validInterval, boolean returnInvalidPeaks, int maxNumMoves, boolean allowMaximaTolerance, float maximaTolerance, boolean[] allowedToMoveInDim) {
        ArrayList<RefinedPeak<P>> refinedPeaks = new ArrayList<RefinedPeak<P>>();
        int n = img.numDimensions();
        Point currentPosition = new Point(n);
        Matrix g = new Matrix(n, 1);
        Matrix H = new Matrix(n, n);
        RealPoint subpixelOffset = new RealPoint(n);
        boolean canMoveOutside = validInterval == null;
        FinalInterval interval = canMoveOutside ? null : Intervals.expand((Interval)validInterval, (long)-1L);
        RandomAccess access = canMoveOutside ? img.randomAccess() : img.randomAccess(validInterval);
        for (Localizable p : peaks) {
            currentPosition.setPosition(p);
            boolean foundStableMaxima = false;
            for (int numMoves = 0; numMoves < maxNumMoves && (canMoveOutside || Intervals.contains((Interval)interval, (Localizable)currentPosition)); ++numMoves) {
                SubpixelLocalization.quadraticFitOffset((Localizable)currentPosition, access, g, H, (RealPositionable)subpixelOffset);
                foundStableMaxima = true;
                double threshold = allowMaximaTolerance ? 0.5 + (double)((float)numMoves * maximaTolerance) : 0.5;
                for (int d = 0; d < n; ++d) {
                    double diff = subpixelOffset.getDoublePosition(d);
                    if (!(Math.abs(diff) > threshold) || !allowedToMoveInDim[d]) continue;
                    currentPosition.move(diff > 0.0 ? 1 : -1, d);
                    foundStableMaxima = false;
                }
                if (foundStableMaxima) break;
            }
            if (foundStableMaxima) {
                double value = 0.0;
                for (int d = 0; d < n; ++d) {
                    value += g.get(d, 0) * subpixelOffset.getDoublePosition(d);
                }
                value *= 0.5;
                access.setPosition((Localizable)currentPosition);
                subpixelOffset.move((Localizable)currentPosition);
                refinedPeaks.add(new RefinedPeak<Localizable>(p, (RealLocalizable)subpixelOffset, value += ((RealType)access.get()).getRealDouble(), true));
                continue;
            }
            if (!returnInvalidPeaks) continue;
            refinedPeaks.add(new RefinedPeak<Localizable>(p, (RealLocalizable)p, 0.0, false));
        }
        return refinedPeaks;
    }

    protected static <T extends RealType<T>> void quadraticFitOffset(Localizable p, RandomAccess<T> access, Matrix g, Matrix H, RealPositionable offset) {
        int n = p.numDimensions();
        access.setPosition(p);
        double a1 = ((RealType)access.get()).getRealDouble();
        for (int d = 0; d < n; ++d) {
            access.bck(d);
            double a0 = ((RealType)access.get()).getRealDouble();
            access.move(2, d);
            double a2 = ((RealType)access.get()).getRealDouble();
            g.set(d, 0, (a2 - a0) * 0.5);
            access.bck(d);
            H.set(d, d, a2 - 2.0 * a1 + a0);
            for (int e = d + 1; e < n; ++e) {
                access.fwd(d);
                access.fwd(e);
                double a2b2 = ((RealType)access.get()).getRealDouble();
                access.move(-2, d);
                double a0b2 = ((RealType)access.get()).getRealDouble();
                access.move(-2, e);
                double a0b0 = ((RealType)access.get()).getRealDouble();
                access.move(2, d);
                double a2b0 = ((RealType)access.get()).getRealDouble();
                access.bck(d);
                access.fwd(e);
                double v = (a2b2 - a0b2 - a2b0 + a0b0) * 0.25;
                H.set(d, e, v);
                H.set(e, d, v);
            }
        }
        LUDecomposition decomp = new LUDecomposition(H);
        if (decomp.isNonsingular()) {
            Matrix minusOffset = decomp.solve(g);
            for (int d = 0; d < n; ++d) {
                offset.setPosition(-minusOffset.get(d, 0), d);
            }
        } else {
            for (int d = 0; d < n; ++d) {
                offset.setPosition(0L, d);
            }
        }
    }
}

