/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.localextrema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.util.ConstantUtils;
import net.imglib2.util.Intervals;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class LocalExtrema {
    @Deprecated
    public static <P, T> ArrayList<P> findLocalExtrema(RandomAccessibleInterval<T> source, LocalNeighborhoodCheck<P, T> localNeighborhoodCheck, ExecutorService service) {
        RectangleShape shape = new RectangleShape(1, true);
        long[] borderSize = LocalExtrema.getRequiredBorderSize(shape, source.numDimensions());
        int nDim = source.numDimensions();
        int splitDim = nDim - 1;
        int numThreads = Runtime.getRuntime().availableProcessors();
        int numTasks = Math.max(Math.min((int)LocalExtrema.shrink(source, borderSize).dimension(splitDim), numThreads * 20), 1);
        try {
            return (ArrayList)LocalExtrema.findLocalExtrema(source, LocalExtrema.shrink(source, borderSize), localNeighborhoodCheck, shape, service, numTasks, splitDim);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <P, T> List<P> findLocalExtrema(RandomAccessibleInterval<T> source, LocalNeighborhoodCheck<P, T> localNeighborhoodCheck, Shape shape, ExecutorService service, int numTasks) throws InterruptedException, ExecutionException {
        int splitDim = LocalExtrema.getBiggestDimension(LocalExtrema.shrink(source, LocalExtrema.getRequiredBorderSize(shape, source.numDimensions())));
        return LocalExtrema.findLocalExtrema(source, localNeighborhoodCheck, shape, service, numTasks, splitDim);
    }

    public static <P, T> List<P> findLocalExtrema(RandomAccessibleInterval<T> source, LocalNeighborhoodCheck<P, T> localNeighborhoodCheck, Shape shape, ExecutorService service, int numTasks, int splitDim) throws InterruptedException, ExecutionException {
        long[] borderSize = LocalExtrema.getRequiredBorderSize(shape, source.numDimensions());
        return LocalExtrema.findLocalExtrema(source, LocalExtrema.shrink(source, borderSize), localNeighborhoodCheck, shape, service, numTasks, splitDim);
    }

    public static <P, T> List<P> findLocalExtrema(RandomAccessible<T> source, Interval interval, LocalNeighborhoodCheck<P, T> localNeighborhoodCheck, Shape shape, ExecutorService service, int numTasks) throws InterruptedException, ExecutionException {
        int splitDim = LocalExtrema.getBiggestDimension(interval);
        return LocalExtrema.findLocalExtrema(source, interval, localNeighborhoodCheck, shape, service, numTasks, splitDim);
    }

    public static <P, T> List<P> findLocalExtrema(RandomAccessible<T> source, Interval interval, LocalNeighborhoodCheck<P, T> localNeighborhoodCheck, Shape shape, ExecutorService service, int numTasks, int splitDim) throws InterruptedException, ExecutionException {
        long[] min = Intervals.minAsLongArray((Interval)interval);
        long[] max = Intervals.maxAsLongArray((Interval)interval);
        long splitDimSize = interval.dimension(splitDim);
        long splitDimMax = max[splitDim];
        long splitDimMin = min[splitDim];
        long taskSize = Math.max(splitDimSize / (long)numTasks, 1L);
        ArrayList<Callable<List>> tasks = new ArrayList<Callable<List>>();
        long start = splitDimMin;
        long stop = splitDimMin + taskSize - 1L;
        while (start <= splitDimMax) {
            long s = start;
            long S = Math.min(stop, splitDimMax);
            tasks.add(() -> {
                long[] localMin = (long[])min.clone();
                long[] localMax = (long[])max.clone();
                localMin[splitDim] = s;
                localMax[splitDim] = S;
                return LocalExtrema.findLocalExtrema(source, (Interval)new FinalInterval(localMin, localMax), localNeighborhoodCheck, shape);
            });
            start += taskSize;
            stop += taskSize;
        }
        ArrayList extrema = new ArrayList();
        List futures = service.invokeAll(tasks);
        for (Future f : futures) {
            extrema.addAll((Collection)f.get());
        }
        return extrema;
    }

    public static <P, T> List<P> findLocalExtrema(RandomAccessibleInterval<T> source, LocalNeighborhoodCheck<P, T> localNeighborhoodCheck) {
        return LocalExtrema.findLocalExtrema(source, localNeighborhoodCheck, new RectangleShape(1, true));
    }

    public static <P, T> List<P> findLocalExtrema(RandomAccessibleInterval<T> source, LocalNeighborhoodCheck<P, T> localNeighborhoodCheck, Shape shape) {
        long[] borderSize = LocalExtrema.getRequiredBorderSize(shape, source.numDimensions());
        assert (Arrays.stream(borderSize).min().getAsLong() >= 0L) : "Border size cannot be smaller than zero.";
        return LocalExtrema.findLocalExtrema(source, LocalExtrema.shrink(source, borderSize), localNeighborhoodCheck, shape);
    }

    public static <P, T> List<P> findLocalExtrema(RandomAccessible<T> source, Interval interval, LocalNeighborhoodCheck<P, T> localNeighborhoodCheck) {
        return LocalExtrema.findLocalExtrema(source, interval, localNeighborhoodCheck, new RectangleShape(1, true));
    }

    public static <P, T> List<P> findLocalExtrema(RandomAccessible<T> source, Interval interval, LocalNeighborhoodCheck<P, T> localNeighborhoodCheck, Shape shape) {
        IntervalView sourceInterval = Views.interval(source, (Interval)interval);
        ArrayList<P> extrema = new ArrayList<P>();
        Cursor center = Views.flatIterable((RandomAccessibleInterval)sourceInterval).cursor();
        for (Neighborhood neighborhood : shape.neighborhoods(sourceInterval)) {
            center.fwd();
            P p = localNeighborhoodCheck.check(center, neighborhood);
            if (p == null) continue;
            extrema.add(p);
        }
        return extrema;
    }

    public static long[] getRequiredBorderSize(Shape shape, int nDim) {
        RandomAccessible neighborhood = shape.neighborhoodsRandomAccessible(ConstantUtils.constantRandomAccessible((Object)new Object(), (int)nDim));
        long[] min = LongStream.generate(() -> Long.MAX_VALUE).limit(nDim).toArray();
        long[] max = LongStream.generate(() -> Long.MIN_VALUE).limit(nDim).toArray();
        Interval bb = ((Neighborhood)neighborhood.randomAccess().get()).getStructuringElementBoundingBox();
        for (int d2 = 0; d2 < nDim; ++d2) {
            min[d2] = Math.min(bb.min(d2), min[d2]);
            max[d2] = Math.max(bb.max(d2), max[d2]);
        }
        long[] borderSize = IntStream.range(0, nDim).mapToLong(d -> Math.max(max[d], -min[d])).toArray();
        return borderSize;
    }

    public static <T> IntervalView<T> shrink(RandomAccessibleInterval<T> source, long[] margin) {
        assert (margin.length == source.numDimensions()) : "Dimensionality mismatch.";
        assert (Arrays.stream(margin).min().getAsLong() >= 0L) : "Margin cannot be negative";
        assert (IntStream.range(0, margin.length).mapToLong(d -> source.dimension(d) - 2L * margin[d]).min().getAsLong() >= 0L) : "Margin bigger than input";
        return Views.expandBorder(source, (long[])Arrays.stream(margin).map(m -> -m).toArray());
    }

    public static int getBiggestDimension(Interval interval) {
        int nDim = interval.numDimensions();
        int splitDim = (Integer)IntStream.range(0, nDim).mapToObj(d -> new ValuePair((Object)d, (Object)interval.dimension(d))).max((p1, p2) -> Long.compare((Long)p1.getB(), (Long)p2.getB())).get().getA();
        return splitDim;
    }

    public static class MinimumCheck<T extends Comparable<T>>
    implements LocalNeighborhoodCheck<Point, T> {
        final T maxPeakValue;

        public MinimumCheck(T maxPeakValue) {
            this.maxPeakValue = maxPeakValue;
        }

        @Override
        public <C extends Localizable & Sampler<T>> Point check(C center, Neighborhood<T> neighborhood) {
            Comparable c = (Comparable)((Sampler<T>)center).get();
            if (this.maxPeakValue.compareTo((Comparable)c) < 0) {
                return null;
            }
            Iterator iterator = neighborhood.iterator();
            while (iterator.hasNext()) {
                Comparable t = (Comparable)iterator.next();
                if (t.compareTo(c) >= 0) continue;
                return null;
            }
            return new Point(center);
        }
    }

    public static class MaximumCheck<T extends Comparable<T>>
    implements LocalNeighborhoodCheck<Point, T> {
        final T minPeakValue;

        public MaximumCheck(T minPeakValue) {
            this.minPeakValue = minPeakValue;
        }

        @Override
        public <C extends Localizable & Sampler<T>> Point check(C center, Neighborhood<T> neighborhood) {
            Comparable c = (Comparable)((Sampler<T>)center).get();
            if (this.minPeakValue.compareTo((Comparable)c) > 0) {
                return null;
            }
            Iterator iterator = neighborhood.iterator();
            while (iterator.hasNext()) {
                Comparable t = (Comparable)iterator.next();
                if (t.compareTo(c) <= 0) continue;
                return null;
            }
            return new Point(center);
        }
    }

    public static interface LocalNeighborhoodCheck<P, T> {
        public <C extends Localizable & Sampler<T>> P check(C var1, Neighborhood<T> var2);
    }
}

