/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.labeling;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingOutOfBoundsRandomAccessFactory;
import net.imglib2.labeling.LabelingType;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.type.logic.BitType;
import net.imglib2.view.Views;

@Deprecated
public class AllConnectedComponents {
    public static <T extends Comparable<T>> void labelAllConnectedComponents(Labeling<T> labeling, RandomAccessibleInterval<BitType> img, Iterator<T> names) throws NoSuchElementException {
        long[][] offsets = AllConnectedComponents.getStructuringElement(img.numDimensions());
        AllConnectedComponents.labelAllConnectedComponents(labeling, img, names, offsets);
    }

    public static <T extends Comparable<T>> void labelAllConnectedComponents(Labeling<T> labeling, RandomAccessibleInterval<BitType> img, Iterator<T> names, long[][] structuringElement) throws NoSuchElementException {
        Cursor c = Views.iterable(img).localizingCursor();
        RandomAccess raSrc = img.randomAccess();
        LabelingOutOfBoundsRandomAccessFactory factory = new LabelingOutOfBoundsRandomAccessFactory();
        OutOfBounds raDest = factory.create(labeling);
        long[] srcPosition = new long[img.numDimensions()];
        long[] destPosition = new long[labeling.numDimensions()];
        long[] dimensions = new long[labeling.numDimensions()];
        labeling.dimensions(dimensions);
        PositionStack toDoList = new PositionStack(img.numDimensions());
        while (c.hasNext()) {
            BitType t = (BitType)c.next();
            if (!t.get()) continue;
            c.localize(srcPosition);
            boolean outOfBounds = false;
            for (int i = 0; i < dimensions.length; ++i) {
                if (srcPosition[i] < dimensions[i]) continue;
                outOfBounds = true;
                break;
            }
            if (outOfBounds) continue;
            raDest.setPosition(srcPosition);
            LabelingType label = (LabelingType)raDest.get();
            if (!label.getLabeling().isEmpty()) continue;
            List<Comparable> currentLabel = label.intern((Comparable)names.next());
            label.setLabeling(currentLabel);
            toDoList.push(srcPosition);
            while (!toDoList.isEmpty()) {
                toDoList.pop(srcPosition);
                for (long[] offset : structuringElement) {
                    outOfBounds = false;
                    for (int i = 0; i < offset.length; ++i) {
                        destPosition[i] = srcPosition[i] + offset[i];
                        if (destPosition[i] >= 0L && destPosition[i] < dimensions[i]) continue;
                        outOfBounds = true;
                        break;
                    }
                    if (outOfBounds) continue;
                    raSrc.setPosition(destPosition);
                    if (!((BitType)raSrc.get()).get()) continue;
                    raDest.setPosition(destPosition);
                    label = (LabelingType)raDest.get();
                    if (!label.getLabeling().isEmpty()) continue;
                    label.setLabeling(currentLabel);
                    toDoList.push(destPosition);
                }
            }
        }
    }

    public static long[][] getStructuringElement(int dimensions) {
        int nElements = 1;
        for (int i = 0; i < dimensions; ++i) {
            nElements *= 3;
        }
        long[][] result = new long[--nElements][dimensions];
        long[] position = new long[dimensions];
        Arrays.fill(position, -1L);
        block1: for (int i = 0; i < nElements; ++i) {
            System.arraycopy(position, 0, result[i], 0, dimensions);
            if (i == nElements / 2 - 1) {
                position[0] = position[0] + 2L;
                continue;
            }
            for (int j = 0; j < dimensions; ++j) {
                if (position[j] != 1L) {
                    int n = j;
                    position[n] = position[n] + 1L;
                    continue block1;
                }
                position[j] = -1L;
            }
        }
        return result;
    }

    public static Iterator<Integer> getIntegerNames(final int start) {
        return new Iterator<Integer>(){
            int current;
            {
                this.current = start;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Integer next() {
                return this.current++;
            }

            @Override
            public void remove() {
            }
        };
    }

    protected static class PositionStack {
        private final int dimensions;
        private long[] storage;
        private int position = 0;

        public PositionStack(int dimensions) {
            this.dimensions = dimensions;
            this.storage = new long[100 * dimensions];
        }

        public void push(long[] position) {
            int insertPoint = this.position * this.dimensions;
            if (this.storage.length == insertPoint) {
                long[] newStorage = new long[this.position * 3 / 2 * this.dimensions];
                System.arraycopy(this.storage, 0, newStorage, 0, this.storage.length);
                this.storage = newStorage;
            }
            System.arraycopy(position, 0, this.storage, insertPoint, this.dimensions);
            ++this.position;
        }

        public void pop(long[] position) {
            --this.position;
            System.arraycopy(this.storage, this.position * this.dimensions, position, 0, this.dimensions);
        }

        public boolean isEmpty() {
            return this.position == 0;
        }
    }
}

