/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.algorithm.kdtree.HyperPlane;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.util.LinAlgHelpers;

public class ConvexPolytope
extends AbstractEuclideanSpace {
    private final Collection<? extends HyperPlane> hyperplanes;

    public ConvexPolytope(Collection<? extends HyperPlane> hyperplanes) {
        super(hyperplanes.iterator().next().numDimensions());
        this.hyperplanes = hyperplanes;
    }

    public ConvexPolytope(HyperPlane ... hyperplanes) {
        this(Arrays.asList(hyperplanes));
    }

    public Collection<? extends HyperPlane> getHyperplanes() {
        return this.hyperplanes;
    }

    public static ConvexPolytope transform(ConvexPolytope polytope, AffineGet transform) {
        assert (polytope.numDimensions() == transform.numDimensions());
        int n = transform.numDimensions();
        double[] O = new double[n];
        double[] tO = new double[n];
        double[] tN = new double[n];
        double[][] m = new double[n][n];
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n; ++c) {
                m[r][c] = transform.inverse().get(c, r);
            }
        }
        ArrayList<HyperPlane> transformedPlanes = new ArrayList<HyperPlane>();
        for (HyperPlane hyperPlane : polytope.getHyperplanes()) {
            LinAlgHelpers.scale((double[])hyperPlane.getNormal(), (double)hyperPlane.getDistance(), (double[])O);
            transform.apply(O, tO);
            LinAlgHelpers.mult((double[][])m, (double[])hyperPlane.getNormal(), (double[])tN);
            LinAlgHelpers.normalize((double[])tN);
            double td = LinAlgHelpers.dot((double[])tN, (double[])tO);
            transformedPlanes.add(new HyperPlane(tN, td));
        }
        return new ConvexPolytope(transformedPlanes);
    }
}

