/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.interpolation.randomaccess;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.position.transform.Floor;
import net.imglib2.type.numeric.RealType;

public class BSplineInterpolator<T extends RealType<T>>
extends Floor<RandomAccess<Neighborhood<T>>>
implements RealRandomAccess<T> {
    public static final double SQRT3 = Math.sqrt(3.0);
    public static final double ALPHA = SQRT3 - 2.0;
    public static final double FACTOR = -6.0 * ALPHA / (1.0 - ALPHA * ALPHA);
    public static final double ONESIXTH = 0.16666666666666666;
    public static final double TWOTHIRDS = 0.6666666666666666;
    public static final double FOURTHIRDS = 1.3333333333333333;
    protected double w;
    protected final T value;
    protected final double[][] weights;
    protected final boolean clipping;
    protected final int radius;
    protected final RectangleShape shape;

    public BSplineInterpolator(BSplineInterpolator<T> interpolator) {
        super((Localizable)((RandomAccess)interpolator.target).copy());
        this.shape = interpolator.shape;
        this.radius = 4;
        this.clipping = interpolator.clipping;
        ((RandomAccess)this.target).setPosition(new int[this.numDimensions()]);
        this.value = (RealType)((RealType)((Neighborhood)((RandomAccess)this.target).get()).firstElement()).createVariable();
        this.weights = new double[this.numDimensions()][this.shape.getSpan() * 2 + 1];
    }

    private BSplineInterpolator(RandomAccessible<T> source, RectangleShape shape, boolean clipping) {
        super(shape.neighborhoodsRandomAccessible((RandomAccessible)source).randomAccess());
        this.shape = shape;
        this.radius = 4;
        this.clipping = clipping;
        ((RandomAccess)this.target).setPosition(new int[this.numDimensions()]);
        this.value = (RealType)((RealType)((Neighborhood)((RandomAccess)this.target).get()).firstElement()).createVariable();
        this.weights = new double[this.numDimensions()][shape.getSpan() * 2 + 1];
    }

    public BSplineInterpolator(RandomAccessible<T> source, int radius, boolean clipping) {
        this(source, new RectangleShape(radius, false), clipping);
    }

    protected BSplineInterpolator(RandomAccessibleInterval<T> randomAccessible) {
        this((RandomAccessible<T>)randomAccessible, 4, true);
    }

    public T get() {
        this.fillWeights();
        double accumulator = 0.0;
        Cursor c = ((Neighborhood)((RandomAccess)this.target).get()).cursor();
        while (c.hasNext()) {
            double tmp = ((RealType)c.next()).getRealDouble();
            for (int d = 0; d < this.numDimensions(); ++d) {
                int index = (int)(c.getLongPosition(d) - ((RandomAccess)this.target).getLongPosition(d) + (long)this.shape.getSpan());
                tmp *= this.weights[d][index];
            }
            accumulator += tmp;
        }
        if (this.clipping) {
            this.value.setReal(Math.min(this.value.getMaxValue(), Math.max(this.value.getMinValue(), accumulator)));
        } else {
            this.value.setReal(accumulator);
        }
        return this.value;
    }

    protected void fillWeights() {
        Neighborhood rect = (Neighborhood)((RandomAccess)this.target).get();
        for (int d = 0; d < this.numDimensions(); ++d) {
            double pos = this.position[d];
            long min = rect.min(d);
            long max = rect.max(d);
            for (long i = min; i <= max; ++i) {
                this.weights[d][(int)(i - min)] = BSplineInterpolator.cubicCardinalSpline(pos - (double)i, this.radius);
            }
        }
    }

    public BSplineInterpolator<T> copy() {
        return new BSplineInterpolator<T>(this);
    }

    public BSplineInterpolator<T> copyRealRandomAccess() {
        return this.copy();
    }

    public static double evaluate3Normalized(double u) {
        double absValue = Math.abs(u);
        double sqrValue = u * u;
        if (absValue <= 1.0) {
            return 0.6666666666666666 - sqrValue + 0.5 * sqrValue * absValue;
        }
        if (absValue < 2.0) {
            double twoMinusAbsValue = 2.0 - absValue;
            return twoMinusAbsValue * twoMinusAbsValue * twoMinusAbsValue * 0.16666666666666666;
        }
        return 0.0;
    }

    private static double powIntPositive(double base, int pow) {
        double result = 1.0;
        for (int i = 0; i < pow; ++i) {
            result *= base;
        }
        return result;
    }

    public static double cubicCardinalSpline(double x, int width) {
        double result = 0.0;
        for (int k = -width; k <= width; ++k) {
            result += BSplineInterpolator.powIntPositive(ALPHA, Math.abs(k)) * BSplineInterpolator.evaluate3Normalized(x - (double)k);
        }
        return result *= FACTOR;
    }
}

