/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution.kernel;

import java.util.Arrays;
import java.util.List;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.convolution.LineConvolverFactory;
import net.imglib2.algorithm.convolution.kernel.ConvolverNativeType;
import net.imglib2.algorithm.convolution.kernel.ConvolverNumericType;
import net.imglib2.algorithm.convolution.kernel.DoubleConvolverRealType;
import net.imglib2.algorithm.convolution.kernel.FloatConvolverRealType;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public class KernelConvolverFactory
implements LineConvolverFactory<NumericType<?>> {
    private final Kernel1D kernel;
    private static final List<Entry> factories = Arrays.asList(new Entry(DoubleConvolverRealType.class, RealType.class, DoubleType.class), new Entry(FloatConvolverRealType.class, RealType.class, RealType.class), new Entry(ConvolverNativeType.class, null, NativeType.class), new Entry(ConvolverNumericType.class, null, NumericType.class));

    public KernelConvolverFactory(Kernel1D kernel) {
        this.kernel = kernel;
    }

    @Override
    public long getBorderBefore() {
        return this.kernel.max();
    }

    @Override
    public long getBorderAfter() {
        return -this.kernel.min();
    }

    @Override
    public Runnable getConvolver(RandomAccess<? extends NumericType<?>> in, RandomAccess<? extends NumericType<?>> out, int d, long lineLength) {
        NumericType targetType = (NumericType)out.get();
        NumericType sourceType = (NumericType)in.get();
        ClassCopyProvider<Runnable> provider = this.getProvider(sourceType, targetType);
        List<Class> key = Arrays.asList(in.getClass(), out.getClass(), sourceType.getClass(), targetType.getClass());
        return (Runnable)provider.newInstanceForKey(key, new Object[]{this.kernel, in, out, d, lineLength});
    }

    @Override
    public NumericType<?> preferredSourceType(NumericType<?> targetType) {
        if (targetType instanceof DoubleType) {
            return targetType;
        }
        if (targetType instanceof RealType) {
            return new FloatType();
        }
        return targetType;
    }

    private ClassCopyProvider<Runnable> getProvider(NumericType<?> sourceType, NumericType<?> targetType) {
        for (Entry entry : factories) {
            if (!entry.supported(sourceType, targetType)) continue;
            return entry.provider;
        }
        throw new IllegalArgumentException("Convolution is not supported for the given source and target type, source: " + sourceType.getClass().getSimpleName() + " target: " + targetType.getClass().getSimpleName());
    }

    private static class Entry {
        private final ClassCopyProvider<Runnable> provider;
        private final Class<? extends Type> sourceClass;
        private final Class<? extends Type> targetClass;

        private Entry(Class<? extends Runnable> convolverClass, Class<? extends Type> sourceClass, Class<? extends Type> targetClass) {
            this.provider = new ClassCopyProvider(convolverClass, Runnable.class, new Class[0]);
            this.sourceClass = sourceClass;
            this.targetClass = targetClass;
        }

        private boolean supported(Object sourceType, Type<?> targetType) {
            if (!this.targetClass.isInstance(targetType)) {
                return false;
            }
            Class<Object> sourceClass = this.sourceClass == null ? targetType.getClass() : this.sourceClass;
            return sourceClass.isInstance(sourceType);
        }
    }
}

