/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution;

import java.util.concurrent.ExecutorService;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.Convolution;
import net.imglib2.algorithm.convolution.LineConvolverFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.parallel.Parallelization;
import net.imglib2.parallel.TaskExecutor;
import net.imglib2.parallel.TaskExecutors;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.util.Localizables;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class LineConvolution<T>
implements Convolution<T> {
    private final LineConvolverFactory<? super T> factory;
    private final int direction;
    private ExecutorService executor;

    public LineConvolution(LineConvolverFactory<? super T> factory, int direction) {
        this.factory = factory;
        this.direction = direction;
    }

    @Override
    @Deprecated
    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public Interval requiredSourceInterval(Interval targetInterval) {
        long[] min = Intervals.minAsLongArray((Interval)targetInterval);
        long[] max = Intervals.maxAsLongArray((Interval)targetInterval);
        int n = this.direction;
        min[n] = min[n] - this.factory.getBorderBefore();
        int n2 = this.direction;
        max[n2] = max[n2] + this.factory.getBorderAfter();
        return new FinalInterval(min, max);
    }

    @Override
    public T preferredSourceType(T targetType) {
        return (T)Cast.unchecked(this.factory.preferredSourceType(targetType));
    }

    @Override
    public void process(RandomAccessible<? extends T> source, RandomAccessibleInterval<? extends T> target) {
        IntervalView sourceInterval = Views.interval(source, (Interval)this.requiredSourceInterval((Interval)target));
        long[] sourceMin = Intervals.minAsLongArray((Interval)sourceInterval);
        long[] targetMin = Intervals.minAsLongArray(target);
        long[] dim = Intervals.dimensionsAsLongArray(target);
        dim[this.direction] = 1L;
        RandomAccessibleInterval positions = Localizables.randomAccessibleInterval((Interval)new FinalInterval(dim));
        TaskExecutor taskExecutor = this.executor == null ? Parallelization.getTaskExecutor() : TaskExecutors.forExecutorService((ExecutorService)this.executor);
        LoopBuilder.setImages((RandomAccessibleInterval)positions).multiThreaded(taskExecutor).forEachChunk(arg_0 -> this.lambda$process$1((RandomAccessibleInterval)sourceInterval, target, sourceMin, targetMin, arg_0));
    }

    private /* synthetic */ Object lambda$process$1(RandomAccessibleInterval sourceInterval, RandomAccessibleInterval target, long[] sourceMin, long[] targetMin, LoopBuilder.Chunk chunk) {
        RandomAccess in = sourceInterval.randomAccess();
        RandomAccess out = target.randomAccess();
        Runnable convolver = this.factory.getConvolver(in, out, this.direction, target.dimension(this.direction));
        chunk.forEachPixel(position -> {
            in.setPosition(sourceMin);
            out.setPosition(targetMin);
            in.move(position);
            out.move(position);
            convolver.run();
        });
        return null;
    }
}

