/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.pixellist;

import java.util.ArrayList;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.componenttree.PartialComponent;
import net.imglib2.algorithm.componenttree.pixellist.PixelList;
import net.imglib2.algorithm.componenttree.pixellist.PixelListComponent;
import net.imglib2.algorithm.componenttree.pixellist.PixelListPartialComponentGenerator;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.LongType;

final class PixelListPartialComponent<T extends Type<T>>
implements PartialComponent<T, PixelListPartialComponent<T>> {
    private final T value;
    final PixelList pixelList;
    final ArrayList<PixelListPartialComponent<T>> children;
    PixelListComponent<T> emittedComponent;

    PixelListPartialComponent(T value, PixelListPartialComponentGenerator<T> generator) {
        this.pixelList = new PixelList((RandomAccess<LongType>)generator.linkedList.randomAccess(), generator.dimensions);
        this.value = value.copy();
        this.children = new ArrayList();
        this.emittedComponent = null;
    }

    @Override
    public void addPosition(Localizable position) {
        this.pixelList.addPosition(position);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value.set(value);
    }

    @Override
    public void merge(PixelListPartialComponent<T> component) {
        this.pixelList.merge(component.pixelList);
        this.children.add(component);
    }

    public String toString() {
        String s = "{" + this.value.toString() + " : ";
        boolean first = true;
        for (Localizable l : this.pixelList) {
            if (first) {
                first = false;
            } else {
                s = s + ", ";
            }
            s = s + l.toString();
        }
        return s + "}";
    }
}

