/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.bspline;

import java.util.Arrays;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.algorithm.bspline.BSplineCoefficientsInterpolator;
import net.imglib2.algorithm.bspline.BSplineDecomposition;
import net.imglib2.algorithm.lazy.Lazy;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public class BSplineLazyCoefficientsInterpolatorFactory<T extends RealType<T>, S extends RealType<S> & NativeType<S>>
implements InterpolatorFactory<S, RandomAccessible<T>> {
    protected final int order;
    protected final boolean clipping;
    protected final Interval interval;
    protected RandomAccessibleInterval<S> coefficientStorage;
    protected RandomAccessible<S> coefficientAccess;
    protected S coefficientType;
    protected final OutOfBoundsFactory<?, ?> oobFactory;
    protected int[] blockSize;

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessible<T> img, Interval interval, int order, boolean clipping, S coefficientType, int[] blockSize, OutOfBoundsFactory<? extends RealType<?>, ?> oobFactory) {
        this.order = order;
        this.clipping = clipping;
        this.interval = interval;
        this.blockSize = blockSize;
        this.coefficientType = coefficientType;
        this.oobFactory = oobFactory;
        ExtendedRandomAccessibleInterval extendedImg = Views.extend((RandomAccessibleInterval)Views.interval(img, (Interval)interval), oobFactory);
        long[] min = Intervals.minAsLongArray((Interval)interval);
        BSplineDecomposition decomp = new BSplineDecomposition(Views.translateInverse((RandomAccessible)extendedImg, (long[])min));
        LazyCellImgFactory factory = new LazyCellImgFactory(decomp, interval, blockSize, coefficientType);
        if (Arrays.stream(min).allMatch(x -> x == 0L)) {
            this.coefficientStorage = factory.create((Dimensions)interval);
        } else {
            Img coefficientsBase = factory.create((Dimensions)interval);
            this.coefficientStorage = Views.translate((RandomAccessibleInterval)coefficientsBase, (long[])min);
        }
        this.coefficientAccess = Views.extend(this.coefficientStorage, oobFactory);
    }

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessible<T> img, Interval interval, int order, boolean clipping, S coefficientType, int[] blockSize) {
        this(img, interval, order, clipping, coefficientType, blockSize, (OutOfBoundsFactory<RealType<?>, ?>)new OutOfBoundsConstantValueFactory((Object)new DoubleType()));
    }

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessible<T> img, int order, boolean clipping, S coefficientType, int[] blockSize, OutOfBoundsFactory<? extends RealType<?>, ?> oobFactory) {
        this.order = order;
        this.clipping = clipping;
        this.blockSize = blockSize;
        this.coefficientType = coefficientType;
        this.oobFactory = oobFactory;
        long[] min = new long[img.numDimensions()];
        Arrays.fill(min, -2147483L);
        long[] max = new long[img.numDimensions()];
        Arrays.fill(max, 2147483L);
        this.interval = new FinalInterval(min, max);
        BSplineDecomposition decomp = new BSplineDecomposition(Views.translateInverse(img, (long[])min));
        LazyCellImgFactory factory = new LazyCellImgFactory(decomp, this.interval, blockSize, coefficientType);
        Img coefficientsBase = factory.create((Dimensions)this.interval);
        this.coefficientStorage = Views.translate((RandomAccessibleInterval)coefficientsBase, (long[])min);
        this.coefficientAccess = Views.extendZero(this.coefficientStorage);
    }

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessible<T> img, int order, boolean clipping, S coefficientType, int[] blockSize) {
        this(img, order, clipping, coefficientType, blockSize, (OutOfBoundsFactory<RealType<?>, ?>)new OutOfBoundsConstantValueFactory((Object)new DoubleType()));
    }

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessible<T> img, Interval interval, int order, boolean clipping, int[] blockSize) {
        this(img, interval, order, clipping, new DoubleType(), blockSize);
    }

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessible<T> img, Interval interval, int order, int[] blockSize) {
        this(img, interval, order, true, new DoubleType(), blockSize);
    }

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessible<T> img, Interval interval, int[] blockSize) {
        this(img, interval, 3, true, new DoubleType(), blockSize);
    }

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessibleInterval<T> img, int[] blockSize) {
        this((RandomAccessible<T>)img, (Interval)img, 3, true, new DoubleType(), blockSize);
    }

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessibleInterval<T> img, int order, boolean clipping, S coefficientType, int[] blockSize) {
        this((RandomAccessible<T>)img, (Interval)img, order, clipping, blockSize);
    }

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessibleInterval<T> img, int order, boolean clipping, int[] blockSize) {
        this((RandomAccessible<T>)img, (Interval)img, order, clipping, new DoubleType(), blockSize);
    }

    public BSplineLazyCoefficientsInterpolatorFactory(RandomAccessibleInterval<T> img, int order, int[] blockSize) {
        this((RandomAccessible<T>)img, (Interval)img, order, true, new DoubleType(), blockSize);
    }

    public RealRandomAccess<S> create(RandomAccessible<T> f) {
        return BSplineCoefficientsInterpolator.build(this.order, this.coefficientAccess, (RealType)this.coefficientType.copy());
    }

    public RealRandomAccess<S> create(RandomAccessible<T> f, RealInterval interval) {
        return this.create(f);
    }

    public static class LazyCellImgFactory<T extends RealType<T>, S extends RealType<S> & NativeType<S>>
    extends ImgFactory<S> {
        private int[] blockSize;
        private S type;
        private Interval interval;
        private BSplineDecomposition<T, S> decomposition;

        public LazyCellImgFactory(int order, RandomAccessibleInterval<T> img, int[] blockSize, S type) {
            super(type);
            this.blockSize = blockSize;
            this.type = type;
            this.interval = img;
            this.decomposition = new BSplineDecomposition(order, img);
        }

        public LazyCellImgFactory(BSplineDecomposition<T, S> decomposition, Interval interval, int[] blockSize, S type) {
            super(type);
            this.blockSize = blockSize;
            this.type = type;
            this.interval = interval;
            this.decomposition = decomposition;
        }

        public Img<S> create(long ... dimensions) {
            return this.create(dimensions, this.type);
        }

        public <R> ImgFactory<R> imgFactory(R type) throws IncompatibleTypeException {
            if (type instanceof RealType && type instanceof NativeType) {
                return new LazyCellImgFactory<T, RealType>(this.decomposition, this.interval, this.blockSize, (RealType)type);
            }
            throw new IncompatibleTypeException((Object)this, "type must be RealType and NativeType");
        }

        public Img<S> create(long[] dim, S type) {
            return Lazy.generate(this.interval, this.blockSize, (NativeType)type, AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE), this.decomposition);
        }
    }
}

