/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.bspline;

import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealLocalizable;
import net.imglib2.algorithm.bspline.BSplineCoefficientsInterpolator;
import net.imglib2.algorithm.bspline.BSplineCoefficientsInterpolatorFunction;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.position.transform.Floor;
import net.imglib2.type.numeric.RealType;

public class BSplineCoefficientsInterpolatorOdd<T extends RealType<T>>
extends Floor<RandomAccess<Neighborhood<T>>>
implements BSplineCoefficientsInterpolator<T> {
    protected final int bsplineOrder;
    protected final RectangleShape shape;
    private final BSplineCoefficientsInterpolatorFunction<T> kernel;

    private BSplineCoefficientsInterpolatorOdd(BSplineCoefficientsInterpolatorOdd<T> interpolator, int order, T type) {
        super((Localizable)((RandomAccess)interpolator.target).copy());
        assert (order % 2 == 1);
        this.bsplineOrder = interpolator.bsplineOrder;
        this.shape = BSplineCoefficientsInterpolator.shapeFromOrder(this.bsplineOrder);
        this.kernel = new BSplineCoefficientsInterpolatorFunction<T>(order, (RandomAccess)this.target, (RealLocalizable)this, type);
    }

    private BSplineCoefficientsInterpolatorOdd(int order, RandomAccessible<T> coefficients, T type, RectangleShape shape) {
        super(shape.neighborhoodsRandomAccessible((RandomAccessible)coefficients).randomAccess());
        assert (order % 2 == 1);
        this.shape = shape;
        this.bsplineOrder = order;
        this.kernel = new BSplineCoefficientsInterpolatorFunction<T>(order, (RandomAccess)this.target, (RealLocalizable)this, type);
    }

    public BSplineCoefficientsInterpolatorOdd(int order, RandomAccessible<T> coefficients, T type) {
        this(order, coefficients, type, BSplineCoefficientsInterpolator.shapeFromOrder(order));
    }

    public T get() {
        return this.kernel.get();
    }

    @Override
    public BSplineCoefficientsInterpolatorOdd<T> copy() {
        return new BSplineCoefficientsInterpolatorOdd<RealType>(this, this.bsplineOrder, (RealType)this.kernel.type().copy());
    }

    public long getLongPosition(int d) {
        return (long)Math.floor(this.position[d]);
    }

    public int getIntPosition(int d) {
        return (int)Math.floor(this.position[d]);
    }

    public void localize(long[] position) {
        int n = this.numDimensions();
        for (int d = 0; d < n; ++d) {
            position[d] = this.getLongPosition(d);
        }
    }

    public void localize(int[] position) {
        int n = this.numDimensions();
        for (int d = 0; d < n; ++d) {
            position[d] = this.getIntPosition(d);
        }
    }
}

