/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.bspline;

import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.algorithm.bspline.BSplineCoefficientsInterpolatorEven;
import net.imglib2.algorithm.bspline.BSplineCoefficientsInterpolatorOdd;
import net.imglib2.algorithm.neighborhood.GeneralRectangleShape;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.type.numeric.RealType;

public interface BSplineCoefficientsInterpolator<T extends RealType<T>>
extends RealRandomAccess<T>,
InterpolatorFactory<T, RandomAccessibleInterval<T>>,
Localizable {
    public static <S extends RealType<S>> BSplineCoefficientsInterpolator<S> build(int order, RandomAccessible<S> coefficients, S type) {
        if (order % 2 == 0) {
            return new BSplineCoefficientsInterpolatorEven<S>(order, coefficients, type);
        }
        return new BSplineCoefficientsInterpolatorOdd<S>(order, coefficients, type);
    }

    public BSplineCoefficientsInterpolator<T> copy();

    default public RealRandomAccess<T> create(RandomAccessibleInterval<T> f) {
        return this.copy();
    }

    default public RealRandomAccess<T> create(RandomAccessibleInterval<T> f, RealInterval interval) {
        return this.copy();
    }

    default public RealRandomAccess<T> copyRealRandomAccess() {
        return this.copy();
    }

    public static RectangleShape shapeFromOrder(int bsplineOrder) {
        if (!(1.$assertionsDisabled || bsplineOrder <= 5 && bsplineOrder >= 0)) {
            throw new AssertionError();
        }
        switch (bsplineOrder) {
            case 0: {
                return new RectangleShape(0, false);
            }
            case 1: {
                return new RectangleShape(1, false);
            }
            case 2: {
                return new RectangleShape(1, false);
            }
            case 3: {
                return new GeneralRectangleShape(4, -1, false);
            }
            case 4: {
                return new RectangleShape(2, false);
            }
            case 5: {
                return new GeneralRectangleShape(6, -2, false);
            }
        }
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

