/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.downsample;

import java.util.Arrays;
import net.imglib2.algorithm.blocks.DefaultUnaryBlockOperator;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.algorithm.blocks.convert.ClampType;
import net.imglib2.algorithm.blocks.downsample.DownsampleBlockProcessors;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public class Downsample {
    public static long[] getDownsampledDimensions(long[] imgDimensions, boolean[] downsampleInDim) {
        int n = imgDimensions.length;
        if (downsampleInDim.length != n) {
            throw new IllegalArgumentException();
        }
        long[] destSize = new long[n];
        Arrays.setAll(destSize, d -> downsampleInDim[d] ? (imgDimensions[d] + 1L) / 2L : imgDimensions[d]);
        return destSize;
    }

    public static <T extends NativeType<T>> UnaryBlockOperator<T, T> downsample(T type, ComputationType computationType, Offset offset, boolean[] downsampleInDim) {
        boolean processAsFloat;
        switch (computationType) {
            case FLOAT: {
                processAsFloat = true;
                break;
            }
            case DOUBLE: {
                processAsFloat = false;
                break;
            }
            default: {
                PrimitiveType pt = type.getNativeTypeFactory().getPrimitiveType();
                processAsFloat = pt.equals((Object)PrimitiveType.FLOAT) || pt.getByteCount() < PrimitiveType.FLOAT.getByteCount();
            }
        }
        UnaryBlockOperator<FloatType, FloatType> op = processAsFloat ? Downsample.downsampleFloat(offset, downsampleInDim) : Downsample.downsampleDouble(offset, downsampleInDim);
        return op.adaptSourceType(type, ClampType.NONE).adaptTargetType(type, ClampType.NONE);
    }

    public static <T extends NativeType<T>> UnaryBlockOperator<T, T> downsample(T type, ComputationType computationType, Offset offset, int numDimensions) {
        boolean[] downsampleInDim = new boolean[numDimensions];
        Arrays.fill(downsampleInDim, true);
        return Downsample.downsample(type, computationType, offset, downsampleInDim);
    }

    public static <T extends NativeType<T>> UnaryBlockOperator<T, T> downsample(T type, Offset offset, int numDimensions) {
        return Downsample.downsample(type, ComputationType.AUTO, offset, numDimensions);
    }

    public static <T extends NativeType<T>> UnaryBlockOperator<T, T> downsample(T type, int numDimensions) {
        return Downsample.downsample(type, ComputationType.AUTO, Offset.HALF_PIXEL, numDimensions);
    }

    private static UnaryBlockOperator<FloatType, FloatType> downsampleFloat(Offset offset, boolean[] downsampleInDim) {
        FloatType type = new FloatType();
        return new DefaultUnaryBlockOperator<FloatType, FloatType>(type, type, offset == Offset.HALF_PIXEL ? new DownsampleBlockProcessors.HalfPixelFloat(downsampleInDim) : new DownsampleBlockProcessors.CenterFloat(downsampleInDim));
    }

    private static UnaryBlockOperator<DoubleType, DoubleType> downsampleDouble(Offset offset, boolean[] downsampleInDim) {
        DoubleType type = new DoubleType();
        return new DefaultUnaryBlockOperator<DoubleType, DoubleType>(type, type, offset == Offset.HALF_PIXEL ? new DownsampleBlockProcessors.HalfPixelDouble(downsampleInDim) : new DownsampleBlockProcessors.CenterDouble(downsampleInDim));
    }

    public static enum Offset {
        CENTERED,
        HALF_PIXEL;

    }

    public static enum ComputationType {
        FLOAT,
        DOUBLE,
        AUTO;

    }
}

