/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.downsample;

import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.downsample.AbstractDownsample;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Intervals;

abstract class AbstractDownsampleHalfPixel<T extends AbstractDownsampleHalfPixel<T, P>, P>
extends AbstractDownsample<T, P> {
    AbstractDownsampleHalfPixel(boolean[] downsampleInDim, PrimitiveType primitiveType) {
        super(downsampleInDim, primitiveType);
    }

    AbstractDownsampleHalfPixel(T downsample) {
        super(downsample);
    }

    @Override
    public void setTargetInterval(Interval interval) {
        boolean destSizeChanged = false;
        for (int d = 0; d < this.n; ++d) {
            long tpos = interval.min(d);
            this.sourcePos[d] = this.downsampleInDim[d] ? tpos * 2L : tpos;
            int tdim = AbstractDownsampleHalfPixel.safeInt(interval.dimension(d));
            if (tdim == this.destSize[d]) continue;
            this.destSize[d] = tdim;
            this.sourceSize[d] = this.downsampleInDim[d] ? tdim * 2 : tdim;
            destSizeChanged = true;
        }
        if (destSizeChanged) {
            int size;
            this.tempArraySizes[0] = size = AbstractDownsampleHalfPixel.safeInt(Intervals.numElements((int[])this.sourceSize));
            for (int i = 1; i < this.steps; ++i) {
                int d = this.downsampleDims[i - 1];
                this.tempArraySizes[i] = size = size / this.sourceSize[d] * this.destSize[d];
            }
        }
    }
}

