/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.downsample;

import java.util.Arrays;
import java.util.function.Supplier;
import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.util.BlockProcessorSourceInterval;
import net.imglib2.blocks.TempArray;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.CloseableThreadLocal;
import net.imglib2.util.Intervals;

abstract class AbstractDownsample<T extends AbstractDownsample<T, P>, P>
implements BlockProcessor<P, P> {
    PrimitiveType primitiveType;
    final int n;
    final int[] destSize;
    final long[] sourcePos;
    final int[] sourceSize;
    final boolean[] downsampleInDim;
    final int[] downsampleDims;
    final int steps;
    private final TempArray<P>[] tempArrays;
    final int[] tempArraySizes;
    private final BlockProcessorSourceInterval sourceInterval;
    Supplier<T> threadSafeSupplier;

    AbstractDownsample(boolean[] downsampleInDim, PrimitiveType primitiveType) {
        this.n = downsampleInDim.length;
        this.primitiveType = primitiveType;
        this.destSize = new int[this.n];
        this.sourceSize = new int[this.n];
        this.sourcePos = new long[this.n];
        this.downsampleInDim = downsampleInDim;
        this.downsampleDims = AbstractDownsample.downsampleDimIndices(downsampleInDim);
        this.steps = this.downsampleDims.length;
        this.tempArrays = AbstractDownsample.createTempArrays(this.steps, primitiveType);
        this.tempArraySizes = new int[this.steps];
        this.sourceInterval = new BlockProcessorSourceInterval(this);
    }

    private static int[] downsampleDimIndices(boolean[] downsampleInDim) {
        int n = downsampleInDim.length;
        int[] dims = new int[n];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (!downsampleInDim[i]) continue;
            dims[j++] = i;
        }
        return Arrays.copyOf(dims, j);
    }

    private static <P> TempArray<P>[] createTempArrays(int steps, PrimitiveType primitiveType) {
        TempArray[] tempArrays = new TempArray[steps];
        tempArrays[0] = TempArray.forPrimitiveType((PrimitiveType)primitiveType);
        if (steps >= 2) {
            tempArrays[1] = TempArray.forPrimitiveType((PrimitiveType)primitiveType);
            if (steps >= 3) {
                tempArrays[2] = TempArray.forPrimitiveType((PrimitiveType)primitiveType);
                for (int i = 3; i < steps; ++i) {
                    tempArrays[i] = tempArrays[i - 2];
                }
            }
        }
        return tempArrays;
    }

    AbstractDownsample(T downsample) {
        this.primitiveType = ((AbstractDownsample)downsample).primitiveType;
        this.n = ((AbstractDownsample)downsample).n;
        this.downsampleInDim = ((AbstractDownsample)downsample).downsampleInDim;
        this.downsampleDims = ((AbstractDownsample)downsample).downsampleDims;
        this.steps = ((AbstractDownsample)downsample).steps;
        this.threadSafeSupplier = ((AbstractDownsample)downsample).threadSafeSupplier;
        this.destSize = new int[this.n];
        this.sourcePos = new long[this.n];
        this.sourceSize = new int[this.n];
        this.tempArraySizes = new int[this.steps];
        this.tempArrays = AbstractDownsample.createTempArrays(this.steps, this.primitiveType);
        this.sourceInterval = new BlockProcessorSourceInterval(this);
    }

    abstract T newInstance();

    @Override
    public synchronized Supplier<T> threadSafeSupplier() {
        if (this.threadSafeSupplier == null) {
            this.threadSafeSupplier = () -> ((CloseableThreadLocal)CloseableThreadLocal.withInitial(this::newInstance)).get();
        }
        return this.threadSafeSupplier;
    }

    @Override
    public void setTargetInterval(Interval interval) {
        boolean destSizeChanged = false;
        for (int d = 0; d < this.n; ++d) {
            long tpos = interval.min(d);
            this.sourcePos[d] = this.downsampleInDim[d] ? tpos * 2L - 1L : tpos;
            int tdim = AbstractDownsample.safeInt(interval.dimension(d));
            if (tdim == this.destSize[d]) continue;
            this.destSize[d] = tdim;
            this.sourceSize[d] = this.downsampleInDim[d] ? tdim * 2 + 1 : tdim;
            destSizeChanged = true;
        }
        if (destSizeChanged) {
            int size;
            this.tempArraySizes[0] = size = AbstractDownsample.safeInt(Intervals.numElements((int[])this.sourceSize));
            for (int i = 1; i < this.steps; ++i) {
                int d = this.downsampleDims[i - 1];
                this.tempArraySizes[i] = size = size / this.sourceSize[d] * this.destSize[d];
            }
        }
    }

    static int safeInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value too large");
        }
        return (int)value;
    }

    @Override
    public int[] getSourceSize() {
        return this.sourceSize;
    }

    @Override
    public long[] getSourcePos() {
        return this.sourcePos;
    }

    @Override
    public Interval getSourceInterval() {
        return this.sourceInterval;
    }

    @Override
    public P getSourceBuffer() {
        return this.getSourceBuffer(0);
    }

    private P getSourceBuffer(int i) {
        return (P)this.tempArrays[i].get(this.tempArraySizes[i]);
    }

    @Override
    public void compute(P src, P dest) {
        P itSrc = src;
        int[] itDestSize = (int[])this.sourceSize.clone();
        for (int i = 0; i < this.steps; ++i) {
            int d = this.downsampleDims[i];
            itDestSize[d] = this.destSize[d];
            boolean lastStep = i == this.steps - 1;
            P itDest = lastStep ? dest : this.getSourceBuffer(i + 1);
            this.downsample(itSrc, itDestSize, itDest, d);
            itSrc = itDest;
        }
    }

    abstract void downsample(P var1, int[] var2, P var3, int var4);
}

