/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.convert;

import java.util.Arrays;
import java.util.function.Supplier;
import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.convert.ClampType;
import net.imglib2.algorithm.blocks.convert.ConvertLoop;
import net.imglib2.algorithm.blocks.convert.ConvertLoops;
import net.imglib2.algorithm.blocks.util.BlockProcessorSourceInterval;
import net.imglib2.algorithm.blocks.util.UnaryOperatorType;
import net.imglib2.blocks.TempArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.CloseableThreadLocal;
import net.imglib2.util.Intervals;

class ConvertBlockProcessor<S extends NativeType<S>, T extends NativeType<T>, I, O>
implements BlockProcessor<I, O> {
    private final S sourceType;
    private final T targetType;
    private final TempArray<I> tempArray;
    private final ConvertLoop<I, O> loop;
    private Supplier<ConvertBlockProcessor<S, T, I, O>> threadSafeSupplier;
    private long[] sourcePos;
    private int[] sourceSize;
    private int sourceLength;
    private final BlockProcessorSourceInterval sourceInterval;

    public ConvertBlockProcessor(S sourceType, T targetType, ClampType clamp) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.tempArray = TempArray.forPrimitiveType((PrimitiveType)sourceType.getNativeTypeFactory().getPrimitiveType());
        this.loop = ConvertLoops.get(UnaryOperatorType.of(sourceType, targetType), clamp);
        this.sourceInterval = new BlockProcessorSourceInterval(this);
    }

    private ConvertBlockProcessor(ConvertBlockProcessor<S, T, I, O> convert) {
        this.sourceType = convert.sourceType;
        this.targetType = convert.targetType;
        this.tempArray = convert.tempArray.newInstance();
        this.loop = convert.loop;
        this.sourceInterval = new BlockProcessorSourceInterval(this);
        this.threadSafeSupplier = convert.threadSafeSupplier;
    }

    private ConvertBlockProcessor<S, T, I, O> newInstance() {
        return new ConvertBlockProcessor<S, T, I, O>(this);
    }

    @Override
    public Supplier<? extends BlockProcessor<I, O>> threadSafeSupplier() {
        if (this.threadSafeSupplier == null) {
            this.threadSafeSupplier = () -> ((CloseableThreadLocal)CloseableThreadLocal.withInitial(this::newInstance)).get();
        }
        return this.threadSafeSupplier;
    }

    @Override
    public void setTargetInterval(Interval interval) {
        int n = interval.numDimensions();
        if (this.sourcePos == null || this.sourcePos.length != n) {
            this.sourcePos = new long[n];
            this.sourceSize = new int[n];
        }
        interval.min(this.sourcePos);
        Arrays.setAll(this.sourceSize, d -> ConvertBlockProcessor.safeInt(interval.dimension(d)));
        this.sourceLength = ConvertBlockProcessor.safeInt(Intervals.numElements((int[])this.sourceSize));
    }

    private static int safeInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value too large");
        }
        return (int)value;
    }

    @Override
    public long[] getSourcePos() {
        return this.sourcePos;
    }

    @Override
    public int[] getSourceSize() {
        return this.sourceSize;
    }

    @Override
    public Interval getSourceInterval() {
        return this.sourceInterval;
    }

    @Override
    public I getSourceBuffer() {
        return (I)this.tempArray.get(this.sourceLength);
    }

    @Override
    public void compute(I src, O dest) {
        this.loop.apply(src, dest, this.sourceLength);
    }
}

