/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.DefaultUnaryBlockOperator;
import net.imglib2.algorithm.blocks.convert.ClampType;
import net.imglib2.algorithm.blocks.convert.Convert;
import net.imglib2.type.NativeType;
import net.imglib2.util.Cast;

public interface UnaryBlockOperator<S extends NativeType<S>, T extends NativeType<T>> {
    public <I, O> BlockProcessor<I, O> blockProcessor();

    public S getSourceType();

    public T getTargetType();

    public UnaryBlockOperator<S, T> threadSafe();

    default public <U extends NativeType<U>> UnaryBlockOperator<S, U> andThen(UnaryBlockOperator<T, U> op) {
        return new DefaultUnaryBlockOperator<S, U>(this.getSourceType(), op.getTargetType(), this.blockProcessor().andThen(op.blockProcessor()));
    }

    default public <U extends NativeType<U>> UnaryBlockOperator<U, T> adaptSourceType(U newSourceType, ClampType clamp) {
        if (newSourceType.getClass().isInstance(this.getSourceType())) {
            return (UnaryBlockOperator)Cast.unchecked((Object)this);
        }
        return Convert.convert(newSourceType, this.getSourceType(), clamp).andThen(this);
    }

    default public <U extends NativeType<U>> UnaryBlockOperator<S, U> adaptTargetType(U newTargetType, ClampType clamp) {
        if (newTargetType.getClass().isInstance(this.getTargetType())) {
            return (UnaryBlockOperator)Cast.unchecked((Object)this);
        }
        return this.andThen(Convert.convert(this.getTargetType(), newTargetType, clamp));
    }
}

