/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import java.util.function.Supplier;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.type.NativeType;
import net.imglib2.util.Cast;

public class DefaultUnaryBlockOperator<S extends NativeType<S>, T extends NativeType<T>>
implements UnaryBlockOperator<S, T> {
    private final S sourceType;
    private final T targetType;
    private final BlockProcessor<?, ?> blockProcessor;

    public DefaultUnaryBlockOperator(S sourceType, T targetType, BlockProcessor<?, ?> blockProcessor) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.blockProcessor = blockProcessor;
    }

    @Override
    public <I, O> BlockProcessor<I, O> blockProcessor() {
        return (BlockProcessor)Cast.unchecked(this.blockProcessor);
    }

    @Override
    public S getSourceType() {
        return this.sourceType;
    }

    @Override
    public T getTargetType() {
        return this.targetType;
    }

    @Override
    public UnaryBlockOperator<S, T> threadSafe() {
        final Supplier<BlockProcessor<?, ?>> processorSupplier = this.blockProcessor.threadSafeSupplier();
        return new UnaryBlockOperator<S, T>(){

            @Override
            public <I, O> BlockProcessor<I, O> blockProcessor() {
                return (BlockProcessor)Cast.unchecked(processorSupplier.get());
            }

            @Override
            public S getSourceType() {
                return DefaultUnaryBlockOperator.this.sourceType;
            }

            @Override
            public T getTargetType() {
                return DefaultUnaryBlockOperator.this.targetType;
            }

            @Override
            public UnaryBlockOperator<S, T> threadSafe() {
                return this;
            }
        };
    }
}

