/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import java.util.function.Supplier;
import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.util.CloseableThreadLocal;

class ConcatenatedBlockProcessor<I, K, O>
implements BlockProcessor<I, O> {
    private final BlockProcessor<I, K> p0;
    private final BlockProcessor<K, O> p1;
    private Supplier<ConcatenatedBlockProcessor<I, K, O>> threadSafeSupplier;

    public ConcatenatedBlockProcessor(BlockProcessor<I, K> p0, BlockProcessor<K, O> p1) {
        this.p0 = p0;
        this.p1 = p1;
    }

    private ConcatenatedBlockProcessor(ConcatenatedBlockProcessor<I, K, O> processor) {
        this.p0 = processor.p0.threadSafeSupplier().get();
        this.p1 = processor.p1.threadSafeSupplier().get();
        this.threadSafeSupplier = processor.threadSafeSupplier;
    }

    @Override
    public Supplier<? extends BlockProcessor<I, O>> threadSafeSupplier() {
        if (this.threadSafeSupplier == null) {
            this.threadSafeSupplier = () -> ((CloseableThreadLocal)CloseableThreadLocal.withInitial(() -> new ConcatenatedBlockProcessor<I, K, O>(this))).get();
        }
        return this.threadSafeSupplier;
    }

    @Override
    public void setTargetInterval(Interval interval) {
        this.p1.setTargetInterval(interval);
        this.p0.setTargetInterval(this.p1.getSourceInterval());
    }

    @Override
    public long[] getSourcePos() {
        return this.p0.getSourcePos();
    }

    @Override
    public int[] getSourceSize() {
        return this.p0.getSourceSize();
    }

    @Override
    public Interval getSourceInterval() {
        return this.p0.getSourceInterval();
    }

    @Override
    public I getSourceBuffer() {
        return this.p0.getSourceBuffer();
    }

    @Override
    public void compute(I src, O dest) {
        this.p0.compute(src, this.p1.getSourceBuffer());
        this.p1.compute(this.p1.getSourceBuffer(), dest);
    }
}

