/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import java.util.function.Supplier;
import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.blocks.PrimitiveBlocks;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.ReadOnlyCachedCellImgFactory;
import net.imglib2.cache.img.ReadOnlyCachedCellImgOptions;
import net.imglib2.type.NativeType;

public class BlockAlgoUtils {
    public static <S extends NativeType<S>, T extends NativeType<T>, I, O> CellLoader<T> cellLoader(PrimitiveBlocks<S> blocks, UnaryBlockOperator<S, T> operator) {
        PrimitiveBlocks threadSafeBlocks = blocks.threadSafe();
        UnaryBlockOperator threadSafeOperator = operator.threadSafe();
        return cell -> {
            BlockProcessor processor = threadSafeOperator.blockProcessor();
            processor.setTargetInterval((Interval)cell);
            Object src = processor.getSourceBuffer();
            threadSafeBlocks.copy(processor.getSourcePos(), src, processor.getSourceSize());
            Object dest = cell.getStorageArray();
            processor.compute(src, dest);
        };
    }

    public static <S extends NativeType<S>, T extends NativeType<T>, I, O> CachedCellImg<T, ?> cellImg(PrimitiveBlocks<S> blocks, UnaryBlockOperator<S, T> operator, T type, long[] dimensions, int[] cellDimensions) {
        CellLoader<T> loader = BlockAlgoUtils.cellLoader(blocks, operator);
        return new ReadOnlyCachedCellImgFactory().create(dimensions, type, loader, (ReadOnlyCachedCellImgOptions)ReadOnlyCachedCellImgOptions.options().cellDimensions(cellDimensions));
    }

    public static <S extends NativeType<S>, T extends NativeType<T>, I, O> CellLoader<T> cellLoader(PrimitiveBlocks<S> blocks, BlockProcessor<I, O> blockProcessor) {
        PrimitiveBlocks threadSafeBlocks = blocks.threadSafe();
        Supplier processorSupplier = blockProcessor.threadSafeSupplier();
        return cell -> {
            BlockProcessor processor = (BlockProcessor)processorSupplier.get();
            processor.setTargetInterval((Interval)cell);
            Object src = processor.getSourceBuffer();
            threadSafeBlocks.copy(processor.getSourcePos(), src, processor.getSourceSize());
            Object dest = cell.getStorageArray();
            processor.compute(src, dest);
        };
    }

    public static <S extends NativeType<S>, T extends NativeType<T>, I, O> CachedCellImg<T, ?> cellImg(PrimitiveBlocks<S> blocks, BlockProcessor<I, O> blockProcessor, T type, long[] dimensions, int[] cellDimensions) {
        CellLoader<T> loader = BlockAlgoUtils.cellLoader(blocks, blockProcessor);
        return new ReadOnlyCachedCellImgFactory().create(dimensions, type, loader, (ReadOnlyCachedCellImgOptions)ReadOnlyCachedCellImgOptions.options().cellDimensions(cellDimensions));
    }
}

