/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineSet;
import net.imglib2.realtransform.RealViewsSimplifyUtils;

public class AffineTransform3D
implements AffineGet,
AffineSet,
Concatenable<AffineGet>,
PreConcatenable<AffineGet> {
    protected final AffineMatrix3D a;
    protected final RealPoint d0;
    protected final RealPoint d1;
    protected final RealPoint d2;
    protected final RealPoint[] ds;
    protected final AffineTransform3D inverse;

    public AffineTransform3D() {
        this(new AffineMatrix3D());
    }

    protected AffineTransform3D(AffineMatrix3D a) {
        this.a = a;
        this.d0 = new RealPoint(3);
        this.d1 = new RealPoint(3);
        this.d2 = new RealPoint(3);
        this.ds = new RealPoint[]{this.d0, this.d1, this.d2};
        this.updateDs();
        this.inverse = new AffineTransform3D(this);
        this.invert();
        this.inverse.updateDs();
    }

    protected AffineTransform3D(AffineTransform3D inverse) {
        this.inverse = inverse;
        this.a = new AffineMatrix3D();
        this.d0 = new RealPoint(3);
        this.d1 = new RealPoint(3);
        this.d2 = new RealPoint(3);
        this.ds = new RealPoint[]{this.d0, this.d1, this.d2};
    }

    protected void invert() {
        double det = this.a.det();
        if (det == 0.0) {
            throw new RuntimeException("Matrix is singular.");
        }
        double idet = 1.0 / det;
        this.inverse.a.m00 = (this.a.m11 * this.a.m22 - this.a.m12 * this.a.m21) * idet;
        this.inverse.a.m01 = (this.a.m02 * this.a.m21 - this.a.m01 * this.a.m22) * idet;
        this.inverse.a.m02 = (this.a.m01 * this.a.m12 - this.a.m02 * this.a.m11) * idet;
        this.inverse.a.m10 = (this.a.m12 * this.a.m20 - this.a.m10 * this.a.m22) * idet;
        this.inverse.a.m11 = (this.a.m00 * this.a.m22 - this.a.m02 * this.a.m20) * idet;
        this.inverse.a.m12 = (this.a.m02 * this.a.m10 - this.a.m00 * this.a.m12) * idet;
        this.inverse.a.m20 = (this.a.m10 * this.a.m21 - this.a.m11 * this.a.m20) * idet;
        this.inverse.a.m21 = (this.a.m01 * this.a.m20 - this.a.m00 * this.a.m21) * idet;
        this.inverse.a.m22 = (this.a.m00 * this.a.m11 - this.a.m01 * this.a.m10) * idet;
        this.inverse.a.m03 = -this.inverse.a.m00 * this.a.m03 - this.inverse.a.m01 * this.a.m13 - this.inverse.a.m02 * this.a.m23;
        this.inverse.a.m13 = -this.inverse.a.m10 * this.a.m03 - this.inverse.a.m11 * this.a.m13 - this.inverse.a.m12 * this.a.m23;
        this.inverse.a.m23 = -this.inverse.a.m20 * this.a.m03 - this.inverse.a.m21 * this.a.m13 - this.inverse.a.m22 * this.a.m23;
    }

    protected void updateDs() {
        this.d0.setPosition(this.a.m00, 0);
        this.d0.setPosition(this.a.m10, 1);
        this.d0.setPosition(this.a.m20, 2);
        this.d1.setPosition(this.a.m01, 0);
        this.d1.setPosition(this.a.m11, 1);
        this.d1.setPosition(this.a.m21, 2);
        this.d2.setPosition(this.a.m02, 0);
        this.d2.setPosition(this.a.m12, 1);
        this.d2.setPosition(this.a.m22, 2);
    }

    @Override
    public final void apply(double[] source, double[] target) {
        assert (source.length >= 3 && target.length >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        double t0 = source[0] * this.a.m00 + source[1] * this.a.m01 + source[2] * this.a.m02 + this.a.m03;
        double t1 = source[0] * this.a.m10 + source[1] * this.a.m11 + source[2] * this.a.m12 + this.a.m13;
        target[2] = source[0] * this.a.m20 + source[1] * this.a.m21 + source[2] * this.a.m22 + this.a.m23;
        target[0] = t0;
        target[1] = t1;
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length >= 3 && target.length >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        float t0 = (float)((double)source[0] * this.a.m00 + (double)source[1] * this.a.m01 + (double)source[2] * this.a.m02 + this.a.m03);
        float t1 = (float)((double)source[0] * this.a.m10 + (double)source[1] * this.a.m11 + (double)source[2] * this.a.m12 + this.a.m13);
        target[2] = (float)((double)source[0] * this.a.m20 + (double)source[1] * this.a.m21 + (double)source[2] * this.a.m22 + this.a.m23);
        target[0] = t0;
        target[1] = t1;
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= 3 && target.numDimensions() >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        double s0 = source.getDoublePosition(0);
        double s1 = source.getDoublePosition(1);
        double s2 = source.getDoublePosition(2);
        target.setPosition(s0 * this.a.m00 + s1 * this.a.m01 + s2 * this.a.m02 + this.a.m03, 0);
        target.setPosition(s0 * this.a.m10 + s1 * this.a.m11 + s2 * this.a.m12 + this.a.m13, 1);
        target.setPosition(s0 * this.a.m20 + s1 * this.a.m21 + s2 * this.a.m22 + this.a.m23, 2);
    }

    @Override
    public final void applyInverse(double[] source, double[] target) {
        assert (source.length >= 3 && target.length >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        double s0 = target[0] * this.inverse.a.m00 + target[1] * this.inverse.a.m01 + target[2] * this.inverse.a.m02 + this.inverse.a.m03;
        double s1 = target[0] * this.inverse.a.m10 + target[1] * this.inverse.a.m11 + target[2] * this.inverse.a.m12 + this.inverse.a.m13;
        source[2] = target[0] * this.inverse.a.m20 + target[1] * this.inverse.a.m21 + target[2] * this.inverse.a.m22 + this.inverse.a.m23;
        source[0] = s0;
        source[1] = s1;
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        assert (source.length >= 3 && target.length >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        float s0 = (float)((double)target[0] * this.inverse.a.m00 + (double)target[1] * this.inverse.a.m01 + (double)target[2] * this.inverse.a.m02 + this.inverse.a.m03);
        float s1 = (float)((double)target[0] * this.inverse.a.m10 + (double)target[1] * this.inverse.a.m11 + (double)target[2] * this.inverse.a.m12 + this.inverse.a.m13);
        source[2] = (float)((double)target[0] * this.inverse.a.m20 + (double)target[1] * this.inverse.a.m21 + (double)target[2] * this.inverse.a.m22 + this.inverse.a.m23);
        source[0] = s0;
        source[1] = s1;
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= 3 && target.numDimensions() >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        double t0 = target.getDoublePosition(0);
        double t1 = target.getDoublePosition(1);
        double t2 = target.getDoublePosition(2);
        source.setPosition(t0 * this.inverse.a.m00 + t1 * this.inverse.a.m01 + t2 * this.inverse.a.m02 + this.inverse.a.m03, 0);
        source.setPosition(t0 * this.inverse.a.m10 + t1 * this.inverse.a.m11 + t2 * this.inverse.a.m12 + this.inverse.a.m13, 1);
        source.setPosition(t0 * this.inverse.a.m20 + t1 * this.inverse.a.m21 + t2 * this.inverse.a.m22 + this.inverse.a.m23, 2);
    }

    public final AffineTransform3D concatenate(AffineTransform3D affine) {
        this.a.concatenate(affine.a);
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public final AffineTransform3D concatenate(AffineGet affine) {
        assert (affine.numSourceDimensions() >= 3) : "Only >=3d affine transformations can be concatenated to a 3d affine transformation.";
        this.a.concatenate(affine.getRowPackedCopy());
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    @Override
    public AffineTransform3D copy() {
        AffineMatrix3D ma = new AffineMatrix3D();
        ma.m00 = this.a.m00;
        ma.m10 = this.a.m10;
        ma.m20 = this.a.m20;
        ma.m01 = this.a.m01;
        ma.m11 = this.a.m11;
        ma.m21 = this.a.m21;
        ma.m02 = this.a.m02;
        ma.m12 = this.a.m12;
        ma.m22 = this.a.m22;
        ma.m03 = this.a.m03;
        ma.m13 = this.a.m13;
        ma.m23 = this.a.m23;
        return new AffineTransform3D(ma);
    }

    @Override
    public RealLocalizable d(int d) {
        return this.ds[d];
    }

    @Override
    public double get(int row, int column) {
        assert (row >= 0 && row < 3 && column >= 0 && column < 4) : "Index out of bounds, a 3d affine matrix is a 3x4 matrix.";
        switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        return this.a.m00;
                    }
                    case 1: {
                        return this.a.m01;
                    }
                    case 2: {
                        return this.a.m02;
                    }
                }
                return this.a.m03;
            }
            case 1: {
                switch (column) {
                    case 0: {
                        return this.a.m10;
                    }
                    case 1: {
                        return this.a.m11;
                    }
                    case 2: {
                        return this.a.m12;
                    }
                }
                return this.a.m13;
            }
        }
        switch (column) {
            case 0: {
                return this.a.m20;
            }
            case 1: {
                return this.a.m21;
            }
            case 2: {
                return this.a.m22;
            }
        }
        return this.a.m23;
    }

    @Override
    public double[] getRowPackedCopy() {
        return new double[]{this.a.m00, this.a.m01, this.a.m02, this.a.m03, this.a.m10, this.a.m11, this.a.m12, this.a.m13, this.a.m20, this.a.m21, this.a.m22, this.a.m23};
    }

    public Class<AffineGet> getConcatenableClass() {
        return AffineGet.class;
    }

    public Class<AffineGet> getPreConcatenableClass() {
        return AffineGet.class;
    }

    @Override
    public AffineTransform3D inverse() {
        return this.inverse;
    }

    public int numDimensions() {
        return 3;
    }

    @Override
    public int numSourceDimensions() {
        return 3;
    }

    @Override
    public int numTargetDimensions() {
        return 3;
    }

    public final AffineTransform3D preConcatenate(AffineTransform3D affine) {
        this.a.preConcatenate(affine.a);
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public final AffineTransform3D preConcatenate(AffineGet affine) {
        assert (affine.numSourceDimensions() == 3) : "Only 3d affine transformations can be preconcatenated to a 3d affine transformation.";
        this.a.preConcatenate(affine.getRowPackedCopy());
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public void rotate(int axis, double angle) {
        double dcos = Math.cos(angle);
        double dsin = Math.sin(angle);
        switch (axis) {
            case 0: {
                this.a.rotateX(dcos, dsin);
                break;
            }
            case 1: {
                this.a.rotateY(dcos, dsin);
                break;
            }
            default: {
                this.a.rotateZ(dcos, dsin);
            }
        }
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
    }

    public void scale(double s) {
        this.a.scale(s);
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
    }

    public void scale(double s0, double s1, double s2) {
        this.a.scale(s0, s1, s2);
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
    }

    public void translate(double ... translationVector) {
        this.a.m03 += translationVector[0];
        this.a.m13 += translationVector[1];
        this.a.m23 += translationVector[2];
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
    }

    public double[] getTranslation() {
        return new double[]{this.a.m03, this.a.m13, this.a.m23};
    }

    public void setTranslation(double ... translationVector) {
        this.a.m03 = translationVector[0];
        this.a.m13 = translationVector[1];
        this.a.m23 = translationVector[2];
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
    }

    public void identity() {
        this.set(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public final void set(AffineTransform3D m) {
        this.a.m00 = m.a.m00;
        this.a.m10 = m.a.m10;
        this.a.m20 = m.a.m20;
        this.a.m01 = m.a.m01;
        this.a.m11 = m.a.m11;
        this.a.m21 = m.a.m21;
        this.a.m02 = m.a.m02;
        this.a.m12 = m.a.m12;
        this.a.m22 = m.a.m22;
        this.a.m03 = m.a.m03;
        this.a.m13 = m.a.m13;
        this.a.m23 = m.a.m23;
        this.inverse.a.m00 = m.inverse.a.m00;
        this.inverse.a.m10 = m.inverse.a.m10;
        this.inverse.a.m20 = m.inverse.a.m20;
        this.inverse.a.m01 = m.inverse.a.m01;
        this.inverse.a.m11 = m.inverse.a.m11;
        this.inverse.a.m21 = m.inverse.a.m21;
        this.inverse.a.m02 = m.inverse.a.m02;
        this.inverse.a.m12 = m.inverse.a.m12;
        this.inverse.a.m22 = m.inverse.a.m22;
        this.inverse.a.m03 = m.inverse.a.m03;
        this.inverse.a.m13 = m.inverse.a.m13;
        this.inverse.a.m23 = m.inverse.a.m23;
        this.updateDs();
        this.inverse.updateDs();
    }

    public final void set(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.a.m00 = m00;
        this.a.m01 = m01;
        this.a.m02 = m02;
        this.a.m03 = m03;
        this.a.m10 = m10;
        this.a.m11 = m11;
        this.a.m12 = m12;
        this.a.m13 = m13;
        this.a.m20 = m20;
        this.a.m21 = m21;
        this.a.m22 = m22;
        this.a.m23 = m23;
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
    }

    public void toArray(double[] data) {
        data[0] = this.a.m00;
        data[1] = this.a.m01;
        data[2] = this.a.m02;
        data[3] = this.a.m03;
        data[4] = this.a.m10;
        data[5] = this.a.m11;
        data[6] = this.a.m12;
        data[7] = this.a.m13;
        data[8] = this.a.m20;
        data[9] = this.a.m21;
        data[10] = this.a.m22;
        data[11] = this.a.m23;
    }

    public void toMatrix(double[][] data) {
        data[0][0] = this.a.m00;
        data[0][1] = this.a.m01;
        data[0][2] = this.a.m02;
        data[0][3] = this.a.m03;
        data[1][0] = this.a.m10;
        data[1][1] = this.a.m11;
        data[1][2] = this.a.m12;
        data[1][3] = this.a.m13;
        data[2][0] = this.a.m20;
        data[2][1] = this.a.m21;
        data[2][2] = this.a.m22;
        data[2][3] = this.a.m23;
    }

    public final String toString() {
        return "3d-affine: (" + this.a.m00 + ", " + this.a.m01 + ", " + this.a.m02 + ", " + this.a.m03 + ", " + this.a.m10 + ", " + this.a.m11 + ", " + this.a.m12 + ", " + this.a.m13 + ", " + this.a.m20 + ", " + this.a.m21 + ", " + this.a.m22 + ", " + this.a.m23 + ")";
    }

    @Override
    public void set(double value, int row, int column) {
        assert (row >= 0 && row < 3 && column >= 0 && column < 4) : "Index out of bounds, a 3d affine matrix is a 3x4 matrix.";
        block0 : switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        this.a.m00 = value;
                        break block0;
                    }
                    case 1: {
                        this.a.m01 = value;
                        break block0;
                    }
                    case 2: {
                        this.a.m02 = value;
                        break block0;
                    }
                }
                this.a.m03 = value;
                break;
            }
            case 1: {
                switch (column) {
                    case 0: {
                        this.a.m10 = value;
                        break block0;
                    }
                    case 1: {
                        this.a.m11 = value;
                        break block0;
                    }
                    case 2: {
                        this.a.m12 = value;
                        break block0;
                    }
                }
                this.a.m13 = value;
                break;
            }
            default: {
                switch (column) {
                    case 0: {
                        this.a.m20 = value;
                        break block0;
                    }
                    case 1: {
                        this.a.m21 = value;
                        break block0;
                    }
                    case 2: {
                        this.a.m22 = value;
                        break block0;
                    }
                }
                this.a.m23 = value;
            }
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public void set(double ... values) {
        assert (values.length >= 12) : "Input dimensions do not match.  A 3d affine matrix is a 3x4 matrix.";
        this.a.m00 = values[0];
        this.a.m01 = values[1];
        this.a.m02 = values[2];
        this.a.m03 = values[3];
        this.a.m10 = values[4];
        this.a.m11 = values[5];
        this.a.m12 = values[6];
        this.a.m13 = values[7];
        this.a.m20 = values[8];
        this.a.m21 = values[9];
        this.a.m22 = values[10];
        this.a.m23 = values[11];
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public void set(double[][] values) {
        assert (values.length >= 3 && values[0].length >= 4 && values[1].length >= 4 && values[2].length >= 4) : "Input dimensions do not match.  A 3d affine matrix is a 3x4 matrix.";
        this.a.m00 = values[0][0];
        this.a.m01 = values[0][1];
        this.a.m02 = values[0][2];
        this.a.m03 = values[0][3];
        this.a.m10 = values[1][0];
        this.a.m11 = values[1][1];
        this.a.m12 = values[1][2];
        this.a.m13 = values[1][3];
        this.a.m20 = values[2][0];
        this.a.m21 = values[2][1];
        this.a.m22 = values[2][2];
        this.a.m23 = values[2][3];
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    public FinalRealInterval estimateBounds(RealInterval interval) {
        assert (interval.numDimensions() >= 3) : "Interval dimensions do not match.";
        double t0 = interval.realMin(0);
        double t1 = interval.realMin(1);
        double t2 = interval.realMin(2);
        double s0 = interval.realMax(0) - t0;
        double s1 = interval.realMax(1) - t1;
        double s2 = interval.realMax(2) - t2;
        double tt0 = this.a.m00 * t0 + this.a.m01 * t1 + this.a.m02 * t2 + this.a.m03;
        double tt1 = this.a.m10 * t0 + this.a.m11 * t1 + this.a.m12 * t2 + this.a.m13;
        double tt2 = this.a.m20 * t0 + this.a.m21 * t1 + this.a.m22 * t2 + this.a.m23;
        double rMin0 = tt0;
        double rMax0 = tt0;
        if (this.a.m00 < 0.0) {
            rMin0 += s0 * this.a.m00;
        } else {
            rMax0 += s0 * this.a.m00;
        }
        if (this.a.m01 < 0.0) {
            rMin0 += s1 * this.a.m01;
        } else {
            rMax0 += s1 * this.a.m01;
        }
        if (this.a.m02 < 0.0) {
            rMin0 += s2 * this.a.m02;
        } else {
            rMax0 += s2 * this.a.m02;
        }
        double rMin1 = tt1;
        double rMax1 = tt1;
        if (this.a.m10 < 0.0) {
            rMin1 += s0 * this.a.m10;
        } else {
            rMax1 += s0 * this.a.m10;
        }
        if (this.a.m11 < 0.0) {
            rMin1 += s1 * this.a.m11;
        } else {
            rMax1 += s1 * this.a.m11;
        }
        if (this.a.m12 < 0.0) {
            rMin1 += s2 * this.a.m12;
        } else {
            rMax1 += s2 * this.a.m12;
        }
        double rMin2 = tt2;
        double rMax2 = tt2;
        if (this.a.m20 < 0.0) {
            rMin2 += s0 * this.a.m20;
        } else {
            rMax2 += s0 * this.a.m20;
        }
        if (this.a.m21 < 0.0) {
            rMin2 += s1 * this.a.m21;
        } else {
            rMax2 += s1 * this.a.m21;
        }
        if (this.a.m22 < 0.0) {
            rMin2 += s2 * this.a.m22;
        } else {
            rMax2 += s2 * this.a.m22;
        }
        double[] rMin = new double[interval.numDimensions()];
        double[] rMax = new double[rMin.length];
        rMin[0] = rMin0;
        rMax[0] = rMax0;
        rMin[1] = rMin1;
        rMax[1] = rMax1;
        rMin[2] = rMin2;
        rMax[2] = rMax2;
        for (int d = 3; d < rMin.length; ++d) {
            rMin[d] = interval.realMin(d);
            rMax[d] = interval.realMax(d);
        }
        return new FinalRealInterval(rMin, rMax);
    }

    @Override
    public boolean isIdentity() {
        return RealViewsSimplifyUtils.isIdentity(this);
    }

    protected static final class AffineMatrix3D {
        public double m00;
        public double m01;
        public double m02;
        public double m03;
        public double m10;
        public double m11;
        public double m12;
        public double m13;
        public double m20;
        public double m21;
        public double m22;
        public double m23;

        public AffineMatrix3D() {
            this.m00 = 1.0;
            this.m01 = 0.0;
            this.m02 = 0.0;
            this.m03 = 0.0;
            this.m10 = 0.0;
            this.m11 = 1.0;
            this.m12 = 0.0;
            this.m13 = 0.0;
            this.m20 = 0.0;
            this.m21 = 0.0;
            this.m22 = 1.0;
            this.m23 = 0.0;
        }

        public AffineMatrix3D(double ... m) {
            assert (m.length == 12);
            this.m00 = m[0];
            this.m01 = m[1];
            this.m02 = m[2];
            this.m03 = m[3];
            this.m10 = m[4];
            this.m11 = m[5];
            this.m12 = m[6];
            this.m13 = m[7];
            this.m20 = m[8];
            this.m21 = m[9];
            this.m22 = m[10];
            this.m23 = m[11];
        }

        public AffineMatrix3D copy() {
            return new AffineMatrix3D(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23);
        }

        protected final double det() {
            return this.m00 * this.m11 * this.m22 + this.m10 * this.m21 * this.m02 + this.m20 * this.m01 * this.m12 - this.m02 * this.m11 * this.m20 - this.m12 * this.m21 * this.m00 - this.m22 * this.m01 * this.m10;
        }

        protected final void concatenate(double mm00, double mm01, double mm02, double mm03, double mm10, double mm11, double mm12, double mm13, double mm20, double mm21, double mm22, double mm23) {
            double a00 = this.m00 * mm00 + this.m01 * mm10 + this.m02 * mm20;
            double a01 = this.m00 * mm01 + this.m01 * mm11 + this.m02 * mm21;
            double a02 = this.m00 * mm02 + this.m01 * mm12 + this.m02 * mm22;
            double a03 = this.m00 * mm03 + this.m01 * mm13 + this.m02 * mm23 + this.m03;
            double a10 = this.m10 * mm00 + this.m11 * mm10 + this.m12 * mm20;
            double a11 = this.m10 * mm01 + this.m11 * mm11 + this.m12 * mm21;
            double a12 = this.m10 * mm02 + this.m11 * mm12 + this.m12 * mm22;
            double a13 = this.m10 * mm03 + this.m11 * mm13 + this.m12 * mm23 + this.m13;
            double a20 = this.m20 * mm00 + this.m21 * mm10 + this.m22 * mm20;
            double a21 = this.m20 * mm01 + this.m21 * mm11 + this.m22 * mm21;
            double a22 = this.m20 * mm02 + this.m21 * mm12 + this.m22 * mm22;
            double a23 = this.m20 * mm03 + this.m21 * mm13 + this.m22 * mm23 + this.m23;
            this.m00 = a00;
            this.m01 = a01;
            this.m02 = a02;
            this.m03 = a03;
            this.m10 = a10;
            this.m11 = a11;
            this.m12 = a12;
            this.m13 = a13;
            this.m20 = a20;
            this.m21 = a21;
            this.m22 = a22;
            this.m23 = a23;
        }

        protected final void concatenate(AffineMatrix3D m) {
            this.concatenate(m.m00, m.m01, m.m02, m.m03, m.m10, m.m11, m.m12, m.m13, m.m20, m.m21, m.m22, m.m23);
        }

        protected final void concatenate(double ... mm) {
            assert (mm.length >= 12) : "Not enough parameters for a 3d affine.";
            this.concatenate(mm[0], mm[1], mm[2], mm[3], mm[4], mm[5], mm[6], mm[7], mm[8], mm[9], mm[10], mm[11]);
        }

        protected final void preConcatenate(double mm00, double mm01, double mm02, double mm03, double mm10, double mm11, double mm12, double mm13, double mm20, double mm21, double mm22, double mm23) {
            double a00 = mm00 * this.m00 + mm01 * this.m10 + mm02 * this.m20;
            double a01 = mm00 * this.m01 + mm01 * this.m11 + mm02 * this.m21;
            double a02 = mm00 * this.m02 + mm01 * this.m12 + mm02 * this.m22;
            double a03 = mm00 * this.m03 + mm01 * this.m13 + mm02 * this.m23 + mm03;
            double a10 = mm10 * this.m00 + mm11 * this.m10 + mm12 * this.m20;
            double a11 = mm10 * this.m01 + mm11 * this.m11 + mm12 * this.m21;
            double a12 = mm10 * this.m02 + mm11 * this.m12 + mm12 * this.m22;
            double a13 = mm10 * this.m03 + mm11 * this.m13 + mm12 * this.m23 + mm13;
            double a20 = mm20 * this.m00 + mm21 * this.m10 + mm22 * this.m20;
            double a21 = mm20 * this.m01 + mm21 * this.m11 + mm22 * this.m21;
            double a22 = mm20 * this.m02 + mm21 * this.m12 + mm22 * this.m22;
            double a23 = mm20 * this.m03 + mm21 * this.m13 + mm22 * this.m23 + mm23;
            this.m00 = a00;
            this.m01 = a01;
            this.m02 = a02;
            this.m03 = a03;
            this.m10 = a10;
            this.m11 = a11;
            this.m12 = a12;
            this.m13 = a13;
            this.m20 = a20;
            this.m21 = a21;
            this.m22 = a22;
            this.m23 = a23;
        }

        protected final void preConcatenate(AffineMatrix3D m) {
            this.preConcatenate(m.m00, m.m01, m.m02, m.m03, m.m10, m.m11, m.m12, m.m13, m.m20, m.m21, m.m22, m.m23);
        }

        protected final void preConcatenate(double ... mm) {
            assert (mm.length >= 12) : "Not enough parameters for a 3d affine.";
            this.preConcatenate(mm[0], mm[1], mm[2], mm[3], mm[4], mm[5], mm[6], mm[7], mm[8], mm[9], mm[10], mm[11]);
        }

        protected final void rotateX(double dcos, double dsin) {
            double a10 = dcos * this.m10 - dsin * this.m20;
            double a11 = dcos * this.m11 - dsin * this.m21;
            double a12 = dcos * this.m12 - dsin * this.m22;
            double a13 = dcos * this.m13 - dsin * this.m23;
            double a20 = dsin * this.m10 + dcos * this.m20;
            double a21 = dsin * this.m11 + dcos * this.m21;
            double a22 = dsin * this.m12 + dcos * this.m22;
            double a23 = dsin * this.m13 + dcos * this.m23;
            this.m10 = a10;
            this.m11 = a11;
            this.m12 = a12;
            this.m13 = a13;
            this.m20 = a20;
            this.m21 = a21;
            this.m22 = a22;
            this.m23 = a23;
        }

        protected final void rotateY(double dcos, double dsin) {
            double a00 = dcos * this.m00 + dsin * this.m20;
            double a01 = dcos * this.m01 + dsin * this.m21;
            double a02 = dcos * this.m02 + dsin * this.m22;
            double a03 = dcos * this.m03 + dsin * this.m23;
            double a20 = dcos * this.m20 - dsin * this.m00;
            double a21 = dcos * this.m21 - dsin * this.m01;
            double a22 = dcos * this.m22 - dsin * this.m02;
            double a23 = dcos * this.m23 - dsin * this.m03;
            this.m00 = a00;
            this.m01 = a01;
            this.m02 = a02;
            this.m03 = a03;
            this.m20 = a20;
            this.m21 = a21;
            this.m22 = a22;
            this.m23 = a23;
        }

        protected final void rotateZ(double dcos, double dsin) {
            double a00 = dcos * this.m00 - dsin * this.m10;
            double a01 = dcos * this.m01 - dsin * this.m11;
            double a02 = dcos * this.m02 - dsin * this.m12;
            double a03 = dcos * this.m03 - dsin * this.m13;
            double a10 = dsin * this.m00 + dcos * this.m10;
            double a11 = dsin * this.m01 + dcos * this.m11;
            double a12 = dsin * this.m02 + dcos * this.m12;
            double a13 = dsin * this.m03 + dcos * this.m13;
            this.m00 = a00;
            this.m01 = a01;
            this.m02 = a02;
            this.m03 = a03;
            this.m10 = a10;
            this.m11 = a11;
            this.m12 = a12;
            this.m13 = a13;
        }

        protected final void scale(double s0, double s1, double s2) {
            this.m00 *= s0;
            this.m01 *= s0;
            this.m02 *= s0;
            this.m03 *= s0;
            this.m10 *= s1;
            this.m11 *= s1;
            this.m12 *= s1;
            this.m13 *= s1;
            this.m20 *= s2;
            this.m21 *= s2;
            this.m22 *= s2;
            this.m23 *= s2;
        }

        protected final void scale(double s) {
            this.m00 *= s;
            this.m01 *= s;
            this.m02 *= s;
            this.m03 *= s;
            this.m10 *= s;
            this.m11 *= s;
            this.m12 *= s;
            this.m13 *= s;
            this.m20 *= s;
            this.m21 *= s;
            this.m22 *= s;
            this.m23 *= s;
        }
    }
}

