/*
 * Decompiled with CFR 0.152.
 */
package marchingcubes;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import marchingcubes.MCTriangulator;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Vector3f;

public class ExportMesh_
implements PlugIn {
    public void exportToMesh(ImagePlus imagePlus, int minimumValue, int resamplingFactor, boolean[] channels, String outputFilename) {
        MCTriangulator triangulator = new MCTriangulator();
        List mesh = triangulator.getTriangles(imagePlus, minimumValue, channels, resamplingFactor);
        if (mesh.size() % 3 != 0) {
            IJ.error((String)"There weren't a multiple of 3 entries in the mesh List");
            return;
        }
        Hashtable<Point3f, Integer> pointToIndex = new Hashtable<Point3f, Integer>();
        ArrayList<Point3f> uniquePoints = new ArrayList<Point3f>();
        int i = 0;
        for (Point3f p : mesh) {
            Integer i_in_table = (Integer)pointToIndex.get(p);
            if (null != i_in_table) continue;
            pointToIndex.put(p, new Integer(i));
            uniquePoints.add(p);
            ++i;
        }
        try {
            PrintStream ps = new PrintStream(outputFilename);
            ps.println("# Almost the simplest possible Wavefront .obj file.");
            ps.println("# Generated by the ExportMesh_ plugin in ImageJ.");
            for (Point3f p : uniquePoints) {
                ps.println("v " + p.x + " " + p.y + " " + p.z);
            }
            ps.println("s 1");
            Iterator iter = mesh.iterator();
            while (iter.hasNext()) {
                Point3f p1 = (Point3f)iter.next();
                Point3f p2 = (Point3f)iter.next();
                Point3f p3 = (Point3f)iter.next();
                int i_in_table_1 = (Integer)pointToIndex.get(p1) + 1;
                int i_in_table_2 = (Integer)pointToIndex.get(p2) + 1;
                int i_in_table_3 = (Integer)pointToIndex.get(p3) + 1;
                ps.println("f " + i_in_table_1 + " " + i_in_table_2 + " " + i_in_table_3);
            }
        }
        catch (IOException e) {
            IJ.error((String)("Saving to '" + outputFilename + "' failed: " + e));
            return;
        }
    }

    public void run(String arguments) {
        SaveDialog sd;
        FileInfo info;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error((String)"ExportMesh: No images are open.");
            return;
        }
        if (wList.length < 1) {
            IJ.error((String)"ExportMesh: No images are open.");
            return;
        }
        String[] titles = new String[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
        }
        GenericDialog gd = new GenericDialog("Triangulate");
        gd.addChoice("Stack:", titles, titles[0]);
        gd.addNumericField("Threshold", 50.0, 0);
        gd.addNumericField("Resampling factor", 2.0, 0);
        gd.addMessage("Channels");
        gd.addCheckboxGroup(1, 3, new String[]{"red", "green", "blue"}, new boolean[]{true, true, true});
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int index = gd.getNextChoiceIndex();
        ImagePlus imp = WindowManager.getImage((int)wList[index]);
        int threshold = (int)gd.getNextNumber();
        int factor = (int)gd.getNextNumber();
        boolean[] channels = new boolean[]{gd.getNextBoolean(), gd.getNextBoolean(), gd.getNextBoolean()};
        if (imp == null) {
            IJ.error((String)"Must select a currently open image");
            return;
        }
        Vector3f tr = new Vector3f();
        if (imp != null) {
            Calibration c = imp.getCalibration();
            tr.x = (float)((double)(-imp.getWidth()) * c.pixelWidth / 2.0);
            tr.y = (float)((double)(-imp.getHeight()) * c.pixelHeight / 2.0);
            tr.z = (float)((double)(-imp.getStackSize()) * c.pixelDepth / 2.0);
        }
        if ((info = imp.getOriginalFileInfo()) == null) {
            sd = new SaveDialog("Save mesh as...", "mesh.obj", ".obj");
        } else {
            String fileName = info.fileName;
            String directory = info.directory;
            String suggestedSaveFilename = fileName + ".obj";
            sd = new SaveDialog("Save mesh as...", directory, suggestedSaveFilename, ".obj");
        }
        if (sd.getFileName() == null) {
            return;
        }
        String savePath = sd.getDirectory() + sd.getFileName();
        File file = new File(savePath);
        if (file != null && file.exists() && !IJ.showMessageWithCancel((String)"Save traces file...", (String)("The file " + savePath + " already exists.\nDo you want to replace it?"))) {
            return;
        }
        IJ.showStatus((String)("Saving label annotations to " + savePath));
        this.exportToMesh(imp, threshold, factor, channels, savePath);
    }
}

