/*
 * Decompiled with CFR 0.152.
 */
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.Node;
import org.scijava.java3d.RotationInterpolator;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.utils.geometry.ColorCube;
import org.scijava.java3d.utils.universe.SimpleUniverse;

public class Test_Java3D
implements PlugIn {
    public void run(String args) {
        GenericDialog gd = new GenericDialog("3D Test");
        Panel p = this.createPanel();
        gd.addPanel(p);
        gd.showDialog();
    }

    public Panel createPanel() {
        Panel p = new Panel();
        p.setPreferredSize(new Dimension(512, 512));
        p.setLayout(new BorderLayout());
        Canvas3D canvas3D = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        p.add("Center", (Component)canvas3D);
        BranchGroup scene = this.createSceneGraph();
        scene.compile();
        SimpleUniverse simpleU = new SimpleUniverse(canvas3D);
        simpleU.getViewingPlatform().setNominalViewingTransform();
        simpleU.addBranchGraph(scene);
        return p;
    }

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        Transform3D rotate = new Transform3D();
        Transform3D tempRotate = new Transform3D();
        rotate.rotX(0.7853981633974483);
        tempRotate.rotY(0.6283185307179586);
        rotate.mul(tempRotate);
        TransformGroup objRotate = new TransformGroup(rotate);
        TransformGroup objSpin = new TransformGroup();
        objSpin.setCapability(18);
        objRoot.addChild((Node)objRotate);
        objRotate.addChild((Node)objSpin);
        objSpin.addChild((Node)new ColorCube(0.4));
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 4000L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objSpin, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere();
        rotator.setSchedulingBounds((Bounds)bounds);
        objSpin.addChild((Node)rotator);
        return objRoot;
    }
}

