/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;

public class Moving_Least_Squares
implements PlugIn {
    ImagePlus image;
    public static final int AFFINE = 0;
    public static final int SIMILARITY = 1;
    public static final int RIGID = 2;

    private void need2Images() {
        IJ.showMessage((String)"Need 2 images with a point roi in each,\nwith equal number of points in each roi.");
    }

    public void run(String arg) {
        int[] ids = WindowManager.getIDList();
        if (null == ids) {
            this.need2Images();
            return;
        }
        ArrayList<ImagePlus> all = new ArrayList<ImagePlus>();
        for (int i = 0; i < ids.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)ids[i]);
            Roi roi = imp.getRoi();
            if (null == roi || !(roi instanceof PointRoi)) continue;
            all.add(imp);
        }
        if (all.size() < 2) {
            this.need2Images();
            return;
        }
        String[] titles = new String[all.size()];
        int i = 0;
        Iterator it = all.iterator();
        while (it.hasNext()) {
            titles[i++] = ((ImagePlus)it.next()).getTitle();
        }
        String[] methods = new String[]{"Affine", "Similarity", "Rigid"};
        GenericDialog gd = new GenericDialog("Align Images");
        String current = WindowManager.getCurrentImage().getTitle();
        gd.addChoice("source image", titles, current.equals(titles[0]) ? titles[1] : titles[0]);
        gd.addChoice("target image", titles, current);
        gd.addChoice("method", methods, methods[2]);
        gd.addNumericField("alpha", 1.0, 3);
        gd.addNumericField("gridSize", 0.0, 3);
        gd.addCheckbox("forward", true);
        gd.addCheckbox("merged result", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        ImagePlus source = (ImagePlus)all.get(gd.getNextChoiceIndex());
        ImagePlus target = (ImagePlus)all.get(gd.getNextChoiceIndex());
        Method method = Moving_Least_Squares.getMethod(gd.getNextChoiceIndex());
        method.alpha = (float)gd.getNextNumber();
        float gridSize = (float)gd.getNextNumber();
        boolean useForward = gd.getNextBoolean();
        boolean merge = gd.getNextBoolean();
        PointRoi points1 = (PointRoi)source.getRoi();
        PointRoi points2 = (PointRoi)target.getRoi();
        if (points1.getNCoordinates() != points2.getNCoordinates()) {
            IJ.showMessage((String)"Unequal number of points!");
            return;
        }
        ImageProcessor ip = Moving_Least_Squares.process(source, points1, target, points2, method, gridSize, useForward, merge);
        if (null != ip) {
            new ImagePlus("warped" + (useForward ? " forward" : ""), ip).show();
        }
    }

    public static ImageProcessor process(ImagePlus source, PointRoi points1, ImagePlus target, PointRoi points2, Method method, float gridSize, boolean useForward, boolean merge) {
        if (points1.getNCoordinates() != points2.getNCoordinates()) {
            IJ.log((String)"Unequal number of points!");
            return null;
        }
        Interpolator inter = source.getType() == 4 ? new ColorInterpolator(source.getProcessor()) : new BilinearInterpolator(source.getProcessor());
        ImageProcessor ip = target.getProcessor().duplicate();
        if (!merge) {
            ip.setValue(0.0);
            ip.setRoi(0, 0, ip.getWidth(), ip.getHeight());
            ip.fill();
        }
        if (useForward) {
            if (gridSize < 1.0f) {
                gridSize = 10.0f;
            }
            method.setCoordinates(points1, points2);
            method.warpImageForward(inter, (int)gridSize, ip);
        } else {
            method.setCoordinates(points2, points1);
            int w = ip.getWidth();
            int h = ip.getHeight();
            method.warpImage(inter, w, h, ip.getPixels());
            if (gridSize > 0.0f) {
                method.drawGrid(w, h, gridSize, ip.getPixels());
            }
        }
        return ip;
    }

    public static Method getMethod(int method) {
        switch (method) {
            case 0: {
                return new Affine();
            }
            case 1: {
                return new Similarity();
            }
        }
        return new Rigid();
    }

    static class ColorInterpolator
    extends Interpolator {
        ColorProcessor cp;

        public ColorInterpolator(ImageProcessor ip) {
            super(ip);
            this.cp = (ColorProcessor)ip;
        }

        @Override
        public float get(float x, float y) {
            return this.cp.getInterpolatedRGBPixel((double)x, (double)y);
        }
    }

    static class BilinearInterpolator
    extends Interpolator {
        public BilinearInterpolator(ImageProcessor ip) {
            super(ip);
        }

        @Override
        public float get(float x, float y) {
            int i = (int)x;
            int j = (int)y;
            float fx = x - (float)i;
            float fy = y - (float)j;
            float v00 = this.ip.getPixelValue(i, j);
            float v01 = this.ip.getPixelValue(i + 1, j);
            float v10 = this.ip.getPixelValue(i, j + 1);
            float v11 = this.ip.getPixelValue(i + 1, j + 1);
            return (1.0f - fx) * (1.0f - fy) * v00 + fx * (1.0f - fy) * v01 + (1.0f - fx) * fy * v10 + fx * fy * v11;
        }
    }

    static abstract class Interpolator {
        ImageProcessor ip;
        int w;
        int h;

        public Interpolator(ImageProcessor ip) {
            this.ip = ip;
            this.w = ip.getWidth();
            this.h = ip.getHeight();
        }

        public abstract float get(float var1, float var2);
    }

    static class Rigid
    extends Method {
        Rigid() {
        }

        @Override
        public void calculateM(float x, float y) {
            float mu1 = 0.0f;
            float mu2 = 0.0f;
            this.m22 = 0.0f;
            this.m21 = 0.0f;
            this.m12 = 0.0f;
            this.m11 = 0.0f;
            for (int i = 0; i < this.n; ++i) {
                float w = this.w(x, y, this.pX[i], this.pY[i]);
                float pXi = this.pX[i] - this.pCX;
                float pYi = this.pY[i] - this.pCY;
                float qXi = this.qX[i] - this.qCX;
                float qYi = this.qY[i] - this.qCY;
                this.m11 += w * (pXi * qXi + pYi * qYi);
                this.m12 += w * (pYi * qXi - pXi * qYi);
            }
            float mu = (float)Math.sqrt(this.m11 * this.m11 + this.m12 * this.m12);
            this.m11 /= mu;
            this.m12 /= mu;
            this.m21 = -this.m12;
            this.m22 = this.m11;
        }
    }

    static class Similarity
    extends Method {
        Similarity() {
        }

        @Override
        public void calculateM(float x, float y) {
            float mu = 0.0f;
            this.m22 = 0.0f;
            this.m21 = 0.0f;
            this.m12 = 0.0f;
            this.m11 = 0.0f;
            for (int i = 0; i < this.n; ++i) {
                float w = this.w(x, y, this.pX[i], this.pY[i]);
                float pXi = this.pX[i] - this.pCX;
                float pYi = this.pY[i] - this.pCY;
                float qXi = this.qX[i] - this.qCX;
                float qYi = this.qY[i] - this.qCY;
                this.m11 += w * (pXi * qXi + pYi * qYi);
                this.m12 += w * (pYi * qXi - pXi * qYi);
                mu += w * (pXi * pXi + pYi * pYi);
            }
            this.m11 /= mu;
            this.m12 /= mu;
            this.m21 = -this.m12;
            this.m22 = this.m11;
        }
    }

    static class Affine
    extends Method {
        Affine() {
        }

        @Override
        public void calculateM(float x, float y) {
            float b22 = 0.0f;
            float b21 = 0.0f;
            float b12 = 0.0f;
            float b11 = 0.0f;
            float a22 = 0.0f;
            float a12 = 0.0f;
            float a11 = 0.0f;
            for (int i = 0; i < this.n; ++i) {
                float w = this.w(x, y, this.pX[i], this.pY[i]);
                float pXi = this.pX[i] - this.pCX;
                float pYi = this.pY[i] - this.pCY;
                float qXi = this.qX[i] - this.qCX;
                float qYi = this.qY[i] - this.qCY;
                a11 += w * pXi * pXi;
                a12 += w * pXi * pYi;
                a22 += w * pYi * pYi;
                b11 += w * pXi * qXi;
                b12 += w * pXi * qYi;
                b21 += w * pYi * qXi;
                b22 += w * pYi * qYi;
            }
            float detA = a11 * a22 - a12 * a12;
            this.m11 = (a22 * b11 - a12 * b21) / detA;
            this.m12 = (-a12 * b11 + a11 * b21) / detA;
            this.m21 = (a22 * b12 - a12 * b22) / detA;
            this.m22 = (-a12 * b12 + a11 * b22) / detA;
        }
    }

    static abstract class Method {
        public float alpha = 1.0f;
        int n;
        float pCX;
        float pCY;
        float qCX;
        float qCY;
        float[] pX;
        float[] pY;
        float[] qX;
        float[] qY;
        float m11;
        float m12;
        float m21;
        float m22;
        float resultX;
        float resultY;

        Method() {
        }

        public void setCoordinates(int[] x1, int[] y1, int[] x2, int[] y2, int n) {
            this.setCoordinates(x1, y1, 0, 0, x2, y2, 0, 0, n);
        }

        public void setCoordinates(PointRoi points1, PointRoi points2) {
            Rectangle r1 = points1.getBounds();
            Rectangle r2 = points2.getBounds();
            this.setCoordinates(points1.getXCoordinates(), points1.getYCoordinates(), r1.x, r1.y, points2.getXCoordinates(), points2.getYCoordinates(), r2.x, r2.y, points1.getNCoordinates());
        }

        public void setCoordinates(int[] x1, int[] y1, int oX1, int oY1, int[] x2, int[] y2, int oX2, int oY2, int n) {
            this.n = n;
            this.pX = new float[n];
            this.pY = new float[n];
            this.qX = new float[n];
            this.qY = new float[n];
            for (int i = 0; i < n; ++i) {
                this.pX[i] = x1[i] + oX1;
                this.pY[i] = y1[i] + oY1;
                this.qX[i] = x2[i] + oX2;
                this.qY[i] = y2[i] + oY2;
            }
        }

        public void setCoordinates(float[] x1, float[] y1, float[] x2, float[] y2, int n) {
            this.n = n;
            this.pX = x1;
            this.pY = y1;
            this.qX = x2;
            this.qY = y2;
        }

        public float w(float x, float y, float px, float py) {
            if ((x -= px) == 0.0f && (y -= py) == 0.0f) {
                return 1.0E10f;
            }
            x = 1.0f / (x * x + y * y);
            if (this.alpha == 1.0f) {
                return x;
            }
            return (float)Math.exp(Math.log(x) * (double)this.alpha);
        }

        public void calculateCentroids(float x, float y) {
            this.qCY = 0.0f;
            this.qCX = 0.0f;
            this.pCY = 0.0f;
            this.pCX = 0.0f;
            float total = 0.0f;
            for (int i = 0; i < this.n; ++i) {
                float w = this.w(x, y, this.pX[i], this.pY[i]);
                total += w;
                this.pCX += w * this.pX[i];
                this.pCY += w * this.pY[i];
                this.qCX += w * this.qX[i];
                this.qCY += w * this.qY[i];
            }
            this.pCX /= total;
            this.pCY /= total;
            this.qCX /= total;
            this.qCY /= total;
        }

        public abstract void calculateM(float var1, float var2);

        public void calculate(float x, float y) {
            this.calculateCentroids(x, y);
            this.calculateM(x, y);
            this.resultX = this.qCX + this.m11 * (x - this.pCX) + this.m12 * (y - this.pCY);
            this.resultY = this.qCY + this.m21 * (x - this.pCX) + this.m22 * (y - this.pCY);
        }

        public void warpImage(Interpolator inter, int w, int h, Object pixels) {
            if (pixels instanceof byte[]) {
                this.warpImage(inter, w, h, (byte[])pixels);
            } else if (pixels instanceof short[]) {
                this.warpImage(inter, w, h, (short[])pixels);
            } else if (pixels instanceof float[]) {
                this.warpImage(inter, w, h, (float[])pixels);
            } else if (pixels instanceof int[]) {
                this.warpImage(inter, w, h, (int[])pixels);
            } else {
                IJ.error((String)"Unknown pixel type");
            }
        }

        public void warpImage(Interpolator inter, int w, int h, float[] pixels) {
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    this.calculate(i, j);
                    pixels[i + w * j] = inter.get(this.resultX, this.resultY);
                }
                IJ.showProgress((int)(j + 1), (int)h);
            }
        }

        public void warpImage(Interpolator inter, int w, int h, int[] pixels) {
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    this.calculate(i, j);
                    pixels[i + w * j] = (int)inter.get(this.resultX, this.resultY);
                }
                IJ.showProgress((int)(j + 1), (int)h);
            }
        }

        public void warpImage(Interpolator inter, int w, int h, short[] pixels) {
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    this.calculate(i, j);
                    pixels[i + w * j] = (short)inter.get(this.resultX, this.resultY);
                }
                IJ.showProgress((int)(j + 1), (int)h);
            }
        }

        public void warpImage(Interpolator inter, int w, int h, byte[] pixels) {
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    this.calculate(i, j);
                    pixels[i + w * j] = (byte)inter.get(this.resultX, this.resultY);
                }
                IJ.showProgress((int)(j + 1), (int)h);
            }
        }

        public void drawGrid(int w, int h, float step, Object pixels) {
            if (pixels instanceof byte[]) {
                this.drawGrid(w, h, step, (byte[])pixels);
            } else if (pixels instanceof short[]) {
                this.drawGrid(w, h, step, (short[])pixels);
            } else if (pixels instanceof float[]) {
                this.drawGrid(w, h, step, (float[])pixels);
            } else {
                IJ.error((String)"Unknown pixel type");
            }
        }

        boolean gridCondition(int i, int j, float step) {
            float x0 = (float)Math.floor(this.resultX / step);
            float y0 = (float)Math.floor(this.resultY / step);
            this.calculate(i, (float)j - 0.5f);
            float x1 = (float)Math.floor(this.resultX / step);
            float y1 = (float)Math.floor(this.resultY / step);
            this.calculate(i, (float)j + 0.5f);
            float x2 = (float)Math.floor(this.resultX / step);
            float y2 = (float)Math.floor(this.resultY / step);
            this.calculate((float)i + 0.5f, j);
            float x3 = (float)Math.floor(this.resultX / step);
            float y3 = (float)Math.floor(this.resultY / step);
            return x0 != x1 || x0 != x2 || x0 != x3 || y0 != y1 || y0 != y2 || y0 != y3;
        }

        public void drawGrid(int w, int h, float step, float[] pixels) {
            for (int j = 0; j < h; ++j) {
                this.calculate(-0.5f, (float)j - 0.5f);
                for (int i = 0; i < w; ++i) {
                    if (!this.gridCondition(i, j, step)) continue;
                    pixels[i + w * j] = 0.0f;
                }
                IJ.showProgress((int)(j + 1), (int)h);
            }
        }

        public void drawGrid(int w, int h, float step, short[] pixels) {
            for (int j = 0; j < h; ++j) {
                this.calculate(-0.5f, (float)j - 0.5f);
                for (int i = 0; i < w; ++i) {
                    if (!this.gridCondition(i, j, step)) continue;
                    pixels[i + w * j] = 0;
                }
                IJ.showProgress((int)(j + 1), (int)h);
            }
        }

        public void drawGrid(int w, int h, float step, byte[] pixels) {
            for (int j = 0; j < h; ++j) {
                this.calculate(-0.5f, (float)j - 0.5f);
                for (int i = 0; i < w; ++i) {
                    if (!this.gridCondition(i, j, step)) continue;
                    pixels[i + w * j] = 0;
                }
                IJ.showProgress((int)(j + 1), (int)h);
            }
        }

        void forwardQuadrilateral(Interpolator source, float[] sX, float[] sY, ImageProcessor target, int w, int h, float[] tX, float[] tY) {
            float maxY;
            float minY = maxY = tY[0];
            for (int i = 1; i < 4; ++i) {
                if (minY > tY[i]) {
                    minY = tY[i];
                    continue;
                }
                if (!(maxY < tY[i])) continue;
                maxY = tY[i];
            }
            int startY = minY < 0.0f ? 0 : (int)Math.floor(minY);
            int stopY = maxY > (float)h ? h : (int)Math.ceil(maxY);
            for (int y = startY; y < stopY; ++y) {
                float minX = w;
                float maxX = 0.0f;
                for (int i = 0; i < 4; ++i) {
                    int i1 = i == 3 ? 0 : i + 1;
                    float y1 = Math.round(tY[i]);
                    float y2 = Math.round(tY[i1]);
                    float rY = Math.round(y);
                    if ((rY - y1) * (rY - y2) > 0.0f) continue;
                    if (y1 != y2) {
                        float x = tX[i] + ((float)y - tY[i]) * (tX[i1] - tX[i]) / (tY[i1] - tY[i]);
                        if (minX > x) {
                            minX = x;
                        }
                        if (!(maxX < x)) continue;
                        maxX = x;
                        continue;
                    }
                    if (tX[i] < tX[i1]) {
                        if (minX > tX[i]) {
                            minX = tX[i];
                        }
                        if (!(maxX < tX[i1])) continue;
                        maxX = tX[i1];
                        continue;
                    }
                    if (minX > tX[i1]) {
                        minX = tX[i1];
                    }
                    if (!(maxX < tX[i])) continue;
                    maxX = tX[i];
                }
                int startX = minX < 0.0f ? 0 : (int)Math.floor(minX);
                int stopX = maxX > (float)w ? w : (int)Math.ceil(maxX);
                for (int x = startX; x < stopX; ++x) {
                    float dy;
                    float dx;
                    float a = tX[0] - (float)x;
                    float b = tX[1] - tX[0];
                    float c = tX[3] - tX[0];
                    float d = tX[2] - tX[3] - tX[1] + tX[0];
                    float e = tY[0] - (float)y;
                    float f = tY[1] - tY[0];
                    float g = tY[3] - tY[0];
                    float s = tY[2] - tY[3] - tY[1] + tY[0];
                    float p = b * s - d * f;
                    float q = b * g + a * s - d * e - c * f;
                    float r = a * g - c * e;
                    float D = q * q - 4.0f * p * r;
                    if (p == 0.0f || D < 0.0f) {
                        if (b == 0.0f) {
                            dx = 0.0f;
                            dy = -e / g;
                        } else {
                            dx = -a / c;
                            dy = 0.0f;
                        }
                    } else {
                        dx = (-q + (float)Math.sqrt(D)) / 2.0f / p;
                        dy = -(a + b * dx) / (c + d * dx);
                    }
                    float x0 = (1.0f - dx) * (1.0f - dy) * sX[0] + dx * (1.0f - dy) * sX[1] + (1.0f - dx) * dy * sX[3] + dx * dy * sX[2];
                    float y0 = (1.0f - dx) * (1.0f - dy) * sY[0] + dx * (1.0f - dy) * sY[1] + (1.0f - dx) * dy * sY[3] + dx * dy * sY[2];
                    float value = source.get(x0, y0);
                    target.setf(x, y, value);
                }
            }
        }

        public void warpImageForward(Interpolator source, int gridSize, ImageProcessor target) {
            boolean drawGrid = false;
            int w = target.getWidth();
            int h = target.getHeight();
            if (drawGrid) {
                target.setValue(0.0);
            }
            for (int y = 0; y < source.h; y += gridSize) {
                for (int x = 0; x < source.w; x += gridSize) {
                    float[] sX = new float[4];
                    float[] sY = new float[4];
                    float[] tX = new float[4];
                    float[] tY = new float[4];
                    sX[0] = x;
                    sY[0] = y;
                    sX[1] = x + gridSize;
                    sY[1] = y;
                    sX[2] = x + gridSize;
                    sY[2] = y + gridSize;
                    sX[3] = x;
                    sY[3] = y + gridSize;
                    for (int i = 0; i < 4; ++i) {
                        this.calculate(sX[i], sY[i]);
                        tX[i] = this.resultX;
                        tY[i] = this.resultY;
                    }
                    this.forwardQuadrilateral(source, sX, sY, target, w, h, tX, tY);
                    if (!drawGrid) continue;
                    target.drawLine((int)tX[0], (int)tY[0], (int)tX[1], (int)tY[1]);
                    target.drawLine((int)tX[1], (int)tY[1], (int)tX[2], (int)tY[2]);
                    target.drawLine((int)tX[2], (int)tY[2], (int)tX[3], (int)tY[3]);
                    target.drawLine((int)tX[3], (int)tY[3], (int)tX[0], (int)tY[0]);
                }
                IJ.showProgress((int)(y + gridSize), (int)source.h);
            }
        }
    }
}

