/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.operetta.utils;

import ij.ImagePlus;
import ij.ImageStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import loci.formats.meta.IMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperRange {
    private static final Logger logger = LoggerFactory.getLogger(HyperRange.class);
    private final Pattern czt_pattern = Pattern.compile(".*p(\\d*)-ch(\\d*)sk(\\d*)fk(\\d*).*");
    private final Pattern czt_pattern_archive = Pattern.compile(".*f(\\d*)p(\\d*)-ch(\\d*)t(\\d*).*");
    private List<Integer> range_c;
    private List<Integer> range_z;
    private List<Integer> range_t;
    private ImagePlus imp;

    HyperRange(List<Integer> range_c, List<Integer> range_z, List<Integer> range_t) {
        this.range_c = range_c;
        this.range_z = range_z;
        this.range_t = range_t;
        this.updateImagePlusPositions();
    }

    public static List<Integer> parseString(String s) throws NumberFormatException {
        ArrayList<Integer> range = new ArrayList<Integer>();
        String[] sr = s.split(",");
        Arrays.stream(sr).forEach(r -> {
            String[] sr2 = r.split(":");
            if (sr2.length == 2) {
                List subrange = IntStream.rangeClosed(Integer.parseInt(sr2[0].trim()), Integer.parseInt(sr2[1].trim())).boxed().collect(Collectors.toList());
                range.addAll(subrange);
            } else if (!sr2[0].isEmpty()) {
                range.add(Integer.valueOf(sr2[0].trim()));
            }
        });
        return range;
    }

    private void updateImagePlusPositions() {
        ImageStack s = ImageStack.create((int)1, (int)1, (int)this.getTotalPlanes(), (int)8);
        this.imp = new ImagePlus("", s);
        this.imp.setDimensions(this.range_c.size(), this.range_z.size(), this.range_t.size());
    }

    public void updateCRange(String new_range) {
        this.range_c = HyperRange.parseString(new_range);
        this.updateImagePlusPositions();
    }

    public void updateZRange(String new_range) {
        this.range_z = HyperRange.parseString(new_range);
        this.updateImagePlusPositions();
    }

    public void updateTRange(String new_range) {
        this.range_t = HyperRange.parseString(new_range);
        this.updateImagePlusPositions();
    }

    public int getTotalPlanes() {
        return this.range_c.size() * this.range_t.size() * this.range_z.size();
    }

    public boolean includes(String s) {
        Matcher m = this.czt_pattern.matcher(s);
        if (m.find()) {
            int c = Integer.parseInt(m.group(2));
            int z = Integer.parseInt(m.group(1));
            int t = Integer.parseInt(m.group(3));
            return this.range_c.contains(c) && this.range_z.contains(z) && this.range_t.contains(t);
        }
        m = this.czt_pattern_archive.matcher(s);
        if (m.find()) {
            int c = Integer.parseInt(m.group(3));
            int z = Integer.parseInt(m.group(2));
            int t = Integer.parseInt(m.group(4));
            return this.range_c.contains(c) && this.range_z.contains(z) && this.range_t.contains(t);
        }
        return false;
    }

    public Map<String, Integer> getIndexes(String s) {
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        Matcher m = this.czt_pattern.matcher(s);
        if (m.find()) {
            int c = Integer.parseInt(m.group(2));
            indexes.put("C", c);
            int z = Integer.parseInt(m.group(1));
            indexes.put("Z", z);
            int t = Integer.parseInt(m.group(3));
            indexes.put("T", t);
            int idx = this.imp.getStackIndex(this.range_c.indexOf(c) + 1, this.range_z.indexOf(z) + 1, this.range_t.indexOf(t) + 1);
            indexes.put("I", idx);
        } else {
            m = this.czt_pattern_archive.matcher(s);
            if (m.find()) {
                int c = Integer.parseInt(m.group(3));
                indexes.put("C", c);
                int z = Integer.parseInt(m.group(2));
                indexes.put("Z", z);
                int t = Integer.parseInt(m.group(4));
                indexes.put("T", t);
                int idx = this.imp.getStackIndex(this.range_c.indexOf(c) + 1, this.range_z.indexOf(z) + 1, this.range_t.indexOf(t) + 1);
                indexes.put("I", idx);
            }
        }
        return indexes;
    }

    public int[] getCZTDimensions() {
        return new int[]{this.range_c.size(), this.range_z.size(), this.range_t.size()};
    }

    public HyperRange confirmRange(IMetadata metadata) {
        int cs = (Integer)metadata.getPixelsSizeC(0).getValue();
        int zs = (Integer)metadata.getPixelsSizeZ(0).getValue();
        int ts = (Integer)metadata.getPixelsSizeT(0).getValue();
        this.range_c = this.range_c.stream().filter(c -> {
            boolean inside;
            boolean bl = inside = c >= 1 && c <= cs;
            if (!inside) {
                logger.info("Removed channel {} because it is not in range of data 1-{}.", c, (Object)cs);
            }
            return inside;
        }).collect(Collectors.toList());
        this.range_z = this.range_z.stream().filter(z -> {
            boolean inside;
            boolean bl = inside = z >= 1 && z <= zs;
            if (!inside) {
                logger.info("Removed slice {} because it is not in range of data 1-{}.", z, (Object)zs);
            }
            return inside;
        }).collect(Collectors.toList());
        this.range_t = this.range_t.stream().filter(t -> {
            boolean inside;
            boolean bl = inside = t >= 1 && t <= ts;
            if (!inside) {
                logger.info("Removed timepoint {} because it is not in range of data 1-{}.", t, (Object)ts);
            }
            return inside;
        }).collect(Collectors.toList());
        return this;
    }

    public List<Integer> getRangeC() {
        return this.range_c;
    }

    public void setRangeC(List<Integer> range_c) {
        this.range_c = range_c;
        this.updateImagePlusPositions();
    }

    public List<Integer> getRangeZ() {
        return this.range_z;
    }

    public void setRangeZ(List<Integer> range_z) {
        this.range_z = range_z;
        this.updateImagePlusPositions();
    }

    public List<Integer> getRangeT() {
        return this.range_t;
    }

    public void setRangeT(List<Integer> range_t) {
        this.range_t = range_t;
        this.updateImagePlusPositions();
    }

    public String toString() {
        return String.format("Range :\n\t\tC: %s\n\t\tZ: %s\n\t\tT: %s", this.range_c.toString(), this.range_z.toString(), this.range_t.toString());
    }

    public static String prettyPrint(List<Integer> list) {
        StringJoiner joiner = new StringJoiner(",");
        list.forEach(item -> joiner.add(item.toString()));
        return joiner.toString();
    }

    public static class Builder {
        private List<Integer> range_c;
        private List<Integer> range_z;
        private List<Integer> range_t;

        public Builder setRangeC(String range_str) {
            if (range_str != null) {
                this.range_c = HyperRange.parseString(range_str);
            }
            return this;
        }

        public Builder setRangeC(int start, int end) {
            this.range_c = IntStream.rangeClosed(start, end).boxed().collect(Collectors.toList());
            return this;
        }

        public Builder setRangeZ(String range_str) {
            if (range_str != null) {
                this.range_z = HyperRange.parseString(range_str);
            }
            return this;
        }

        public Builder setRangeZ(int start, int end) {
            this.range_z = IntStream.rangeClosed(start, end).boxed().collect(Collectors.toList());
            return this;
        }

        public Builder setRangeT(String range_str) {
            if (range_str != null) {
                this.range_t = HyperRange.parseString(range_str);
            }
            return this;
        }

        public Builder setRangeT(int start, int end) {
            this.range_t = IntStream.rangeClosed(start, end).boxed().collect(Collectors.toList());
            return this;
        }

        public Builder fromMetadata(IMetadata meta) {
            int c = (Integer)meta.getPixelsSizeC(0).getValue();
            int z = (Integer)meta.getPixelsSizeZ(0).getValue();
            int t = (Integer)meta.getPixelsSizeT(0).getValue();
            return this.setRangeC("1:" + c).setRangeZ("1:" + z).setRangeT("1:" + t);
        }

        public HyperRange build() {
            return new HyperRange(this.range_c, this.range_z, this.range_t);
        }
    }
}

