/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.operetta.commands;

import ch.epfl.biop.operetta.OperettaManager;
import ch.epfl.biop.operetta.utils.HyperRange;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import java.awt.Dimension;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.imagej.ImageJ;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import org.scijava.Initializable;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.command.InteractiveCommand;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.TaskService;
import org.scijava.widget.Button;

@Plugin(type=Command.class)
public class OperettaImporterInteractive
extends InteractiveCommand
implements Initializable {
    @Parameter(required=false)
    OperettaManager.Builder opm_builder;
    OperettaManager opm;
    List<String> selected_wells_string = new ArrayList<String>();
    List<String> selected_fields_string = new ArrayList<String>();
    @Parameter(label="Downsample factor", callback="updateMessage")
    int downsample = 4;
    @Parameter(label="Use averaging when downsampling", callback="updateMessage")
    boolean use_averaging = false;
    @Parameter(label="Save directory", style="directory")
    File save_directory = new File(System.getProperty("user.home") + File.separator);
    @Parameter(label="Selected Wells. Leave blank for all", callback="updateMessage", required=false, persist=false)
    private String selected_wells_str = "";
    @Parameter(label="Choose Wells", callback="wellChooser", required=false, persist=false)
    private Button choose_wells;
    @Parameter(label="Selected Fields. Leave blank for all", callback="updateMessage", required=false, persist=false)
    private String selected_fields_str = "";
    @Parameter(label="Choose Fields", callback="fieldChooser", required=false, persist=false)
    private Button choose_fields;
    @Parameter(label="Fuse Fields", callback="updateMessage", required=false)
    private FUSE_MODE fuse_mode = FUSE_MODE.NONE;
    @Parameter(label="Preview Well slice", callback="previewWell", required=false, persist=false)
    private Button open_slice;
    @Parameter(label="Flip images", callback="updateMessage", required=false)
    private FLIP_MODE flip_mode = FLIP_MODE.NONE;
    @Parameter(label="Select ranges", callback="updateMessage", visibility=ItemVisibility.MESSAGE, persist=false, required=false)
    String range = "You can use commas or colons to separate ranges. eg. '1:10' or '1,3,5,8' ";
    @Parameter(label="Select channels. Leave blank for all", callback="updateMessage", required=false)
    private String selected_channels_str = "";
    @Parameter(label="Select slices. Leave blank for all", callback="updateMessage", required=false)
    private String selected_slices_str = "";
    @Parameter(label="Select timepoints. Leave blank for all", callback="updateMessage", required=false)
    private String selected_timepoints_str = "";
    @Parameter(label="Perform projection", choices={"No Projection", "Average Intensity", "Max Intensity", "Min Intensity", "Sum Slices", "Standard Deviation", "Median"}, callback="updateMessage")
    String z_projection_method;
    @Parameter(label="Choose pixel data range", visibility=ItemVisibility.MESSAGE, persist=false, required=false)
    String norm = "Useful if you have digital phase images which could be 32-bit";
    @Parameter(label="Min Value")
    Integer norm_min = 0;
    @Parameter(label="Max Value")
    Integer norm_max = (int)Math.pow(2.0, 16.0) - 1;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false, style="message")
    String task_summary = "Summary";
    @Parameter(label="Process", callback="doProcess", persist=false)
    Button process;
    @Parameter
    TaskService taskService;

    public OperettaImporterInteractive() {
        super(new String[0]);
    }

    private String getMessage(long bytes_in, long bytes_out, String name, String oriSize, String exportSize) {
        DecimalFormat df = new DecimalFormat("#0.0");
        double gb_in = (double)bytes_in / 1.073741824E9;
        double gb_out = (double)bytes_out / 1.073741824E9;
        double theo_min_time_minutes = (gb_in + gb_out) / 0.125 / 60.0;
        String message = "<html>" + oriSize + "<br/>" + exportSize + "<br/>Operetta Dataset " + name + "<ul>";
        message = gb_in < 0.1 ? message + "<li>Read: less than 100 Mb</li>" : message + "<li>Read: " + df.format(gb_in) + " Gb</li>";
        message = gb_out < 0.1 ? message + "<li>Write: less than 100 Mb</li></ul>" : message + "<li>Write: " + df.format(gb_out) + " Gb</li></ul>";
        if (theo_min_time_minutes < 1.0) {
            message = message + "Theoretical minimal duration on Gb connection: below 1 min.<br/>";
        } else if (theo_min_time_minutes > 60.0) {
            DecimalFormat df2 = new DecimalFormat("#0");
            int nHours = (int)(theo_min_time_minutes / 60.0);
            double nMin = theo_min_time_minutes - (double)(60 * nHours);
            message = message + "Theoretical minimal duration on Gb connection: <strong>" + nHours + "h " + df2.format(nMin) + " min.</strong><br/>";
        } else {
            message = message + "Theoretical limit minimal duration on Gb connection: <strong>" + df.format(theo_min_time_minutes) + " min.</strong><br/>";
        }
        double estimated_min_time_minutes = theo_min_time_minutes * 4.0;
        if (estimated_min_time_minutes < 1.0) {
            message = message + "Estimated duration on Gb connection: <strong>below 1 min.</strong><br/>";
        } else if (estimated_min_time_minutes > 60.0) {
            DecimalFormat df2 = new DecimalFormat("#0");
            int nHours = (int)(estimated_min_time_minutes / 60.0);
            double nMin = estimated_min_time_minutes - (double)(60 * nHours);
            message = message + "Estimated duration on Gb connection: <strong>" + nHours + "h " + df2.format(nMin) + " min.</strong>";
        } else {
            message = message + "Estimated duration on Gb connection: <strong>" + df.format(estimated_min_time_minutes) + " min.</strong><br/>";
        }
        message = message + "</html>";
        return message;
    }

    private void updateMessage() {
        try {
            HyperRange range = new HyperRange.Builder().setRangeC(this.selected_channels_str).setRangeZ(this.selected_slices_str).setRangeT(this.selected_timepoints_str).build();
            double correctionFactor = Prefs.get((String)"ch.epfl.biop.operetta.correctionFactor", (double)0.995);
            this.opm = this.opm_builder.setRange(range).setDownsample(this.downsample).useAveraging(this.use_averaging).flipHorizontal(this.flip_mode.flipH).flipVertical(this.flip_mode.flipV).setProjectionMethod(this.z_projection_method).setNormalization(this.norm_min, this.norm_max).coordinatesCorrectionFactor(correctionFactor).fuseFields(this.fuse_mode.fuse_fields).useStitcher(this.fuse_mode.stitch_fields).setTaskService(this.taskService).build();
            List<String> selected_wells = this.getAvailableWellsString(this.opm);
            List<String> selected_fields = this.getAvailableFieldsString(this.opm);
            int oriWellsNumber = selected_wells.size();
            int oriFieldsNumber = selected_fields.size();
            if (!this.selected_wells_str.isEmpty()) {
                selected_wells = this.stringToList(this.selected_wells_str);
            }
            if (!this.selected_fields_str.isEmpty()) {
                selected_fields = this.stringToList(this.selected_fields_str);
            }
            List<Well> wells = selected_wells.stream().map(w -> {
                int row = this.getRow((String)w);
                int col = this.getColumn((String)w);
                return this.opm.getWell(row, col);
            }).collect(Collectors.toList());
            List<Integer> field_ids = selected_fields.stream().map(w -> Integer.parseInt(w.trim().split(" ")[1]) - 1).collect(Collectors.toList());
            long[] bytes = this.opm.getUtilities().getIOBytes(wells, field_ids);
            long[] dimsIO = this.opm.getUtilities().getIODimensions();
            String oriSize = "<strong>Original Size</strong>: W: " + oriWellsNumber + ", F:" + oriFieldsNumber + ", X:" + dimsIO[0] + ", Y:" + dimsIO[1] + ", Z:" + dimsIO[2] + ", C:" + dimsIO[3] + ", T:" + dimsIO[4];
            String exportSize = "<strong>Exported Size</strong>: W: " + selected_wells.size() + ", F:" + selected_fields.size() + ", X:" + dimsIO[5] + ", Y:" + dimsIO[6] + ", Z:" + dimsIO[7] + ", C:" + dimsIO[8] + ", T:" + dimsIO[9];
            this.task_summary = this.getMessage(bytes[0], bytes[1], this.opm.getPlateName(), oriSize, exportSize);
        }
        catch (Exception e) {
            this.task_summary = "Error " + e.getMessage();
        }
    }

    private void wellChooser() {
        this.opm = this.opm_builder.build();
        ListChooser.create("Wells", this.getAvailableWellsString(this.opm), this.selected_wells_string);
        this.selected_wells_str = this.selected_wells_string.toString();
        if (this.selected_wells_str.equals("[]")) {
            this.selected_wells_str = "";
        }
        this.updateMessage();
    }

    private void fieldChooser() {
        this.opm = this.opm_builder.build();
        ListChooser.create("Fields", this.getAvailableFieldsString(this.opm), this.selected_fields_string);
        this.selected_fields_str = this.selected_fields_string.toString();
        if (this.selected_slices_str.equals("[]")) {
            this.selected_fields_str = "";
        }
        this.updateMessage();
    }

    private List<String> stringToList(String str) {
        String[] split = str.replaceAll("\\[|\\]", "").split(",");
        return Arrays.stream(split).collect(Collectors.toList());
    }

    private void previewWell() {
        ImagePlus sample;
        this.opm = this.opm_builder.setProjectionMethod(this.z_projection_method).setDownsample(8).build();
        if (!this.selected_slices_str.isEmpty()) {
            this.opm.getRange().updateZRange(this.selected_slices_str);
        } else if (this.z_projection_method.equals("No Projection")) {
            this.opm.getRange().updateZRange("1:1");
        }
        if (!this.selected_timepoints_str.isEmpty()) {
            this.opm.getRange().updateTRange(this.selected_timepoints_str);
        } else if (this.z_projection_method.equals("No Projection")) {
            this.opm.getRange().updateTRange("1:1");
        }
        String selected_well = !this.selected_wells_str.isEmpty() ? this.stringToList(this.selected_wells_str).get(0) : this.getAvailableWellsString(this.opm).get(0);
        int row = this.getRow(selected_well);
        int col = this.getColumn(selected_well);
        Well well = this.opm.getWell(row, col);
        if (!this.fuse_mode.fuse_fields && !this.selected_fields_str.isEmpty()) {
            WellSample field = this.opm.getField(well, this.getFields().get(0));
            sample = this.opm.getFieldImage(field);
        } else {
            sample = this.opm.getWellImage(well);
        }
        sample.show();
        IJ.log((String)"Downsampled well opening done.");
        this.updateMessage();
    }

    int getRow(String well_str) {
        Pattern p = Pattern.compile("R(\\d+)-C(\\d+)");
        Matcher m = p.matcher(well_str);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return -1;
    }

    int getColumn(String well_str) {
        Pattern p = Pattern.compile("R(\\d+)-C(\\d+)");
        Matcher m = p.matcher(well_str);
        if (m.find()) {
            return Integer.parseInt(m.group(2));
        }
        return -1;
    }

    private List<Integer> getFields() {
        if (!this.selected_fields_string.isEmpty()) {
            List<Integer> field_ids = this.selected_fields_string.stream().map(w -> Integer.parseInt(w.trim().split(" ")[1]) - 1).collect(Collectors.toList());
            return field_ids;
        }
        return this.opm.getFieldIds();
    }

    public void doProcess() {
        HyperRange range = new HyperRange.Builder().setRangeC(this.selected_channels_str).setRangeZ(this.selected_slices_str).setRangeT(this.selected_timepoints_str).build();
        double correctionFactor = Prefs.get((String)"ch.epfl.biop.operetta.correctionFactor", (double)0.995);
        this.opm = this.opm_builder.setRange(range).setDownsample(this.downsample).useAveraging(this.use_averaging).setProjectionMethod(this.z_projection_method).setSaveFolder(this.save_directory).setNormalization(this.norm_min, this.norm_max).coordinatesCorrectionFactor(correctionFactor).build();
        List<String> selected_wells = this.getAvailableWellsString(this.opm);
        List<String> selected_fields = this.getAvailableFieldsString(this.opm);
        if (!this.selected_wells_str.isEmpty()) {
            selected_wells = this.stringToList(this.selected_wells_str);
        }
        if (!this.selected_fields_str.isEmpty()) {
            selected_fields = this.stringToList(this.selected_fields_str);
        }
        List wells = selected_wells.stream().map(w -> {
            int row = this.getRow((String)w);
            int col = this.getColumn((String)w);
            return this.opm.getWell(row, col);
        }).collect(Collectors.toList());
        List field_ids = selected_fields.stream().map(w -> Integer.parseInt(w.trim().split(" ")[1]) - 1).collect(Collectors.toList());
        new Thread(() -> this.opm.process(wells, field_ids, null)).start();
    }

    public List<String> getAvailableFieldsString(OperettaManager opm) {
        int n_fields = opm.getMetadata().getWellSampleCount(0, 0);
        return IntStream.range(0, n_fields).mapToObj(f -> {
            String s = "Field " + (f + 1);
            return s;
        }).collect(Collectors.toList());
    }

    public List<String> getAvailableWellsString(OperettaManager opm) {
        List<String> wells = opm.getWells().stream().map(w -> {
            int row = (Integer)w.getRow().getValue() + 1;
            int col = (Integer)w.getColumn().getValue() + 1;
            return "R" + row + "-C" + col;
        }).collect(Collectors.toList());
        return wells;
    }

    public static void main(String ... args) throws Exception {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
    }

    public void initialize() {
        this.updateMessage();
    }

    public static class ListChooser {
        public static void create(String thing_name, List<String> things, List<String> selected_things) {
            JPanel dialogPanel = new JPanel();
            BoxLayout col1Layout = new BoxLayout(dialogPanel, 3);
            JLabel label = new JLabel("Select " + thing_name + " to process:", 2);
            label.setAlignmentX(0.0f);
            label.setPreferredSize(new Dimension(50, 40));
            JList<String> list = new JList<String>(things.toArray(new String[0]));
            JScrollPane scroll_list = new JScrollPane(list);
            scroll_list.setAlignmentX(0.0f);
            scroll_list.setVerticalScrollBarPolicy(20);
            dialogPanel.setLayout(col1Layout);
            dialogPanel.add(label);
            dialogPanel.add(scroll_list);
            int result = JOptionPane.showConfirmDialog(null, dialogPanel, "Please select one or more " + thing_name, 2);
            if (result == 0) {
                int[] res = list.getSelectedIndices();
                selected_things.clear();
                selected_things.addAll(Arrays.stream(res).boxed().map(things::get).collect(Collectors.toList()));
            }
        }

        protected static void createPlate(List<Well> wells) {
            int nrows = (int)wells.stream().map(w -> (Integer)w.getRow().getValue()).distinct().count();
            int ncols = (int)wells.stream().map(w -> (Integer)w.getColumn().getValue()).distinct().count();
            Vector data = new Vector();
            Vector<String> col_names = new Vector<String>();
            for (int r = 0; r < nrows; ++r) {
                Vector<String> row = new Vector<String>();
                for (int c = 0; c < ncols; ++c) {
                    row.addElement(String.format("R%d-C%d", r, c));
                }
                data.addElement(row);
                col_names.addElement("");
            }
            JTable table = new JTable(data, col_names);
            table.setRowHeight(50);
            for (int c = 0; c < ncols; ++c) {
                table.getColumnModel().getColumn(c).setPreferredWidth(50);
            }
            DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
            centerRenderer.setHorizontalAlignment(0);
            centerRenderer.setVerticalAlignment(0);
            table.setDefaultRenderer(String.class, centerRenderer);
            table.setCellSelectionEnabled(true);
            table.setSelectionMode(2);
            table.setRowSelectionAllowed(true);
            table.setColumnSelectionAllowed(true);
            JPanel dialogPanel = new JPanel();
            dialogPanel.add(table);
            int result = JOptionPane.showConfirmDialog(null, dialogPanel, "Please select one or more elements", 2);
        }
    }

    private static enum FUSE_MODE {
        NONE("Do not fuse fields", false, false),
        NAIVE("Fuse using stage coordinates (no blending)", true, false),
        STITCHING("Fuse using 'Grid/Collection Stitching' plugin", true, true);

        final String name;
        final boolean fuse_fields;
        final boolean stitch_fields;

        private FUSE_MODE(String name, boolean fuse_fields, boolean stitch_fields) {
            this.name = name;
            this.fuse_fields = fuse_fields;
            this.stitch_fields = stitch_fields;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum FLIP_MODE {
        NONE("Do not flip", false, false),
        HORIZONTAL("Flip horizontal", true, false),
        VERTICAL("Flip vertical", false, true),
        BOTH("Flip both", true, true);

        final String name;
        final boolean flipH;
        final boolean flipV;

        private FLIP_MODE(String name, boolean flipH, boolean flipV) {
            this.name = name;
            this.flipH = flipH;
            this.flipV = flipV;
        }

        public String toString() {
            return this.name;
        }
    }
}

