/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.operetta.commands;

import ch.epfl.biop.operetta.OperettaManager;
import ch.epfl.biop.operetta.commands.OperettaImporterInteractive;
import ij.IJ;
import java.io.File;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import org.apache.commons.io.FileUtils;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP > Operetta Importer > Operetta Importer...")
public class OperettaImporter
implements Command {
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message = "BIOP Operetta Importer";
    @Parameter(label="Select the 'Images' folder of your Operetta dataset", style="directory")
    File folder;
    @Parameter
    CommandService cs;

    public void run() {
        int estimatedOpeningTimeInMin;
        XMLFILE file = null;
        for (XMLFILE version : XMLFILE.values()) {
            File candidate = new File(this.folder, version.getIndexFileName());
            if (!candidate.exists()) continue;
            file = version;
            break;
        }
        if (file == null) {
            IJ.log((String)("Error, no matching Index files found in " + this.folder.getAbsolutePath()));
            IJ.log((String)"Implemented valid Index files:");
            for (XMLFILE version : XMLFILE.values()) {
                IJ.log((String)("\t" + version.getIndexFileName() + " (" + version.getDescription() + ")"));
            }
            return;
        }
        File f = new File(this.folder, file.getIndexFileName());
        int sizeInMb = (int)((double)FileUtils.sizeOf((File)f) / 1048576.0);
        IJ.log((String)("- Opening Operetta dataset " + f.getAbsolutePath() + " (" + sizeInMb + " Mb)"));
        File fmemo = new File(this.folder, "." + file.getIndexFileName() + ".bfmemo");
        if (!fmemo.exists()) {
            estimatedOpeningTimeInMin = sizeInMb / 30;
            IJ.log((String)"- No memo file, the first opening will take longer.");
        } else {
            estimatedOpeningTimeInMin = sizeInMb / 600;
            IJ.log((String)"- Memo file detected.");
        }
        if (estimatedOpeningTimeInMin == 0) {
            IJ.log((String)"- Estimated opening time below 1 minute.");
        } else {
            IJ.log((String)("- Estimated opening time = " + estimatedOpeningTimeInMin + " min."));
        }
        IFormatReader[] reader = new IFormatReader[1];
        Thread t = new Thread(() -> {
            try {
                reader[0] = OperettaManager.Builder.createReader(f.getAbsolutePath());
            }
            catch (IOException | FormatException e) {
                e.printStackTrace();
            }
        });
        t.start();
        int countSeconds = 0;
        while (t.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                IJ.log((String)"Operetta dataset opening interrupted!");
                return;
            }
            if (++countSeconds % 20 != 0) continue;
            IJ.log((String)("- t = " + countSeconds + " s"));
        }
        if (reader[0] == null) {
            IJ.log((String)"Error during reader creation, please retry or post your issue in forum.image.sc.");
        } else {
            IJ.log((String)("Done! Opening the dataset took " + countSeconds + " s."));
            OperettaManager.Builder opmBuilder = new OperettaManager.Builder().reader(reader[0]);
            this.cs.run(OperettaImporterInteractive.class, true, new Object[]{"opm_builder", opmBuilder});
        }
    }

    private static enum XMLFILE {
        V5("Index.idx.xml", "PerkinElmer Harmony V5"),
        V5FLEX("Index.flex.xml", "PerkinElmer Harmony V5 Flatfield data"),
        V6("Index.xml", "PerkinElmer Harmony V6");

        private final String description;
        private final String indexFileName;

        private XMLFILE(String indexFileName, String description) {
            this.indexFileName = indexFileName;
            this.description = description;
        }

        private String getIndexFileName() {
            return this.indexFileName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

