/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import net.imglib2.display.RealARGBColorConverter;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;

class Instances {
    private static ClassCopyProvider<RealARGBColorConverter> provider;

    Instances() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <R extends RealType<?>> RealARGBColorConverter<R> create(R type, double min, double max) {
        if (provider != null) return (RealARGBColorConverter)provider.newInstanceForKey(type.getClass(), new Object[]{min, max});
        Class<Instances> clazz = Instances.class;
        synchronized (Instances.class) {
            if (provider != null) return (RealARGBColorConverter)provider.newInstanceForKey(type.getClass(), new Object[]{min, max});
            provider = new ClassCopyProvider(Imp.class, RealARGBColorConverter.class, new Class[]{Double.TYPE, Double.TYPE});
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return (RealARGBColorConverter)provider.newInstanceForKey(type.getClass(), new Object[]{min, max});
        }
    }

    public static class Imp<R extends RealType<?>>
    implements RealARGBColorConverter<R> {
        private double min = 0.0;
        private double max = 1.0;
        private final ARGBType color = new ARGBType(ARGBType.rgba((int)255, (int)255, (int)255, (int)255));
        private int A;
        private double scaleR;
        private double scaleG;
        private double scaleB;
        private int black;

        public Imp(double min, double max) {
            this.min = min;
            this.max = max;
            this.update();
        }

        @Override
        public ARGBType getColor() {
            return this.color.copy();
        }

        @Override
        public void setColor(ARGBType c) {
            this.color.set(c);
            this.update();
        }

        @Override
        public boolean supportsColor() {
            return true;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public void setMax(double max) {
            this.max = max;
            this.update();
        }

        public void setMin(double min) {
            this.min = min;
            this.update();
        }

        private void update() {
            double scale = 1.0 / (this.max - this.min);
            int value = this.color.get();
            this.A = ARGBType.alpha((int)value);
            this.scaleR = (double)ARGBType.red((int)value) * scale;
            this.scaleG = (double)ARGBType.green((int)value) * scale;
            this.scaleB = (double)ARGBType.blue((int)value) * scale;
            this.black = ARGBType.rgba((int)0, (int)0, (int)0, (int)this.A);
        }

        public void convert(R input, ARGBType output) {
            double v = input.getRealDouble() - this.min;
            if (v < 0.0) {
                output.set(this.black);
            } else {
                int r0 = (int)(this.scaleR * v + 0.5);
                int g0 = (int)(this.scaleG * v + 0.5);
                int b0 = (int)(this.scaleB * v + 0.5);
                int r = Math.min(255, r0);
                int g = Math.min(255, g0);
                int b = Math.min(255, b0);
                output.set(ARGBType.rgba((int)r, (int)g, (int)b, (int)this.A));
            }
        }
    }
}

